/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.block;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.controller.IMetadataQuerier;
import org.apache.tsfile.read.expression.ExpressionTree;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.query.executor.task.DeviceQueryTask;
import org.apache.tsfile.read.reader.block.TsBlockReader;
import org.apache.tsfile.read.reader.series.AbstractFileSeriesReader;
import org.apache.tsfile.read.reader.series.FileSeriesReader;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDeviceTsBlockReader
implements TsBlockReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleDeviceTsBlockReader.class);
    private final DeviceQueryTask task;
    private final ExpressionTree measurementExpression;
    private final int blockSize;
    private final TsBlock currentBlock;
    private boolean lastBlockReturned = true;
    private final Map<String, MeasurementColumnContext> measureColumnContextMap;
    private final Map<String, IdColumnContext> idColumnContextMap;
    private Long nextTime;

    public SingleDeviceTsBlockReader(DeviceQueryTask task, IMetadataQuerier metadataQuerier, IChunkLoader chunkLoader, int blockSize, ExpressionTree timeExpression, ExpressionTree measurementFilter) throws IOException {
        this.task = task;
        this.blockSize = blockSize;
        this.measurementExpression = measurementFilter;
        this.currentBlock = TsBlock.buildTsBlock(task.getColumnNames(), task.getTableSchema(), blockSize);
        this.measureColumnContextMap = new HashMap<String, MeasurementColumnContext>();
        this.idColumnContextMap = new HashMap<String, IdColumnContext>();
        List<List<IChunkMetadata>> chunkMetadataLists = metadataQuerier.getChunkMetadataLists(task.getDeviceID(), task.getColumnMapping().getMeasurementColumns(), task.getIndexRoot());
        Filter timeFilter = timeExpression == null ? null : timeExpression.toFilter();
        for (List<IChunkMetadata> chunkMetadataList : chunkMetadataLists) {
            this.constructColumnContext(chunkMetadataList, chunkLoader, timeFilter);
        }
        for (String idColumn : task.getColumnMapping().getIdColumns()) {
            List<Integer> columnPosInResult = task.getColumnMapping().getColumnPos(idColumn);
            int columnPosInId = task.getTableSchema().findIdColumnOrder(idColumn) + 1;
            this.idColumnContextMap.put(idColumn, new IdColumnContext(columnPosInResult, columnPosInId));
        }
    }

    private void constructColumnContext(List<IChunkMetadata> chunkMetadataList, IChunkLoader chunkLoader, Filter timeFilter) throws IOException {
        if (chunkMetadataList.isEmpty()) {
            return;
        }
        IChunkMetadata chunkMetadata = chunkMetadataList.get(0);
        FileSeriesReader seriesReader = new FileSeriesReader(chunkLoader, chunkMetadataList, timeFilter, false);
        if (seriesReader.hasNextBatch()) {
            if (chunkMetadata instanceof AbstractAlignedChunkMetadata) {
                List<String> currentChunkMeasurementNames = seriesReader.getCurrentChunkMeasurementNames();
                ArrayList<List<Integer>> posInResult = new ArrayList<List<Integer>>();
                for (String currentChunkMeasurementName : currentChunkMeasurementNames) {
                    posInResult.add(this.task.getColumnMapping().getColumnPos(currentChunkMeasurementName));
                }
                this.measureColumnContextMap.put("", new VectorMeasurementColumnContext(posInResult, seriesReader.nextBatch(), seriesReader));
            } else {
                String measurementUid = chunkMetadata.getMeasurementUid();
                this.measureColumnContextMap.put(measurementUid, new SingleMeasurementColumnContext(measurementUid, this.task.getColumnMapping().getColumnPos(measurementUid), seriesReader.nextBatch(), seriesReader));
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.lastBlockReturned) {
            return true;
        }
        if (this.measureColumnContextMap.isEmpty()) {
            return false;
        }
        this.currentBlock.reset();
        this.nextTime = null;
        ArrayList<MeasurementColumnContext> minTimeColumns = new ArrayList<MeasurementColumnContext>();
        while (this.currentBlock.getPositionCount() < this.blockSize) {
            for (Map.Entry<String, MeasurementColumnContext> entry : this.measureColumnContextMap.entrySet()) {
                BatchData batchData = entry.getValue().currentBatch;
                long currentTime = batchData.currentTime();
                if (this.nextTime == null || this.nextTime > currentTime) {
                    this.nextTime = currentTime;
                    minTimeColumns.clear();
                    minTimeColumns.add(entry.getValue());
                    continue;
                }
                if (this.nextTime != currentTime) continue;
                minTimeColumns.add(entry.getValue());
            }
            try {
                this.fillMeasurements(minTimeColumns);
                this.nextTime = null;
            }
            catch (IOException e) {
                LOGGER.error("Cannot fill measurements", (Throwable)e);
                return false;
            }
            if (!this.measureColumnContextMap.isEmpty()) continue;
        }
        if (this.currentBlock.getPositionCount() > 0) {
            this.fillIds();
            this.currentBlock.fillTrailingNulls();
            this.lastBlockReturned = false;
            return true;
        }
        return false;
    }

    private void fillIds() {
        for (Map.Entry<String, IdColumnContext> entry : this.idColumnContextMap.entrySet()) {
            IdColumnContext idColumnContext = entry.getValue();
            for (Integer pos : idColumnContext.posInResult) {
                Column column = this.currentBlock.getColumn(pos);
                this.fillIdColumn(column, this.task.getDeviceID().segment(idColumnContext.posInDeviceId), 0, this.currentBlock.getPositionCount());
            }
        }
    }

    private void fillMeasurements(List<MeasurementColumnContext> minTimeColumns) throws IOException {
        if (this.measurementExpression == null || this.measurementExpression.satisfy(this)) {
            int positionCount = this.currentBlock.getPositionCount();
            this.currentBlock.getTimeColumn().getLongs()[positionCount] = this.nextTime;
            for (MeasurementColumnContext columnContext : minTimeColumns) {
                columnContext.fillInto(this.currentBlock, positionCount);
                this.advanceColumn(columnContext.currentBatch, columnContext);
            }
            this.currentBlock.setPositionCount(positionCount + 1);
        } else {
            for (MeasurementColumnContext columnContext : minTimeColumns) {
                BatchData batchData = columnContext.currentBatch;
                this.advanceColumn(batchData, columnContext);
            }
        }
    }

    private void advanceColumn(BatchData batchData, MeasurementColumnContext columnContext) throws IOException {
        batchData.next();
        if (!batchData.hasCurrent()) {
            if (columnContext.seriesReader.hasNextBatch()) {
                columnContext.currentBatch = columnContext.seriesReader.nextBatch();
            } else {
                columnContext.removeFrom(this.measureColumnContextMap);
            }
        }
    }

    private void fillIdColumn(Column column, Object val, int startPos, int endPos) {
        switch (column.getDataType()) {
            case TEXT: {
                if (val instanceof String) {
                    val = new Binary((String)val, StandardCharsets.UTF_8);
                }
                Arrays.fill(column.getBinaries(), startPos, endPos, val);
                break;
            }
            case BOOLEAN: {
                Arrays.fill(column.getBooleans(), startPos, endPos, (Boolean)val);
                break;
            }
            case INT32: {
                Arrays.fill(column.getInts(), startPos, endPos, (Integer)val);
                break;
            }
            case INT64: {
                Arrays.fill(column.getLongs(), startPos, endPos, (Long)val);
                break;
            }
            case FLOAT: {
                Arrays.fill(column.getFloats(), startPos, endPos, ((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                Arrays.fill(column.getDoubles(), startPos, endPos, (Double)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type: " + (Object)((Object)column.getDataType()));
            }
        }
        column.setPositionCount(endPos);
    }

    private static void fillSingleMeasurementColumn(Column column, BatchData batchData, int pos) {
        switch (batchData.getDataType()) {
            case BOOLEAN: {
                column.getBooleans()[pos] = batchData.getBoolean();
                break;
            }
            case DOUBLE: {
                column.getDoubles()[pos] = batchData.getDouble();
                break;
            }
            case FLOAT: {
                column.getFloats()[pos] = batchData.getFloat();
                break;
            }
            case INT32: {
                column.getInts()[pos] = batchData.getInt();
                break;
            }
            case TEXT: {
                column.getBinaries()[pos] = batchData.getBinary();
                break;
            }
            case INT64: {
                column.getLongs()[pos] = batchData.getLong();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type: " + (Object)((Object)batchData.getDataType()));
            }
        }
        column.setPositionCount(pos + 1);
    }

    @Override
    public TsBlock next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastBlockReturned = true;
        return this.currentBlock;
    }

    @Override
    public void close() throws Exception {
    }

    public static class IdColumnContext {
        private final List<Integer> posInResult;
        private final int posInDeviceId;

        public IdColumnContext(List<Integer> posInResult, int posInDeviceId) {
            this.posInResult = posInResult;
            this.posInDeviceId = posInDeviceId;
        }
    }

    public static class VectorMeasurementColumnContext
    extends MeasurementColumnContext {
        private final List<List<Integer>> posInResult;

        public VectorMeasurementColumnContext(List<List<Integer>> posInResult, BatchData currentBatch, AbstractFileSeriesReader seriesReader) {
            super(seriesReader, currentBatch);
            this.posInResult = posInResult;
        }

        @Override
        void removeFrom(Map<String, MeasurementColumnContext> columnContextMap) {
            columnContextMap.remove("");
        }

        @Override
        void fillInto(TsBlock block, int blockRowNum) {
            TsPrimitiveType[] vector = this.currentBatch.getVector();
            for (int i = 0; i < vector.length; ++i) {
                TsPrimitiveType value = vector[i];
                List<Integer> columnPositions = this.posInResult.get(i);
                for (Integer pos : columnPositions) {
                    block11: {
                        block10: {
                            if (value == null) break block10;
                            switch (value.getDataType()) {
                                case TEXT: {
                                    block.getColumn((int)pos.intValue()).getBinaries()[blockRowNum] = value.getBinary();
                                    break block11;
                                }
                                case INT32: {
                                    block.getColumn((int)pos.intValue()).getInts()[blockRowNum] = value.getInt();
                                    break block11;
                                }
                                case INT64: {
                                    block.getColumn((int)pos.intValue()).getLongs()[blockRowNum] = value.getLong();
                                    break block11;
                                }
                                case BOOLEAN: {
                                    block.getColumn((int)pos.intValue()).getBooleans()[blockRowNum] = value.getBoolean();
                                    break block11;
                                }
                                case FLOAT: {
                                    block.getColumn((int)pos.intValue()).getFloats()[blockRowNum] = value.getFloat();
                                    break block11;
                                }
                                case DOUBLE: {
                                    block.getColumn((int)pos.intValue()).getDoubles()[blockRowNum] = value.getDouble();
                                    break block11;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported data type: " + (Object)((Object)value.getDataType()));
                                }
                            }
                        }
                        block.getColumn(pos).setNull(blockRowNum, blockRowNum + 1);
                    }
                    block.getColumn(pos).setPositionCount(blockRowNum + 1);
                }
            }
        }
    }

    public static class SingleMeasurementColumnContext
    extends MeasurementColumnContext {
        private final String columnName;
        private final List<Integer> posInResult;

        public SingleMeasurementColumnContext(String columnName, List<Integer> posInResult, BatchData currentBatch, AbstractFileSeriesReader seriesReader) {
            super(seriesReader, currentBatch);
            this.columnName = columnName;
            this.posInResult = posInResult;
        }

        @Override
        void removeFrom(Map<String, MeasurementColumnContext> columnContextMap) {
            columnContextMap.remove(this.columnName);
        }

        @Override
        void fillInto(TsBlock block, int position) {
            for (Integer pos : this.posInResult) {
                Column column = block.getColumn(pos);
                SingleDeviceTsBlockReader.fillSingleMeasurementColumn(column, this.currentBatch, position);
            }
        }
    }

    public static abstract class MeasurementColumnContext {
        protected BatchData currentBatch;
        protected final AbstractFileSeriesReader seriesReader;

        protected MeasurementColumnContext(AbstractFileSeriesReader seriesReader, BatchData currentBatch) {
            this.seriesReader = seriesReader;
            this.currentBatch = currentBatch;
        }

        abstract void removeFrom(Map<String, MeasurementColumnContext> var1);

        abstract void fillInto(TsBlock var1, int var2);
    }
}

