/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class CacheMetrics
implements IMetricSet {
    public static final String STORAGE_GROUP_CACHE_NAME = "Database";
    public static final String SCHEMA_PARTITION_CACHE_NAME = "SchemaPartition";
    public static final String DATA_PARTITION_CACHE_NAME = "DataPartition";
    private static final String HIT = "hit";
    private static final String ALL = "all";
    private Counter storageGroupCacheHitCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter schemaPartitionCacheHitCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter dataPartitionCacheHitCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter storageGroupCacheTotalCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter schemaPartitionCacheTotalCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter dataPartitionCacheTotalCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;

    public void bindTo(AbstractMetricService metricService) {
        this.storageGroupCacheHitCounter = metricService.getOrCreateCounter(Metric.CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), STORAGE_GROUP_CACHE_NAME, Tag.TYPE.toString(), HIT});
        this.schemaPartitionCacheHitCounter = metricService.getOrCreateCounter(Metric.CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SCHEMA_PARTITION_CACHE_NAME, Tag.TYPE.toString(), HIT});
        this.dataPartitionCacheHitCounter = metricService.getOrCreateCounter(Metric.CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), DATA_PARTITION_CACHE_NAME, Tag.TYPE.toString(), HIT});
        this.storageGroupCacheTotalCounter = metricService.getOrCreateCounter(Metric.CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), STORAGE_GROUP_CACHE_NAME, Tag.TYPE.toString(), ALL});
        this.schemaPartitionCacheTotalCounter = metricService.getOrCreateCounter(Metric.CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SCHEMA_PARTITION_CACHE_NAME, Tag.TYPE.toString(), ALL});
        this.dataPartitionCacheTotalCounter = metricService.getOrCreateCounter(Metric.CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), DATA_PARTITION_CACHE_NAME, Tag.TYPE.toString(), ALL});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        Arrays.asList(STORAGE_GROUP_CACHE_NAME, SCHEMA_PARTITION_CACHE_NAME, DATA_PARTITION_CACHE_NAME).forEach(name -> {
            metricService.remove(MetricType.COUNTER, Metric.CACHE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), HIT});
            metricService.remove(MetricType.COUNTER, Metric.CACHE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), ALL});
        });
    }

    public void record(boolean result, String name) {
        switch (name) {
            case "Database": {
                this.storageGroupCacheTotalCounter.inc();
                if (!result) break;
                this.storageGroupCacheHitCounter.inc();
                break;
            }
            case "SchemaPartition": {
                this.schemaPartitionCacheTotalCounter.inc();
                if (!result) break;
                this.schemaPartitionCacheHitCounter.inc();
                break;
            }
            case "DataPartition": {
                this.dataPartitionCacheTotalCounter.inc();
                if (!result) break;
                this.dataPartitionCacheHitCounter.inc();
                break;
            }
        }
    }
}

