/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.schemaengine.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaMetricManager;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.DataNodeSchemaQuotaManager;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.SchemaResourceManager;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionParams;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaEngine {
    private static final Logger logger = LoggerFactory.getLogger(SchemaEngine.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final SchemaRegionLoader schemaRegionLoader;
    private volatile Map<SchemaRegionId, ISchemaRegion> schemaRegionMap;
    private ScheduledExecutorService timedForceMLogThread;
    private ISchemaEngineStatistics schemaEngineStatistics;
    private SchemaMetricManager schemaMetricManager;
    private final DataNodeSchemaQuotaManager schemaQuotaManager = DataNodeSchemaQuotaManager.getInstance();

    private SchemaEngine() {
        this.schemaRegionLoader = new SchemaRegionLoader();
    }

    public static SchemaEngine getInstance() {
        return SchemaEngineManagerHolder.INSTANCE;
    }

    public void init() {
        logger.info("used schema engine mode: {}.", (Object)CommonDescriptor.getInstance().getConfig().getSchemaEngineMode());
        this.schemaRegionLoader.init(CommonDescriptor.getInstance().getConfig().getSchemaEngineMode());
        this.initSchemaEngineStatistics();
        SchemaResourceManager.initSchemaResource(this.schemaEngineStatistics);
        this.schemaMetricManager = new SchemaMetricManager(this.schemaEngineStatistics);
        this.schemaRegionMap = new ConcurrentHashMap<SchemaRegionId, ISchemaRegion>();
        this.initSchemaRegion();
        if (!config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && config.getSyncMlogPeriodInMs() != 0L) {
            this.timedForceMLogThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.SCHEMA_FORCE_MLOG.getName());
            ScheduledExecutorUtil.unsafelyScheduleAtFixedRate((ScheduledExecutorService)this.timedForceMLogThread, this::forceMlog, (long)config.getSyncMlogPeriodInMs(), (long)config.getSyncMlogPeriodInMs(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public static Map<String, List<SchemaRegionId>> getLocalSchemaRegionInfo() {
        File schemaDir = new File(config.getSchemaDir());
        File[] sgDirList = schemaDir.listFiles();
        HashMap<String, List<SchemaRegionId>> localSchemaPartitionTable = new HashMap<String, List<SchemaRegionId>>();
        if (sgDirList == null) {
            return localSchemaPartitionTable;
        }
        ExecutorService schemaRegionRecoverPools = IoTDBThreadPoolFactory.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors(), (String)ThreadName.SCHEMA_REGION_RECOVER_TASK.getName());
        ArrayList futures = new ArrayList();
        for (File file : sgDirList) {
            File[] schemaRegionDirs;
            PartialPath database;
            if (!file.isDirectory()) continue;
            try {
                database = new PartialPath(file.getName());
            }
            catch (IllegalPathException illegalPathException) {
                continue;
            }
            File sgDir = new File(config.getSchemaDir(), database.getFullPath());
            if (!sgDir.exists() || (schemaRegionDirs = sgDir.listFiles()) == null) continue;
            ArrayList<SchemaRegionId> schemaRegionIds = new ArrayList<SchemaRegionId>();
            for (File schemaRegionDir : schemaRegionDirs) {
                SchemaRegionId schemaRegionId;
                try {
                    schemaRegionId = new SchemaRegionId(Integer.parseInt(schemaRegionDir.getName()));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                schemaRegionIds.add(schemaRegionId);
            }
            localSchemaPartitionTable.put(database.getFullPath(), schemaRegionIds);
        }
        return localSchemaPartitionTable;
    }

    private void initSchemaRegion() {
        Map<String, List<SchemaRegionId>> localSchemaRegionInfo = SchemaEngine.getLocalSchemaRegionInfo();
        ExecutorService schemaRegionRecoverPools = IoTDBThreadPoolFactory.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors(), (String)ThreadName.SCHEMA_REGION_RECOVER_TASK.getName());
        ArrayList futures = new ArrayList();
        localSchemaRegionInfo.forEach((k, v) -> {
            for (SchemaRegionId schemaRegionId : v) {
                PartialPath database;
                try {
                    database = new PartialPath(k);
                }
                catch (IllegalPathException e) {
                    logger.warn("Illegal database path: {}", k);
                    continue;
                }
                futures.add(schemaRegionRecoverPools.submit(this.recoverSchemaRegionTask(database, schemaRegionId)));
            }
        });
        for (Future future : futures) {
            try {
                ISchemaRegion schemaRegion = (ISchemaRegion)future.get();
                this.schemaRegionMap.put(schemaRegion.getSchemaRegionId(), schemaRegion);
            }
            catch (InterruptedException | RuntimeException | ExecutionException e) {
                logger.error("Something wrong happened during SchemaRegion recovery", (Throwable)e);
            }
        }
        schemaRegionRecoverPools.shutdown();
    }

    private void initSchemaEngineStatistics() {
        this.schemaEngineStatistics = CommonDescriptor.getInstance().getConfig().getSchemaEngineMode().equals("Memory") ? new MemSchemaEngineStatistics() : new CachedSchemaEngineStatistics();
    }

    public void forceMlog() {
        Map<SchemaRegionId, ISchemaRegion> schemaRegionMap = this.schemaRegionMap;
        if (schemaRegionMap != null) {
            for (ISchemaRegion schemaRegion : schemaRegionMap.values()) {
                schemaRegion.forceMlog();
            }
        }
    }

    public void clear() {
        this.schemaRegionLoader.clear();
        SchemaResourceManager.clearSchemaResource();
        if (this.timedForceMLogThread != null) {
            this.timedForceMLogThread.shutdown();
            this.timedForceMLogThread = null;
        }
        if (this.schemaRegionMap != null) {
            for (ISchemaRegion schemaRegion : this.schemaRegionMap.values()) {
                schemaRegion.clear();
            }
            this.schemaRegionMap.clear();
            this.schemaRegionMap = null;
        }
        if (this.schemaMetricManager != null) {
            this.schemaMetricManager.clear();
        }
        ClusterTemplateManager.getInstance().clear();
    }

    public ISchemaRegion getSchemaRegion(SchemaRegionId regionId) {
        return this.schemaRegionMap.get(regionId);
    }

    public Collection<ISchemaRegion> getAllSchemaRegions() {
        return this.schemaRegionMap.values();
    }

    public List<SchemaRegionId> getAllSchemaRegionIds() {
        return new ArrayList<SchemaRegionId>(this.schemaRegionMap.keySet());
    }

    public synchronized void createSchemaRegion(PartialPath storageGroup, SchemaRegionId schemaRegionId) throws MetadataException {
        ISchemaRegion schemaRegion = this.schemaRegionMap.get(schemaRegionId);
        if (schemaRegion != null) {
            if (schemaRegion.getDatabaseFullPath().equals(storageGroup.getFullPath())) {
                return;
            }
            throw new MetadataException(String.format("SchemaRegion [%s] is duplicated between [%s] and [%s], and the former one has been recovered.", schemaRegionId, schemaRegion.getDatabaseFullPath(), storageGroup.getFullPath()));
        }
        this.schemaRegionMap.put(schemaRegionId, this.createSchemaRegionWithoutExistenceCheck(storageGroup, schemaRegionId));
    }

    private Callable<ISchemaRegion> recoverSchemaRegionTask(PartialPath storageGroup, SchemaRegionId schemaRegionId) {
        return () -> {
            long timeRecord = System.currentTimeMillis();
            try {
                ISchemaRegion schemaRegion = this.createSchemaRegionWithoutExistenceCheck(storageGroup, schemaRegionId);
                timeRecord = System.currentTimeMillis() - timeRecord;
                logger.info("Recover [{}] spend: {} ms", (Object)storageGroup.concatNode(schemaRegionId.toString()), (Object)timeRecord);
                return schemaRegion;
            }
            catch (MetadataException e) {
                logger.error(String.format("SchemaRegion [%d] in StorageGroup [%s] failed to recover.", schemaRegionId.getId(), storageGroup.getFullPath()));
                throw new RuntimeException(e);
            }
        };
    }

    private ISchemaRegion createSchemaRegionWithoutExistenceCheck(PartialPath database, SchemaRegionId schemaRegionId) throws MetadataException {
        SchemaRegionParams schemaRegionParams = new SchemaRegionParams(database, schemaRegionId, this.schemaEngineStatistics);
        ISchemaRegion schemaRegion = this.schemaRegionLoader.createSchemaRegion(schemaRegionParams);
        this.schemaMetricManager.addSchemaRegionMetric(schemaRegionId.getId(), schemaRegion.getSchemaRegionMetric());
        return schemaRegion;
    }

    public synchronized void deleteSchemaRegion(SchemaRegionId schemaRegionId) throws MetadataException {
        ISchemaRegion schemaRegion = this.schemaRegionMap.get(schemaRegionId);
        if (schemaRegion == null) {
            logger.warn("SchemaRegion(id = {}) has been deleted, skiped", (Object)schemaRegionId);
            return;
        }
        schemaRegion.deleteSchemaRegion();
        this.schemaMetricManager.removeSchemaRegionMetric(schemaRegionId.getId());
        this.schemaRegionMap.remove(schemaRegionId);
        File sgDir = new File(config.getSchemaDir(), schemaRegion.getDatabaseFullPath());
        File[] regionDirList = sgDir.listFiles((dir, name) -> {
            try {
                Integer.parseInt(name);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        if ((regionDirList == null || regionDirList.length == 0) && sgDir.exists()) {
            FileUtils.deleteFileOrDirectory((File)sgDir);
        }
    }

    public int getSchemaRegionNumber() {
        return this.schemaRegionMap == null ? 0 : this.schemaRegionMap.size();
    }

    public Map<Integer, Long> countDeviceNumBySchemaRegion(List<Integer> schemaIds) {
        HashMap<Integer, Long> deviceNum = new HashMap<Integer, Long>();
        this.schemaRegionMap.entrySet().stream().filter(entry -> schemaIds.contains(((SchemaRegionId)entry.getKey()).getId()) && SchemaRegionConsensusImpl.getInstance().isLeader((ConsensusGroupId)entry.getKey())).forEach(entry -> deviceNum.put(((SchemaRegionId)entry.getKey()).getId(), ((ISchemaRegion)entry.getValue()).getSchemaRegionStatistics().getDevicesNumber()));
        return deviceNum;
    }

    public Map<Integer, Long> countTimeSeriesNumBySchemaRegion(List<Integer> schemaIds) {
        HashMap<Integer, Long> timeSeriesNum = new HashMap<Integer, Long>();
        this.schemaRegionMap.entrySet().stream().filter(entry -> schemaIds.contains(((SchemaRegionId)entry.getKey()).getId()) && SchemaRegionConsensusImpl.getInstance().isLeader((ConsensusGroupId)entry.getKey())).forEach(entry -> timeSeriesNum.put(((SchemaRegionId)entry.getKey()).getId(), ((ISchemaRegion)entry.getValue()).getSchemaRegionStatistics().getSeriesNumber(false)));
        return timeSeriesNum;
    }

    public void updateAndFillSchemaCountMap(TDataNodeHeartbeatReq req, TDataNodeHeartbeatResp resp) {
        Map tmp;
        this.schemaQuotaManager.updateRemain(req.getTimeSeriesQuotaRemain(), req.isSetDeviceQuotaRemain() ? req.getDeviceQuotaRemain() : -1L);
        if (this.schemaQuotaManager.isDeviceLimit()) {
            if (resp.getRegionDeviceUsageMap() == null) {
                resp.setRegionDeviceUsageMap(new HashMap());
            }
            tmp = resp.getRegionDeviceUsageMap();
            SchemaRegionConsensusImpl.getInstance().getAllConsensusGroupIds().stream().filter(consensusGroupId -> SchemaRegionConsensusImpl.getInstance().isLeader(consensusGroupId)).forEach(consensusGroupId -> tmp.put(consensusGroupId.getId(), Optional.ofNullable(this.schemaRegionMap.get(consensusGroupId)).map(schemaRegion -> schemaRegion.getSchemaRegionStatistics().getDevicesNumber()).orElse(0L)));
        }
        if (this.schemaQuotaManager.isMeasurementLimit()) {
            if (resp.getRegionSeriesUsageMap() == null) {
                resp.setRegionSeriesUsageMap(new HashMap());
            }
            tmp = resp.getRegionSeriesUsageMap();
            SchemaRegionConsensusImpl.getInstance().getAllConsensusGroupIds().stream().filter(consensusGroupId -> SchemaRegionConsensusImpl.getInstance().isLeader(consensusGroupId)).forEach(consensusGroupId -> tmp.put(consensusGroupId.getId(), Optional.ofNullable(this.schemaRegionMap.get(consensusGroupId)).map(schemaRegion -> schemaRegion.getSchemaRegionStatistics().getSeriesNumber(false)).orElse(0L)));
        }
    }

    public ISchemaEngineStatistics getSchemaEngineStatistics() {
        return this.schemaEngineStatistics;
    }

    public ISchemaRegionMetric getSchemaRegionMetric(int schemaRegionId) {
        return this.schemaMetricManager.getSchemaRegionMetric(schemaRegionId);
    }

    private static class SchemaEngineManagerHolder {
        private static final SchemaEngine INSTANCE = new SchemaEngine();

        private SchemaEngineManagerHolder() {
        }
    }
}

