/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

public class WriteRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=671");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=673");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=672");
    private final RequestHeader requestHeader;
    private final WriteValue[] nodesToWrite;

    public WriteRequest(RequestHeader requestHeader, WriteValue[] nodesToWrite) {
        this.requestHeader = requestHeader;
        this.nodesToWrite = nodesToWrite;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public WriteValue[] getNodesToWrite() {
        return this.nodesToWrite;
    }

    protected WriteRequest(WriteRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((WriteRequestBuilder)b).requestHeader;
        this.nodesToWrite = ((WriteRequestBuilder)b).nodesToWrite;
    }

    public static WriteRequestBuilder<?, ?> builder() {
        return new WriteRequestBuilderImpl();
    }

    public WriteRequestBuilder<?, ?> toBuilder() {
        return new WriteRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteRequest)) {
            return false;
        }
        WriteRequest other = (WriteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToWrite(), other.getNodesToWrite());
    }

    protected boolean canEqual(Object other) {
        return other instanceof WriteRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToWrite());
        return result;
    }

    @Override
    public String toString() {
        return "WriteRequest(requestHeader=" + this.getRequestHeader() + ", nodesToWrite=" + Arrays.deepToString(this.getNodesToWrite()) + ")";
    }

    private static final class WriteRequestBuilderImpl
    extends WriteRequestBuilder<WriteRequest, WriteRequestBuilderImpl> {
        private WriteRequestBuilderImpl() {
        }

        @Override
        protected WriteRequestBuilderImpl self() {
            return this;
        }

        @Override
        public WriteRequest build() {
            return new WriteRequest(this);
        }
    }

    public static abstract class WriteRequestBuilder<C extends WriteRequest, B extends WriteRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private WriteValue[] nodesToWrite;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            WriteRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(WriteRequest instance, WriteRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.nodesToWrite(instance.nodesToWrite);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B nodesToWrite(WriteValue[] nodesToWrite) {
            this.nodesToWrite = nodesToWrite;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "WriteRequest.WriteRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", nodesToWrite=" + Arrays.deepToString(this.nodesToWrite) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<WriteRequest> {
        @Override
        public Class<WriteRequest> getType() {
            return WriteRequest.class;
        }

        @Override
        public WriteRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            WriteValue[] nodesToWrite = (WriteValue[])decoder.readStructArray("NodesToWrite", WriteValue.TYPE_ID);
            return new WriteRequest(requestHeader, nodesToWrite);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, WriteRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("NodesToWrite", (Object[])value.getNodesToWrite(), WriteValue.TYPE_ID);
        }
    }
}

