/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEventFactory;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.PipeDataRegionAssigner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class PipeInsertionDataNodeListener {
    private final ConcurrentMap<String, PipeDataRegionAssigner> dataRegionId2Assigner = new ConcurrentHashMap<String, PipeDataRegionAssigner>();
    private final AtomicInteger listenToTsFileExtractorCount = new AtomicInteger(0);
    private final AtomicInteger listenToInsertNodeExtractorCount = new AtomicInteger(0);

    public synchronized void startListenAndAssign(String dataRegionId, PipeRealtimeDataRegionExtractor extractor) {
        this.dataRegionId2Assigner.computeIfAbsent(dataRegionId, o -> new PipeDataRegionAssigner(dataRegionId)).startAssignTo(extractor);
        if (extractor.isNeedListenToTsFile()) {
            this.listenToTsFileExtractorCount.incrementAndGet();
        }
        if (extractor.isNeedListenToInsertNode()) {
            this.listenToInsertNodeExtractorCount.incrementAndGet();
        }
    }

    public synchronized void stopListenAndAssign(String dataRegionId, PipeRealtimeDataRegionExtractor extractor) {
        PipeDataRegionAssigner assigner = (PipeDataRegionAssigner)this.dataRegionId2Assigner.get(dataRegionId);
        if (assigner == null) {
            return;
        }
        assigner.stopAssignTo(extractor);
        if (extractor.isNeedListenToTsFile()) {
            this.listenToTsFileExtractorCount.decrementAndGet();
        }
        if (extractor.isNeedListenToInsertNode()) {
            this.listenToInsertNodeExtractorCount.decrementAndGet();
        }
        if (assigner.notMoreExtractorNeededToBeAssigned()) {
            this.dataRegionId2Assigner.remove(dataRegionId);
            assigner.close();
        }
    }

    public void listenToTsFile(String dataRegionId, TsFileResource tsFileResource, boolean isLoaded) {
        PipeDataRegionAssigner assigner = (PipeDataRegionAssigner)this.dataRegionId2Assigner.get(dataRegionId);
        if (assigner == null) {
            return;
        }
        assigner.publishToAssign(PipeRealtimeEventFactory.createRealtimeEvent(tsFileResource, isLoaded));
    }

    public void listenToInsertNode(String dataRegionId, InsertNode insertNode, TsFileResource tsFileResource) {
        if (this.listenToInsertNodeExtractorCount.get() == 0) {
            return;
        }
        PipeDataRegionAssigner assigner = (PipeDataRegionAssigner)this.dataRegionId2Assigner.get(dataRegionId);
        if (assigner == null) {
            return;
        }
        assigner.publishToAssign(PipeRealtimeEventFactory.createRealtimeEvent(insertNode, tsFileResource));
    }

    public void listenToHeartbeat(boolean shouldPrintMessage) {
        this.dataRegionId2Assigner.forEach((key, value) -> value.publishToAssign(PipeRealtimeEventFactory.createRealtimeEvent(key, shouldPrintMessage)));
    }

    public void listenToDeleteData(DeleteDataNode node) {
        this.dataRegionId2Assigner.forEach((key, value) -> value.publishToAssign(PipeRealtimeEventFactory.createRealtimeEvent(node)));
    }

    private PipeInsertionDataNodeListener() {
        PipeDataNodeAgent.runtime().registerPeriodicalJob("PipeInsertionDataNodeListener#listenToHeartbeat(false)", () -> this.listenToHeartbeat(false), PipeConfig.getInstance().getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds());
    }

    public static PipeInsertionDataNodeListener getInstance() {
        return PipeChangeDataCaptureListenerHolder.INSTANCE;
    }

    private static class PipeChangeDataCaptureListenerHolder {
        private static final PipeInsertionDataNodeListener INSTANCE = new PipeInsertionDataNodeListener();

        private PipeChangeDataCaptureListenerHolder() {
        }
    }
}

