/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.client.PayloadOutputChannel;
import org.apache.ignite3.internal.client.WriteContext;
import org.apache.ignite3.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite3.internal.client.proto.ClientMessageCommon;
import org.apache.ignite3.internal.client.proto.ClientMessagePacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.table.ClientColumn;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.client.table.ClientTuple;
import org.apache.ignite3.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite3.internal.client.tx.DirectTxUtils;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.UnmappedColumnsException;
import org.apache.ignite3.internal.util.HashCalculator;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.TupleHelper;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientTupleSerializer {
    private final int tableId;

    ClientTupleSerializer(int tableId) {
        this.tableId = tableId;
    }

    void writeTuple(@Nullable Transaction tx, Tuple tuple, ClientSchema schema, PayloadOutputChannel out, WriteContext ctx) {
        this.writeTuple(tx, tuple, schema, out, ctx, false, false);
    }

    void writeTuple(@Nullable Transaction tx, Tuple tuple, ClientSchema schema, PayloadOutputChannel out, WriteContext ctx, boolean keyOnly) {
        this.writeTuple(tx, tuple, schema, out, ctx, keyOnly, false);
    }

    void writeTuple(@Nullable Transaction tx, Tuple tuple, ClientSchema schema, PayloadOutputChannel out, WriteContext ctx, boolean keyOnly, boolean skipHeader) {
        if (!skipHeader) {
            out.out().packInt(this.tableId);
            DirectTxUtils.writeTx(tx, out, ctx);
            out.out().packInt(schema.version());
        }
        ClientTupleSerializer.writeTupleRaw(tuple, schema, out, keyOnly);
    }

    public static void writeTupleRaw(Tuple tuple, ClientSchema schema, PayloadOutputChannel out, boolean keyOnly) {
        ClientColumn[] columns = keyOnly ? schema.keyColumns() : schema.columns();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(columns.length);
        BitSet noValueSet = new BitSet(columns.length);
        int usedCols = 0;
        for (ClientColumn col : columns) {
            Object v = TupleHelper.valueOrDefault(tuple, col.name(), ClientMessageCommon.NO_VALUE);
            if (v != ClientMessageCommon.NO_VALUE) {
                ++usedCols;
            }
            ClientTupleSerializer.appendValue(builder, noValueSet, col, v);
        }
        if (!keyOnly && tuple.columnCount() > usedCols) {
            ClientTupleSerializer.throwSchemaMismatchException(tuple, schema, TuplePart.KEY_AND_VAL);
        }
        out.out().packBinaryTuple(builder, noValueSet);
    }

    void writeKvTuple(@Nullable Transaction tx, Tuple key, @Nullable Tuple val, ClientSchema schema, PayloadOutputChannel out, WriteContext ctx, boolean skipHeader) {
        if (!skipHeader) {
            out.out().packInt(this.tableId);
            DirectTxUtils.writeTx(tx, out, ctx);
            out.out().packInt(schema.version());
        }
        ClientColumn[] columns = schema.columns();
        BitSet noValueSet = new BitSet(columns.length);
        BinaryTupleBuilder builder = new BinaryTupleBuilder(columns.length);
        int usedKeyCols = 0;
        int usedValCols = 0;
        for (ClientColumn col : columns) {
            Object v;
            if (col.key()) {
                v = TupleHelper.valueOrDefault(key, col.name(), ClientMessageCommon.NO_VALUE);
                if (v != ClientMessageCommon.NO_VALUE) {
                    ++usedKeyCols;
                }
            } else {
                Object object = v = val != null ? TupleHelper.valueOrDefault(val, col.name(), ClientMessageCommon.NO_VALUE) : ClientMessageCommon.NO_VALUE;
                if (v != ClientMessageCommon.NO_VALUE) {
                    ++usedValCols;
                }
            }
            ClientTupleSerializer.appendValue(builder, noValueSet, col, v);
        }
        if (key.columnCount() > usedKeyCols) {
            ClientTupleSerializer.throwSchemaMismatchException(key, schema, TuplePart.KEY);
        }
        if (val != null && val.columnCount() > usedValCols) {
            ClientTupleSerializer.throwSchemaMismatchException(val, schema, TuplePart.VAL);
        }
        out.out().packBinaryTuple(builder, noValueSet);
    }

    void writeKvTuples(@Nullable Transaction tx, Collection<Map.Entry<Tuple, Tuple>> pairs, ClientSchema schema, PayloadOutputChannel out, WriteContext ctx) {
        out.out().packInt(this.tableId);
        DirectTxUtils.writeTx(tx, out, ctx);
        out.out().packInt(schema.version());
        out.out().packInt(pairs.size());
        for (Map.Entry<Tuple, Tuple> pair : pairs) {
            this.writeKvTuple(tx, pair.getKey(), pair.getValue(), schema, out, ctx, true);
        }
    }

    void writeStreamerKvTuples(int partitionId, Collection<Map.Entry<Tuple, Tuple>> pairs, @Nullable BitSet deleted, ClientSchema schema, PayloadOutputChannel out) {
        ClientMessagePacker w = out.out();
        w.packInt(this.tableId);
        w.packInt(partitionId);
        w.packBitSetNullable(deleted);
        w.packInt(schema.version());
        w.packInt(pairs.size());
        int i = 0;
        for (Map.Entry<Tuple, Tuple> pair : pairs) {
            boolean del;
            boolean bl = del = deleted != null && deleted.get(i++);
            if (del) {
                this.writeTuple(null, pair.getKey(), schema, out, null, true, true);
                continue;
            }
            this.writeKvTuple(null, pair.getKey(), pair.getValue(), schema, out, null, true);
        }
    }

    void writeTuples(@Nullable Transaction tx, Collection<Tuple> tuples, ClientSchema schema, PayloadOutputChannel out, WriteContext ctx, boolean keyOnly) {
        out.out().packInt(this.tableId);
        DirectTxUtils.writeTx(tx, out, ctx);
        out.out().packInt(schema.version());
        out.out().packInt(tuples.size());
        for (Tuple tuple : tuples) {
            this.writeTuple(tx, tuple, schema, out, ctx, keyOnly, true);
        }
    }

    void writeStreamerTuples(int partitionId, Collection<Tuple> tuples, @Nullable BitSet deleted, ClientSchema schema, PayloadOutputChannel out) {
        ClientMessagePacker w = out.out();
        w.packInt(this.tableId);
        w.packInt(partitionId);
        w.packBitSetNullable(deleted);
        w.packInt(schema.version());
        w.packInt(tuples.size());
        int i = 0;
        for (Tuple tuple : tuples) {
            boolean keyOnly = deleted != null && deleted.get(i++);
            this.writeTuple(null, tuple, schema, out, null, keyOnly, true);
        }
    }

    static Tuple readTuple(ClientSchema schema, ClientMessageUnpacker in, boolean keyOnly) {
        ClientColumn[] columns = keyOnly ? schema.keyColumns() : schema.columns();
        BinaryTupleReader binTuple = new BinaryTupleReader(columns.length, in.readBinary());
        return new ClientTuple(schema, keyOnly ? TuplePart.KEY : TuplePart.KEY_AND_VAL, binTuple);
    }

    static Tuple readValueTuple(ClientSchema schema, ClientMessageUnpacker in) {
        BinaryTupleReader binTuple = new BinaryTupleReader(schema.columns().length, in.readBinary());
        return new ClientTuple(schema, TuplePart.VAL, binTuple);
    }

    private static IgniteBiTuple<Tuple, Tuple> readKvTuple(ClientSchema schema, ClientMessageUnpacker in) {
        BinaryTupleReader binTuple = new BinaryTupleReader(schema.columns().length, in.readBinary());
        ClientTuple keyTuple = new ClientTuple(schema, TuplePart.KEY, binTuple);
        ClientTuple valTuple = new ClientTuple(schema, TuplePart.VAL, binTuple);
        return new IgniteBiTuple<Tuple, Tuple>(keyTuple, valTuple);
    }

    static Map<Tuple, Tuple> readKvTuplesNullable(ClientSchema schema, ClientMessageUnpacker in) {
        int cnt = in.unpackInt();
        HashMap<Tuple, Tuple> res = new HashMap<Tuple, Tuple>(cnt);
        for (int i = 0; i < cnt; ++i) {
            boolean hasValue = in.unpackBoolean();
            if (!hasValue) continue;
            IgniteBiTuple<Tuple, Tuple> pair = ClientTupleSerializer.readKvTuple(schema, in);
            res.put(pair.get1(), pair.get2());
        }
        return res;
    }

    static List<Tuple> readTuples(ClientSchema schema, ClientMessageUnpacker in) {
        return ClientTupleSerializer.readTuples(schema, in, false);
    }

    static List<Tuple> readTuples(ClientSchema schema, ClientMessageUnpacker in, boolean keyOnly) {
        int cnt = in.unpackInt();
        ArrayList<Tuple> res = new ArrayList<Tuple>(cnt);
        for (int i = 0; i < cnt; ++i) {
            res.add(ClientTupleSerializer.readTuple(schema, in, keyOnly));
        }
        return res;
    }

    static List<Tuple> readTuplesNullable(ClientSchema schema, ClientMessageUnpacker in) {
        int cnt = in.unpackInt();
        ArrayList<Tuple> res = new ArrayList<Tuple>(cnt);
        for (int i = 0; i < cnt; ++i) {
            Tuple tuple = in.unpackBoolean() ? ClientTupleSerializer.readTuple(schema, in, false) : null;
            res.add(tuple);
        }
        return res;
    }

    private static void appendValue(BinaryTupleBuilder builder, BitSet noValueSet, ClientColumn col, @Nullable Object v) {
        if (v == ClientMessageCommon.NO_VALUE) {
            noValueSet.set(col.schemaIndex());
            builder.appendNull();
            return;
        }
        ClientBinaryTupleUtils.appendValue(builder, col.type(), col.name(), col.scale(), v);
    }

    public static PartitionAwarenessProvider getPartitionAwarenessProvider(Tuple rec) {
        return PartitionAwarenessProvider.of(schema -> ClientTupleSerializer.getColocationHash(schema, rec));
    }

    public static PartitionAwarenessProvider getPartitionAwarenessProvider(Mapper<?> m, Object rec) {
        assert (!(rec instanceof Collection));
        return PartitionAwarenessProvider.of(schema -> ClientTupleSerializer.getColocationHash(schema, m, rec));
    }

    public static int getColocationHash(ClientSchema schema, Tuple rec) {
        HashCalculator hashCalc = new HashCalculator();
        for (ClientColumn col : schema.colocationColumns()) {
            Object value = TupleHelper.valueOrDefault(rec, col.name(), null);
            hashCalc.append(value, col.scale(), col.precision());
        }
        return hashCalc.hash();
    }

    static int getColocationHash(ClientSchema schema, Mapper<?> mapper, Object rec) {
        HashCalculator hashCalc = new HashCalculator();
        Marshaller marsh = schema.getMarshaller(mapper, TuplePart.KEY, true);
        for (ClientColumn col : schema.colocationColumns()) {
            Object value = marsh.value(rec, col.keyIndex());
            hashCalc.append(value, col.scale(), col.precision());
        }
        return hashCalc.hash();
    }

    private static void throwSchemaMismatchException(Tuple tuple, ClientSchema schema, TuplePart part) {
        HashSet<String> extraColumns = new HashSet<String>();
        for (int i = 0; i < tuple.columnCount(); ++i) {
            extraColumns.add(tuple.columnName(i));
        }
        for (ClientColumn col : schema.columns(part)) {
            extraColumns.remove(col.name());
        }
        String prefix = "Tuple";
        if (part == TuplePart.KEY) {
            prefix = "Key tuple";
        } else if (part == TuplePart.VAL) {
            prefix = "Value tuple";
        }
        throw new IllegalArgumentException(String.format("%s doesn't match schema: schemaVersion=%s, extraColumns=%s", prefix, schema.version(), extraColumns), new UnmappedColumnsException());
    }
}

