/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.treesitter.parser;

import org.treesitter.TSNode;

public enum SqlTokenType {
    KEYWORD,
    IDENTIFIER,
    STAR,
    LITERAL,
    BRACKET,
    SPACE,
    COMMA,
    EQUAL,
    SEMICOLON,
    UNKNOWN;


    static SqlTokenType fromNode(TSNode node) {
        String type = node.getType();
        if (type == null) {
            return UNKNOWN;
        }
        switch (type) {
            case "keyword": {
                return KEYWORD;
            }
            case "identifier": {
                return IDENTIFIER;
            }
            case "literal": {
                return LITERAL;
            }
            case "(": 
            case ")": {
                return BRACKET;
            }
            case ",": {
                return COMMA;
            }
            case "*": {
                return STAR;
            }
            case "=": {
                return EQUAL;
            }
            case ";": {
                return SEMICOLON;
            }
        }
        if (type.startsWith("keyword")) {
            return KEYWORD;
        }
        return UNKNOWN;
    }
}

