/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.adaptive;

import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.loadbalancing.adaptive.AdaptiveLoadProbe;

public class AdaptiveProcessingTimeLoadProbe
implements AdaptiveLoadProbe {
    private boolean useAvg = true;

    public AdaptiveProcessingTimeLoadProbe() {
    }

    public AdaptiveProcessingTimeLoadProbe(boolean useAvg) {
        this.useAvg = useAvg;
    }

    public boolean isUseAverage() {
        return this.useAvg;
    }

    public void setUseAverage(boolean useAvg) {
        this.useAvg = useAvg;
    }

    @Override
    public double getLoad(ClusterNode node, int jobsSentSinceLastUpdate) {
        double load;
        ClusterMetrics metrics = node.metrics();
        if (this.useAvg && (load = metrics.getAverageJobExecuteTime() + metrics.getAverageJobWaitTime()) > 0.0) {
            return load;
        }
        load = metrics.getCurrentJobExecuteTime() + metrics.getCurrentJobWaitTime();
        return load < 0.0 ? 0.0 : load;
    }

    public String toString() {
        return S.toString(AdaptiveProcessingTimeLoadProbe.class, this);
    }
}

