/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateAware;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDistributedTxFinishRequest
extends GridDistributedBaseMessage
implements IgniteTxStateAware {
    private static final long serialVersionUID = 0L;
    protected static final int WAIT_REMOTE_TX_FLAG_MASK = 1;
    protected static final int CHECK_COMMITTED_FLAG_MASK = 2;
    protected static final int NEED_RETURN_VALUE_FLAG_MASK = 4;
    protected static final int SYS_INVALIDATE_FLAG_MASK = 8;
    protected static final int EXPLICIT_LOCK_FLAG_MASK = 16;
    protected static final int STORE_ENABLED_FLAG_MASK = 32;
    private AffinityTopologyVersion topVer;
    private IgniteUuid futId;
    private long threadId;
    private GridCacheVersion commitVer;
    private boolean invalidate;
    private boolean commit;
    private GridCacheVersion baseVer;
    private int txSize;
    private boolean sys;
    private byte plc;
    private int taskNameHash;
    private byte flags;
    private CacheWriteSynchronizationMode syncMode;
    @GridDirectTransient
    private IgniteTxState txState;

    public GridDistributedTxFinishRequest() {
    }

    public GridDistributedTxFinishRequest(GridCacheVersion xidVer, IgniteUuid futId, @NotNull AffinityTopologyVersion topVer, @Nullable GridCacheVersion commitVer, long threadId, boolean commit, boolean invalidate, boolean sys, byte plc, CacheWriteSynchronizationMode syncMode, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, int taskNameHash, int txSize, boolean addDepInfo) {
        super(xidVer, 0, addDepInfo);
        assert (xidVer != null);
        assert (syncMode != null);
        this.futId = futId;
        this.topVer = topVer;
        this.commitVer = commitVer;
        this.threadId = threadId;
        this.commit = commit;
        this.invalidate = invalidate;
        this.sys = sys;
        this.plc = plc;
        this.syncMode = syncMode;
        this.baseVer = baseVer;
        this.taskNameHash = taskNameHash;
        this.txSize = txSize;
        this.completedVersions(committedVers, rolledbackVers);
    }

    public final CacheWriteSynchronizationMode syncMode() {
        return this.syncMode;
    }

    protected final void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    protected final boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public final int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public final AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public boolean system() {
        return this.sys;
    }

    public byte policy() {
        return this.plc;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public long threadId() {
        return this.threadId;
    }

    public GridCacheVersion commitVersion() {
        return this.commitVer;
    }

    public boolean commit() {
        return this.commit;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public GridCacheVersion baseVersion() {
        return this.baseVer;
    }

    public int txSize() {
        return this.txSize;
    }

    public boolean replyRequired() {
        assert (this.syncMode != null);
        return this.syncMode == CacheWriteSynchronizationMode.FULL_SYNC;
    }

    @Override
    public IgniteTxState txState() {
        return this.txState;
    }

    @Override
    public void txState(IgniteTxState txState) {
        this.txState = txState;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext<?, ?> ctx) {
        return ctx.txFinishMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 8: {
                if (!writer.writeMessage("baseVer", this.baseVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeBoolean("commit", this.commit)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("commitVer", this.commitVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeBoolean("invalidate", this.invalidate)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeByte("plc", this.plc)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeByte("syncMode", this.syncMode != null ? (byte)this.syncMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeBoolean("sys", this.sys)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeInt("txSize", this.txSize)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 8: {
                this.baseVer = (GridCacheVersion)reader.readMessage("baseVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.commit = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.commitVer = (GridCacheVersion)reader.readMessage("commitVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.invalidate = reader.readBoolean("invalidate");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.plc = reader.readByte("plc");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                byte syncModeOrd = reader.readByte("syncMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.syncMode = CacheWriteSynchronizationMode.fromOrdinal(syncModeOrd);
                reader.incrementState();
            }
            case 16: {
                this.sys = reader.readBoolean("sys");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.txSize = reader.readInt("txSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedTxFinishRequest.class);
    }

    @Override
    public short directType() {
        return 23;
    }

    @Override
    public byte fieldsCount() {
        return 21;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDistributedTxFinishRequest.class, this, "super", (Object)super.toString());
    }
}

