/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.runtime.ResourceInfo;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.dto.BuilderConstants;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;

public final class ResourceDTOBuilder {
    public static ResourceDTO build(ServletHandler handler, int reason) {
        ResourceDTO dto = ResourceDTOBuilder.build(handler.getServletInfo(), reason != -1);
        dto.servletContextId = handler.getContextServiceId();
        if (reason != -1) {
            ((FailedResourceDTO)dto).failureReason = reason;
        }
        return dto;
    }

    public static ResourceDTO build(ServletInfo info, boolean failed) {
        ResourceDTO dto = failed ? new FailedResourceDTO() : new ResourceDTO();
        dto.patterns = BuilderConstants.EMPTY_STRING_ARRAY;
        dto.prefix = info.getPrefix();
        dto.serviceId = info.getServiceId();
        return dto;
    }

    public static ResourceDTO build(ResourceInfo info, boolean failed) {
        ResourceDTO dto = failed ? new FailedResourceDTO() : new ResourceDTO();
        dto.patterns = BuilderConstants.copyWithDefault(info.getPatterns(), BuilderConstants.EMPTY_STRING_ARRAY);
        dto.prefix = info.getPrefix();
        dto.serviceId = info.getServiceId();
        return dto;
    }
}

