/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.BytesCompactCompressedHashIterator;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.WrappedCompactSketch;

final class WrappedCompactCompressedSketch
extends WrappedCompactSketch {
    private static final int START_PACKED_DATA_EXACT_MODE = 8;
    private static final int START_PACKED_DATA_ESTIMATION_MODE = 16;

    WrappedCompactCompressedSketch(byte[] bytes) {
        super(bytes);
    }

    static WrappedCompactCompressedSketch wrapInstance(byte[] bytes, short seedHash) {
        Util.checkSeedHashes(ByteArrayUtil.getShortLE(bytes, 6), seedHash);
        return new WrappedCompactCompressedSketch(bytes);
    }

    @Override
    public int getCurrentBytes() {
        byte preLongs = this.bytes_[0];
        byte entryBits = this.bytes_[3];
        byte numEntriesBytes = this.bytes_[4];
        return preLongs * 8 + numEntriesBytes + PreambleUtil.wholeBytesToHoldBits(this.getRetainedEntries() * entryBits);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        byte preLongs = this.bytes_[0];
        int numEntriesBytes = this.bytes_[4];
        int offsetBytes = preLongs > 1 ? 16 : 8;
        int numEntries = 0;
        for (int i = 0; i < numEntriesBytes; ++i) {
            numEntries |= Byte.toUnsignedInt(this.bytes_[offsetBytes++]) << (i << 3);
        }
        return numEntries;
    }

    @Override
    public long getThetaLong() {
        byte preLongs = this.bytes_[0];
        return preLongs > 1 ? ByteArrayUtil.getLongLE(this.bytes_, 8) : Long.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public HashIterator iterator() {
        return new BytesCompactCompressedHashIterator(this.bytes_, (this.bytes_[0] > 1 ? 16 : 8) + this.bytes_[4], this.bytes_[3], this.getRetainedEntries());
    }
}

