/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.ThetaIntersectionImpl;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.WrappedCompactCompressedSketch;
import org.apache.datasketches.theta.WrappedCompactSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CompactSketchTest {
    private static final boolean COMPACT = true;
    private static final boolean EMPTY = true;
    private static final boolean DIRECT = true;
    private static final boolean SEGMENT = true;
    private static final boolean ORDERED = true;
    private static final boolean ESTIMATION = true;

    @Test
    public void checkHeapifyWrap() {
        int k = 4096;
        boolean ordered = true;
        this.checkHeapifyWrap(4096, 0, true);
        this.checkHeapifyWrap(4096, 1, true);
        this.checkHeapifyWrap(4096, 1, false);
        this.checkHeapifyWrap(4096, 4096, true);
        this.checkHeapifyWrap(4096, 4096, false);
        this.checkHeapifyWrap(4096, 16384, true);
        this.checkHeapifyWrap(4096, 16384, false);
    }

    public void checkHeapifyWrap(int k, int u, boolean ordered) {
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch refSk = usk.compact(ordered, null);
        byte[] barr = refSk.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(barr);
        CompactThetaSketch testSk = (CompactThetaSketch)ThetaSketch.heapify((MemorySegment)srcSeg);
        CompactSketchTest.checkByRange((ThetaSketch)refSk, (ThetaSketch)testSk, u, ordered);
        byte[] byteArray = refSk.toByteArray();
        MemorySegment heapROSeg = MemorySegment.ofArray(byteArray).asReadOnly();
        testSk = (CompactThetaSketch)ThetaSketch.heapify((MemorySegment)heapROSeg);
        CompactSketchTest.checkByRange((ThetaSketch)refSk, (ThetaSketch)testSk, u, ordered);
        int bytes = usk.getCompactBytes();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment directSeg = arena.allocate(bytes);
            refSk = usk.compact(ordered, directSeg);
            testSk = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)directSeg);
            CompactSketchTest.checkByRange((ThetaSketch)refSk, (ThetaSketch)testSk, u, ordered);
            testSk = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)directSeg);
            CompactSketchTest.checkByRange((ThetaSketch)refSk, (ThetaSketch)testSk, u, ordered);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkByRange(ThetaSketch refSk, ThetaSketch testSk, int u, boolean ordered) {
        if (u == 0) {
            CompactSketchTest.checkEmptySketch(testSk);
        } else if (u == 1) {
            CompactSketchTest.checkSingleItemSketch(testSk, refSk);
        } else {
            CompactSketchTest.checkOtherCompactSketch(testSk, refSk, ordered);
        }
    }

    private static void checkEmptySketch(ThetaSketch testSk) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertTrue((boolean)(testSk instanceof EmptyCompactSketch));
        Assert.assertTrue((boolean)testSk.isEmpty());
        Assert.assertTrue((boolean)testSk.isOrdered());
        Assert.assertNull((Object)testSk.getMemorySegment());
        Assert.assertFalse((boolean)testSk.isOffHeap());
        Assert.assertFalse((boolean)testSk.hasMemorySegment());
        Assert.assertEquals((int)testSk.getSeedHash(), (int)0);
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((double)testSk.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(), (int)8);
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)8);
        Assert.assertEquals((int)testSk.getCache().length, (int)0);
        Assert.assertEquals((int)testSk.getCompactPreambleLongs(), (int)1);
    }

    private static void checkSingleItemSketch(ThetaSketch testSk, ThetaSketch refSk) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertTrue((boolean)(testSk instanceof SingleItemSketch));
        Assert.assertFalse((boolean)testSk.isEmpty());
        Assert.assertTrue((boolean)testSk.isOrdered());
        Assert.assertNull((Object)testSk.getMemorySegment());
        Assert.assertFalse((boolean)testSk.isOffHeap());
        Assert.assertFalse((boolean)testSk.hasMemorySegment());
        Assert.assertEquals((short)testSk.getSeedHash(), (short)refSk.getSeedHash());
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)1);
        Assert.assertEquals((double)testSk.getEstimate(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(), (int)16);
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)16);
        Assert.assertEquals((int)testSk.getCache().length, (int)1);
        Assert.assertEquals((int)testSk.getCompactPreambleLongs(), (int)1);
    }

    private static void checkOtherCompactSketch(ThetaSketch testSk, ThetaSketch refSk, boolean ordered) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertFalse((boolean)testSk.isEmpty());
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((boolean)testSk.isOrdered(), (boolean)ordered);
        if (refSk.hasMemorySegment()) {
            Assert.assertTrue((boolean)testSk.hasMemorySegment());
            Assert.assertNotNull((Object)testSk.getMemorySegment());
            if (ordered) {
                Assert.assertTrue((boolean)testSk.isOrdered());
            } else {
                Assert.assertFalse((boolean)testSk.isOrdered());
            }
            if (refSk.isOffHeap()) {
                Assert.assertTrue((boolean)testSk.isOffHeap());
            } else {
                Assert.assertFalse((boolean)testSk.isOffHeap());
            }
        } else {
            Assert.assertFalse((boolean)testSk.hasMemorySegment());
            Assert.assertTrue((boolean)(testSk instanceof HeapCompactSketch));
        }
        Assert.assertEquals((short)testSk.getSeedHash(), (short)refSk.getSeedHash());
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)refSk.getRetainedEntries(true));
        Assert.assertEquals((double)testSk.getEstimate(), (double)refSk.getEstimate(), (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(), (int)refSk.getCurrentBytes());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)refSk.toByteArray().length);
        Assert.assertEquals((int)testSk.getCache().length, (int)refSk.getCache().length);
        Assert.assertEquals((int)testSk.getCompactPreambleLongs(), (int)refSk.getCompactPreambleLongs());
    }

    @Test
    public void checkDirectSingleItemSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        int bytes = sk.getCompactBytes();
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        sk.compact(true, wseg);
        ThetaSketch csk2 = ThetaSketch.heapify((MemorySegment)wseg);
        Assert.assertTrue((boolean)(csk2 instanceof SingleItemSketch));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSegTooSmall() {
        int k = 512;
        int u = 512;
        boolean ordered = false;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 512; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCompactBytes();
        byte[] byteArray = new byte[bytes - 8];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        usk.compact(false, seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSegTooSmallOrdered() {
        int k = 512;
        int u = 512;
        boolean ordered = true;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 512; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCompactBytes();
        byte[] byteArray = new byte[bytes - 8];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        usk.compact(true, seg);
    }

    @Test
    public void checkCompactCachePart() {
        long[] result = ThetaIntersectionImpl.compactCachePart(null, (int)4, (int)0, (long)0L, (boolean)false);
        Assert.assertEquals((int)result.length, (int)0);
    }

    @Test
    public void checkEmptyMemorySegmentCompactSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        MemorySegment wseg1 = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk1 = sk.compact(false, wseg1);
        State state1 = new State("DirectCompactSketch", 0, 8, true, true, false, true, true, false);
        state1.check(csk1);
        MemorySegment wseg2 = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk2 = sk.compact(false, wseg2);
        state1.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        MemorySegment wseg3 = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk3 = csk1.compact(false, wseg3);
        state1.check(csk3);
        Assert.assertNotEquals((Object)csk1, (Object)csk3);
        Assert.assertFalse((csk1 == csk3 ? 1 : 0) != 0);
        CompactThetaSketch csk4 = csk1.compact(false, null);
        State state4 = new State("EmptyCompactSketch", 0, 8, true, true, false, false, true, false);
        state4.check(csk4);
        Assert.assertNotEquals((Object)csk1, (Object)csk4);
        Assert.assertFalse((csk1 == csk4 ? 1 : 0) != 0);
        CompactThetaSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkSingleItemMemorySegmentCompactSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        MemorySegment wseg1 = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk1 = sk.compact(false, wseg1);
        State state1 = new State("DirectCompactSketch", 1, 16, true, false, false, true, true, false);
        state1.check(csk1);
        MemorySegment wseg2 = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk2 = sk.compact(false, wseg2);
        state1.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        MemorySegment wseg3 = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk3 = csk1.compact(false, wseg3);
        state1.check(csk3);
        Assert.assertNotEquals((Object)csk1, (Object)csk3);
        Assert.assertFalse((csk1 == csk3 ? 1 : 0) != 0);
        CompactThetaSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkMultipleItemMemorySegmentCompactSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        sk.update(2L);
        sk.update(3L);
        MemorySegment wseg1 = MemorySegment.ofArray(new byte[50]);
        CompactThetaSketch csk1 = sk.compact(true, wseg1);
        State state1 = new State("DirectCompactSketch", 3, 40, true, false, false, true, true, false);
        state1.check(csk1);
        MemorySegment wseg2 = MemorySegment.ofArray(new byte[50]);
        CompactThetaSketch csk2 = sk.compact(false, wseg2);
        State state2 = new State("DirectCompactSketch", 3, 40, true, false, false, true, false, false);
        state2.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        MemorySegment wseg3 = MemorySegment.ofArray(new byte[50]);
        CompactThetaSketch csk3 = csk1.compact(false, wseg3);
        state2.check(csk3);
        Assert.assertNotEquals((Object)csk1, (Object)csk3);
        Assert.assertFalse((csk1 == csk3 ? 1 : 0) != 0);
        CompactThetaSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkEmptyHeapCompactSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        CompactThetaSketch csk1 = sk.compact(false, null);
        State state1 = new State("EmptyCompactSketch", 0, 8, true, true, false, false, true, false);
        state1.check(csk1);
        CompactThetaSketch csk2 = sk.compact(false, null);
        state1.check(csk1);
        Assert.assertEquals((Object)csk1, (Object)csk2);
        Assert.assertTrue((csk1 == csk2 ? 1 : 0) != 0);
        CompactThetaSketch csk3 = csk1.compact(false, null);
        state1.check(csk3);
        Assert.assertEquals((Object)csk1, (Object)csk3);
        Assert.assertTrue((csk1 == csk3 ? 1 : 0) != 0);
        CompactThetaSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkSingleItemHeapCompactSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        CompactThetaSketch csk1 = sk.compact(false, null);
        State state1 = new State("SingleItemSketch", 1, 16, true, false, false, false, true, false);
        state1.check(csk1);
        CompactThetaSketch csk2 = sk.compact(false, null);
        state1.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        CompactThetaSketch csk3 = csk1.compact(false, null);
        state1.check(csk3);
        Assert.assertEquals((Object)csk1, (Object)csk3);
        Assert.assertTrue((csk1 == csk3 ? 1 : 0) != 0);
        CompactThetaSketch cskc = csk1.compact();
        state1.check(csk1);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkMultipleItemHeapCompactSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        sk.update(2L);
        sk.update(3L);
        CompactThetaSketch csk1 = sk.compact(true, null);
        State state1 = new State("HeapCompactSketch", 3, 40, true, false, false, false, true, false);
        state1.check(csk1);
        CompactThetaSketch csk2 = sk.compact(false, null);
        State state2 = new State("HeapCompactSketch", 3, 40, true, false, false, false, false, false);
        state2.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        CompactThetaSketch csk3 = csk1.compact(true, null);
        state1.check(csk3);
        Assert.assertEquals((Object)csk1, (Object)csk3);
        Assert.assertTrue((csk1 == csk3 ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)csk2, (Object)csk3);
        Assert.assertFalse((csk2 == csk3 ? 1 : 0) != 0);
        CompactThetaSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkHeapifySingleItemSketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        int bytes = ThetaSketch.getMaxCompactSketchBytes((int)2);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        sk.compact(false, wseg);
        ThetaSketch csk = ThetaSketch.heapify((MemorySegment)wseg);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void checkHeapifyEmptySketch() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        MemorySegment wseg = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk = sk.compact(false, wseg);
        Assert.assertTrue((boolean)(csk instanceof DirectCompactSketch));
        ThetaSketch csk2 = ThetaSketch.heapify((MemorySegment)wseg);
        Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
    }

    @Test
    public void checkGetCache() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setP(0.5f).build();
        sk.update(7L);
        int bytes = sk.getCompactBytes();
        CompactThetaSketch csk = sk.compact(true, MemorySegment.ofArray(new byte[bytes]));
        long[] cache = csk.getCache();
        Assert.assertTrue((cache.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkHeapCompactSketchCompact() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        sk.update(2L);
        CompactThetaSketch csk = sk.compact();
        Assert.assertTrue((boolean)csk.isOrdered());
        Assert.assertEquals((int)csk.getCurrentPreambleLongs(), (int)2);
    }

    @Test
    public void checkDirectCompactSketchCompact() {
        int lgK = 6;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setLogNominalEntries(6).build();
        int bytes = sk.getCompactBytes();
        MemorySegment wseg1 = MemorySegment.ofArray(new byte[bytes]);
        MemorySegment wseg2 = MemorySegment.ofArray(new byte[bytes]);
        CompactThetaSketch csk1 = sk.compact(false, wseg1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk1.isOrdered());
        CompactThetaSketch csk2 = csk1.compact(false, wseg2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)8);
        sk.update(1L);
        bytes = sk.getCompactBytes();
        wseg1 = MemorySegment.ofArray(new byte[bytes]);
        wseg2 = MemorySegment.ofArray(new byte[bytes]);
        csk1 = sk.compact(false, wseg1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk1.isOrdered());
        csk2 = csk1.compact(false, wseg2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)16);
        sk.update(2L);
        bytes = sk.getCompactBytes();
        wseg1 = MemorySegment.ofArray(new byte[bytes]);
        wseg2 = MemorySegment.ofArray(new byte[bytes]);
        csk1 = sk.compact(false, wseg1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertFalse((boolean)csk1.isOrdered());
        csk2 = csk1.compact(true, wseg2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)32);
        int n = 128;
        for (int i = 2; i < 128; ++i) {
            sk.update((long)i);
        }
        bytes = sk.getCompactBytes();
        wseg1 = MemorySegment.ofArray(new byte[bytes]);
        wseg2 = MemorySegment.ofArray(new byte[bytes]);
        csk1 = sk.compact(false, wseg1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertFalse((boolean)csk1.isOrdered());
        csk2 = csk1.compact(true, wseg2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() != 0 ? 1 : 0) != 0);
        int curCount = csk2.getRetainedEntries();
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)(24 + curCount * 8));
    }

    @Test
    public void serializeDeserializeHeapV4() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
        CompactThetaSketch cs1 = sk.compact();
        byte[] bytes = cs1.toByteArrayCompressed();
        CompactThetaSketch cs2 = CompactThetaSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)cs1.getRetainedEntries(), (int)cs2.getRetainedEntries());
        HashIterator it1 = cs1.iterator();
        HashIterator it2 = cs2.iterator();
        while (it1.next() && it2.next()) {
            Assert.assertEquals((long)it2.get(), (long)it2.get());
        }
    }

    @Test
    public void serializeDeserializeDirectV4_segment() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
        CompactThetaSketch cs1 = sk.compact(true, MemorySegment.ofArray(new byte[sk.getCompactBytes()]));
        byte[] bytes = cs1.toByteArrayCompressed();
        CompactThetaSketch cs2 = CompactThetaSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)cs1.getRetainedEntries(), (int)cs2.getRetainedEntries());
        HashIterator it1 = cs1.iterator();
        HashIterator it2 = cs2.iterator();
        while (it1.next() && it2.next()) {
            Assert.assertEquals((long)it2.get(), (long)it2.get());
        }
    }

    @Test
    public void serializeDeserializeDirectV4_bytes() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
        CompactThetaSketch cs1 = sk.compact(true, MemorySegment.ofArray(new byte[sk.getCompactBytes()]));
        byte[] bytes = cs1.toByteArrayCompressed();
        CompactThetaSketch cs2 = CompactThetaSketch.wrap((byte[])bytes);
        Assert.assertEquals((int)cs1.getRetainedEntries(), (int)cs2.getRetainedEntries());
        HashIterator it1 = cs1.iterator();
        HashIterator it2 = cs2.iterator();
        while (it1.next() && it2.next()) {
            Assert.assertEquals((long)it2.get(), (long)it2.get());
        }
    }

    @Test
    public void serializeWrapBytesV3() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
        CompactThetaSketch cs1 = sk.compact();
        byte[] bytes = cs1.toByteArray();
        WrappedCompactSketch cs2 = new WrappedCompactSketch(bytes);
        Assert.assertEquals((int)cs1.getRetainedEntries(), (int)cs2.getRetainedEntries());
        HashIterator it1 = cs1.iterator();
        HashIterator it2 = cs2.iterator();
        while (it1.next() && it2.next()) {
            Assert.assertEquals((long)it2.get(), (long)it2.get());
        }
        Assert.assertEquals((byte[])bytes, (byte[])cs2.toByteArray());
    }

    @Test
    public void serializeWrapBytesV4() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
        CompactThetaSketch cs1 = sk.compact();
        byte[] bytes = cs1.toByteArrayCompressed();
        WrappedCompactCompressedSketch cs2 = new WrappedCompactCompressedSketch(bytes);
        Assert.assertEquals((int)cs1.getRetainedEntries(), (int)cs2.getRetainedEntries());
        HashIterator it1 = cs1.iterator();
        HashIterator it2 = cs2.iterator();
        while (it1.next() && it2.next()) {
            Assert.assertEquals((long)it2.get(), (long)it2.get());
        }
        Assert.assertEquals((byte[])bytes, (byte[])cs2.toByteArray());
    }

    @Test
    public void printlnTest() {
        CompactSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static class State {
        String classType = null;
        int count = 0;
        int bytes = 0;
        boolean compact = false;
        boolean empty = false;
        boolean direct = false;
        boolean hasSeg = false;
        boolean ordered = false;
        boolean estimation = false;

        State(String classType, int count, int bytes, boolean compact, boolean empty, boolean direct, boolean hasSeg, boolean ordered, boolean estimation) {
            this.classType = classType;
            this.count = count;
            this.bytes = bytes;
            this.compact = compact;
            this.empty = empty;
            this.direct = direct;
            this.hasSeg = hasSeg;
            this.ordered = ordered;
            this.estimation = estimation;
        }

        void check(CompactThetaSketch csk) {
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)this.classType, (String)"ClassType");
            Assert.assertEquals((int)csk.getRetainedEntries(true), (int)this.count, (String)"curCount");
            Assert.assertEquals((int)csk.getCurrentBytes(), (int)this.bytes, (String)"Bytes");
            Assert.assertEquals((boolean)csk.isCompact(), (boolean)this.compact, (String)"Compact");
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)this.empty, (String)"Empty");
            Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)this.direct, (String)"Direct");
            Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)this.hasSeg, (String)"MemorySegment");
            Assert.assertEquals((boolean)csk.isOrdered(), (boolean)this.ordered, (String)"Ordered");
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)this.estimation, (String)"Estimation");
        }
    }
}

