/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.EditDistanceFrom;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringMetricFromTest {
    @Test
    public void testEquivalence() {
        LevenshteinDistance metric = new LevenshteinDistance();
        String left = "Apache";
        String right = "a patchy";
        Integer distance = 4;
        EditDistanceFrom metricFrom = new EditDistanceFrom((EditDistance)metric, (CharSequence)"Apache");
        Assertions.assertThat((Integer)((Integer)metricFrom.apply((CharSequence)"a patchy"))).isEqualTo((Object)distance);
        Assertions.assertThat((Integer)((Integer)metricFrom.apply((CharSequence)"a patchy"))).isEqualTo(metric.apply((CharSequence)"Apache", (CharSequence)"a patchy"));
    }

    @Test
    public void testJavadocExample() {
        LevenshteinDistance metric = new LevenshteinDistance();
        String target = "Apache";
        EditDistanceFrom metricFrom = new EditDistanceFrom((EditDistance)metric, (CharSequence)"Apache");
        String mostSimilar = null;
        Integer shortestDistance = null;
        for (String test : new String[]{"Appaloosa", "a patchy", "apple"}) {
            Integer distance = (Integer)metricFrom.apply((CharSequence)test);
            if (shortestDistance != null && distance >= shortestDistance) continue;
            shortestDistance = distance;
            mostSimilar = test;
        }
        Assertions.assertThat(mostSimilar).isEqualTo((Object)"a patchy");
        Assertions.assertThat(shortestDistance).isEqualTo(4);
    }

    @Test
    public void testMissingMetric() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new EditDistanceFrom(null, (CharSequence)"no go"));
    }
}

