/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.stream.Stream;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.EditDistanceFrom;
import org.apache.commons.text.similarity.HammingDistance;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ParameterizedEditDistanceFromTest<R> {
    public static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{new HammingDistance(), "Sam I am.", "Ham I am.", 1}), Arguments.of((Object[])new Object[]{new HammingDistance(), "Japtheth, Ham, Shem", "Japtheth, HAM, Shem", 2}), Arguments.of((Object[])new Object[]{new HammingDistance(), "Hamming", "Hamming", 0}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(), "Apache", "a patchy", 4}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(), "go", "no go", 3}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(), "go", "go", 0}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(Integer.valueOf(4)), "Apache", "a patchy", 4}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(Integer.valueOf(4)), "go", "no go", 3}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(Integer.valueOf(0)), "go", "go", 0}), Arguments.of((Object[])new Object[]{new EditDistance<Boolean>(){

            public Boolean apply(CharSequence left, CharSequence right) {
                return left == right || left != null && left.equals(right);
            }
        }, "Bob's your uncle.", "Every good boy does fine.", false}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void test(EditDistance<R> editDistance, CharSequence left, CharSequence right, R distance) {
        EditDistanceFrom editDistanceFrom = new EditDistanceFrom(editDistance, left);
        Assertions.assertThat((Object)editDistanceFrom.apply(right)).isEqualTo(distance);
    }
}

