/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.function.UnaryOperator;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.ZeroException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.optim.OptimizationData;
import org.apache.commons.math4.legacy.optim.PointValuePair;

public final class Simplex
implements OptimizationData {
    private final List<PointValuePair> points;

    private Simplex(double[][] referenceSimplex) {
        if (referenceSimplex.length <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SIMPLEX_NEED_ONE_POINT, (Number)referenceSimplex.length);
        }
        int len = referenceSimplex.length;
        this.points = new ArrayList<PointValuePair>(len);
        int dim = len - 1;
        for (int i = 0; i < len; ++i) {
            double[] refI = referenceSimplex[i];
            if (refI.length != dim) {
                throw new DimensionMismatchException(refI.length, dim);
            }
            for (int j = 1; j < i; ++j) {
                double[] refJ = referenceSimplex[j];
                boolean allEquals = true;
                for (int k = 0; k < dim; ++k) {
                    if (refI[k] == refJ[k]) continue;
                    allEquals = false;
                    break;
                }
                if (!allEquals) continue;
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, new Object[]{i, j});
            }
            this.points.add(new PointValuePair(refI, Double.NaN));
        }
    }

    private Simplex(List<PointValuePair> points) {
        this.points = points;
    }

    public static Simplex of(double[][] simplex) {
        return new Simplex(simplex);
    }

    public static Simplex equalSidesAlongAxes(int dim, double sideLength) {
        double[] steps = new double[dim];
        Arrays.fill(steps, sideLength);
        return Simplex.alongAxes(steps);
    }

    public static Simplex alongAxes(double[] steps) {
        if (steps.length == 0) {
            throw new ZeroException();
        }
        int dim = steps.length;
        int len = dim + 1;
        double[][] simplex = new double[len][dim];
        for (int i = 1; i < len; ++i) {
            double[] vertexI = simplex[i];
            for (int j = 0; j < i; ++j) {
                if (steps[j] == 0.0) {
                    throw new ZeroException();
                }
                System.arraycopy(steps, 0, vertexI, 0, j + 1);
            }
        }
        return new Simplex(simplex);
    }

    public int getDimension() {
        return this.points.size() - 1;
    }

    public int getSize() {
        return this.points.size();
    }

    public Simplex evaluate(MultivariateFunction function, Comparator<PointValuePair> comparator) {
        ArrayList<PointValuePair> newPoints = new ArrayList<PointValuePair>(this.points.size());
        for (PointValuePair pv : this.points) {
            double[] coord = pv.getPoint();
            double value = Double.isNaN((Double)pv.getValue()) ? function.value(coord) : ((Double)pv.getValue()).doubleValue();
            newPoints.add(new PointValuePair(coord, value, false));
        }
        Collections.sort(newPoints, comparator);
        return new Simplex(newPoints);
    }

    public PointValuePair get(int index) {
        PointValuePair p = this.points.get(index);
        return new PointValuePair(p.getPoint(), (Double)p.getValue());
    }

    public List<PointValuePair> asList() {
        return this.asList(0, this.points.size());
    }

    List<PointValuePair> asList(int from, int to) {
        if (from < 0 || to > this.points.size() || from > to) {
            throw new IllegalArgumentException("Index");
        }
        int len = to - from;
        ArrayList<PointValuePair> copy = new ArrayList<PointValuePair>(len);
        for (int i = from; i < to; ++i) {
            copy.add(this.get(i));
        }
        return copy;
    }

    static PointValuePair newPoint(double[] a, double s, double[] b, MultivariateFunction function) {
        int dim = a.length;
        double[] r = new double[dim];
        for (int i = 0; i < dim; ++i) {
            double m = a[i];
            r[i] = m + s * (b[i] - m);
        }
        return new PointValuePair(r, function.value(r), false);
    }

    Simplex shrink(double sigma, MultivariateFunction function) {
        int replSize = this.getSize() - 1;
        ArrayList<PointValuePair> replacement = new ArrayList<PointValuePair>();
        double[] bestPoint = this.get(0).getPoint();
        for (int i = 0; i < replSize; ++i) {
            replacement.add(Simplex.newPoint(bestPoint, sigma, this.get(i + 1).getPoint(), function));
        }
        return this.replaceLast(replacement);
    }

    Simplex translate(double[] point) {
        int dim = point.length;
        if (this.getDimension() != dim) {
            throw new DimensionMismatchException(this.getDimension(), dim);
        }
        int len = this.points.size();
        double[][] coordinates = new double[len][dim];
        double[] current0 = this.points.get(0).getPoint();
        for (int i = 0; i < len; ++i) {
            double[] currentI = this.points.get(i).getPoint();
            double[] newI = coordinates[i];
            for (int k = 0; k < dim; ++k) {
                newI[k] = point[k] + currentI[k] - current0[k];
            }
        }
        return new Simplex(coordinates);
    }

    Simplex replaceLast(PointValuePair point) {
        List<PointValuePair> newPoints = this.asList(0, this.getDimension());
        newPoints.add(new PointValuePair(point.getPoint(), (Double)point.getValue(), false));
        return new Simplex(newPoints);
    }

    Simplex replaceLast(List<PointValuePair> replacement) {
        int nPoints = replacement.size();
        int from = this.points.size() - nPoints;
        List<PointValuePair> newPoints = this.asList(0, from);
        for (int i = 0; i < nPoints; ++i) {
            PointValuePair p = replacement.get(i);
            newPoints.add(new PointValuePair(p.getPoint(), (Double)p.getValue(), false));
        }
        return new Simplex(newPoints);
    }

    static double[] centroid(List<PointValuePair> list) {
        double[] centroid = list.get(0).getPoint();
        int nPoints = list.size();
        int dim = centroid.length;
        for (int i = 1; i < nPoints; ++i) {
            double[] p = list.get(i).getPoint();
            for (int k = 0; k < dim; ++k) {
                int n = k;
                centroid[n] = centroid[n] + p[k];
            }
        }
        int k = 0;
        while (k < dim) {
            int n = k++;
            centroid[n] = centroid[n] / (double)nPoints;
        }
        return centroid;
    }

    public static interface TransformFactory
    extends OptimizationData {
        public UnaryOperator<Simplex> create(MultivariateFunction var1, Comparator<PointValuePair> var2, DoublePredicate var3);
    }
}

