/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;
import org.apache.commons.math3.dfp.DfpMath;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastMathTest {
    private static final double MAX_ERROR_ULP = 0.51;
    private static final int NUMBER_OF_TRIALS = 1000;
    private DfpField field;
    private RandomGenerator generator;

    @Before
    public void setUp() {
        this.field = new DfpField(40);
        this.generator = new MersenneTwister(6176597458463500194L);
    }

    @Test
    public void testMinMaxDouble() {
        double[][] pairs;
        for (double[] pair : pairs = new double[][]{{-50.0, 50.0}, {Double.POSITIVE_INFINITY, 1.0}, {Double.NEGATIVE_INFINITY, 1.0}, {Double.NaN, 1.0}, {Double.POSITIVE_INFINITY, 0.0}, {Double.NEGATIVE_INFINITY, 0.0}, {Double.NaN, 0.0}, {Double.NaN, Double.NEGATIVE_INFINITY}, {Double.NaN, Double.POSITIVE_INFINITY}, {Precision.SAFE_MIN, Precision.EPSILON}}) {
            Assert.assertEquals((String)("min(" + pair[0] + ", " + pair[1] + ")"), (double)Math.min(pair[0], pair[1]), (double)FastMath.min((double)pair[0], (double)pair[1]), (double)Precision.EPSILON);
            Assert.assertEquals((String)("min(" + pair[1] + ", " + pair[0] + ")"), (double)Math.min(pair[1], pair[0]), (double)FastMath.min((double)pair[1], (double)pair[0]), (double)Precision.EPSILON);
            Assert.assertEquals((String)("max(" + pair[0] + ", " + pair[1] + ")"), (double)Math.max(pair[0], pair[1]), (double)FastMath.max((double)pair[0], (double)pair[1]), (double)Precision.EPSILON);
            Assert.assertEquals((String)("max(" + pair[1] + ", " + pair[0] + ")"), (double)Math.max(pair[1], pair[0]), (double)FastMath.max((double)pair[1], (double)pair[0]), (double)Precision.EPSILON);
        }
    }

    @Test
    public void testMinMaxFloat() {
        float[][] pairs;
        for (float[] pair : pairs = new float[][]{{-50.0f, 50.0f}, {Float.POSITIVE_INFINITY, 1.0f}, {Float.NEGATIVE_INFINITY, 1.0f}, {Float.NaN, 1.0f}, {Float.POSITIVE_INFINITY, 0.0f}, {Float.NEGATIVE_INFINITY, 0.0f}, {Float.NaN, 0.0f}, {Float.NaN, Float.NEGATIVE_INFINITY}, {Float.NaN, Float.POSITIVE_INFINITY}}) {
            Assert.assertEquals((String)("min(" + pair[0] + ", " + pair[1] + ")"), (double)Math.min(pair[0], pair[1]), (double)FastMath.min((float)pair[0], (float)pair[1]), (double)Precision.EPSILON);
            Assert.assertEquals((String)("min(" + pair[1] + ", " + pair[0] + ")"), (double)Math.min(pair[1], pair[0]), (double)FastMath.min((float)pair[1], (float)pair[0]), (double)Precision.EPSILON);
            Assert.assertEquals((String)("max(" + pair[0] + ", " + pair[1] + ")"), (double)Math.max(pair[0], pair[1]), (double)FastMath.max((float)pair[0], (float)pair[1]), (double)Precision.EPSILON);
            Assert.assertEquals((String)("max(" + pair[1] + ", " + pair[0] + ")"), (double)Math.max(pair[1], pair[0]), (double)FastMath.max((float)pair[1], (float)pair[0]), (double)Precision.EPSILON);
        }
    }

    @Test
    public void testConstants() {
        Assert.assertEquals((double)Math.PI, (double)Math.PI, (double)1.0E-20);
        Assert.assertEquals((double)Math.E, (double)Math.E, (double)1.0E-20);
    }

    @Test
    public void testAtan2() {
        double y1 = 1.2713504628280706E10;
        double x1 = -5.674940885228782E-10;
        Assert.assertEquals((double)Math.atan2(y1, x1), (double)FastMath.atan2((double)y1, (double)x1), (double)(2.0 * Precision.EPSILON));
        double y2 = 0.0;
        double x2 = Double.POSITIVE_INFINITY;
        Assert.assertEquals((double)Math.atan2(y2, x2), (double)FastMath.atan2((double)y2, (double)x2), (double)Precision.SAFE_MIN);
    }

    @Test
    public void testHyperbolic() {
        double ref;
        double tst;
        double x;
        double maxErr = 0.0;
        for (x = -30.0; x < 30.0; x += 0.001) {
            tst = FastMath.sinh((double)x);
            ref = Math.sinh(x);
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(ref - tst)) / FastMath.ulp((double)ref)));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)2.0);
        maxErr = 0.0;
        for (x = -30.0; x < 30.0; x += 0.001) {
            tst = FastMath.cosh((double)x);
            ref = Math.cosh(x);
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(ref - tst)) / FastMath.ulp((double)ref)));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)2.0);
        maxErr = 0.0;
        for (x = -0.5; x < 0.5; x += 0.001) {
            tst = FastMath.tanh((double)x);
            ref = Math.tanh(x);
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(ref - tst)) / FastMath.ulp((double)ref)));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)4.0);
    }

    @Test
    public void testMath904() {
        double x = -1.0;
        double y = 5.000000000000001E15;
        Assert.assertEquals((double)Math.pow(-1.0, 5.000000000000001E15), (double)FastMath.pow((double)-1.0, (double)5.000000000000001E15), (double)0.0);
        Assert.assertEquals((double)Math.pow(-1.0, -5.000000000000001E15), (double)FastMath.pow((double)-1.0, (double)-5.000000000000001E15), (double)0.0);
    }

    @Test
    public void testMath905LargePositive() {
        double ref;
        double tst;
        double x;
        double start = StrictMath.log(Double.MAX_VALUE);
        double endT = StrictMath.sqrt(2.0) * StrictMath.sqrt(Double.MAX_VALUE);
        double end = 2.0 * StrictMath.log(endT);
        double maxErr = 0.0;
        for (x = start; x < end; x += 0.001) {
            tst = FastMath.cosh((double)x);
            ref = Math.cosh(x);
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(ref - tst)) / FastMath.ulp((double)ref)));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)3.0);
        for (x = start; x < end; x += 0.001) {
            tst = FastMath.sinh((double)x);
            ref = Math.sinh(x);
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(ref - tst)) / FastMath.ulp((double)ref)));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)3.0);
    }

    @Test
    public void testMath905LargeNegative() {
        double ref;
        double tst;
        double x;
        double start = -StrictMath.log(Double.MAX_VALUE);
        double endT = StrictMath.sqrt(2.0) * StrictMath.sqrt(Double.MAX_VALUE);
        double end = -2.0 * StrictMath.log(endT);
        double maxErr = 0.0;
        for (x = start; x > end; x -= 0.001) {
            tst = FastMath.cosh((double)x);
            ref = Math.cosh(x);
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(ref - tst)) / FastMath.ulp((double)ref)));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)3.0);
        for (x = start; x > end; x -= 0.001) {
            tst = FastMath.sinh((double)x);
            ref = Math.sinh(x);
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(ref - tst)) / FastMath.ulp((double)ref)));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)3.0);
    }

    @Test
    public void testMath1269() {
        double arg = 709.8125;
        double vM = Math.exp(709.8125);
        double vFM = FastMath.exp((double)709.8125);
        Assert.assertTrue((String)("exp(709.8125) is " + vFM + " instead of " + vM), (boolean)Precision.equalsIncludingNaN((double)vM, (double)vFM));
    }

    @Test
    public void testHyperbolicInverses() {
        double x;
        double maxErr = 0.0;
        for (x = -30.0; x < 30.0; x += 0.01) {
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(x - FastMath.sinh((double)FastMath.asinh((double)x)))) / (2.0 * FastMath.ulp((double)x))));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)3.0);
        maxErr = 0.0;
        for (x = 1.0; x < 30.0; x += 0.01) {
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(x - FastMath.cosh((double)FastMath.acosh((double)x)))) / (2.0 * FastMath.ulp((double)x))));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)2.0);
        maxErr = 0.0;
        for (x = -1.0 + Precision.EPSILON; x < 1.0 - Precision.EPSILON; x += 1.0E-4) {
            maxErr = FastMath.max((double)maxErr, (double)(FastMath.abs((double)(x - FastMath.tanh((double)FastMath.atanh((double)x)))) / (2.0 * FastMath.ulp((double)x))));
        }
        Assert.assertEquals((double)0.0, (double)maxErr, (double)2.0);
    }

    @Test
    public void testLogAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = Math.exp(this.generator.nextDouble() * 1416.0 - 708.0) * this.generator.nextDouble();
            double tst = FastMath.log((double)x);
            double err = (tst - (ref = DfpMath.log((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.log((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"log() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testLog10Accuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = Math.exp(this.generator.nextDouble() * 1416.0 - 708.0) * this.generator.nextDouble();
            double tst = FastMath.log10((double)x);
            double err = (tst - (ref = DfpMath.log((Dfp)this.field.newDfp(x)).divide(DfpMath.log((Dfp)this.field.newDfp("10"))).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.log((Dfp)this.field.newDfp(x)).divide(DfpMath.log((Dfp)this.field.newDfp("10")))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"log10() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testLog1pAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = Math.exp(this.generator.nextDouble() * 10.0 - 5.0) * this.generator.nextDouble();
            double tst = FastMath.log1p((double)x);
            double err = (tst - (ref = DfpMath.log((Dfp)this.field.newDfp(x).add(this.field.getOne())).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.log((Dfp)this.field.newDfp(x).add(this.field.getOne()))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"log1p() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testLog1pSpecialCases() {
        Assert.assertTrue((String)"Logp of -1.0 should be -Inf", (boolean)Double.isInfinite(FastMath.log1p((double)-1.0)));
    }

    @Test
    public void testLogSpecialCases() {
        Assert.assertEquals((String)"Log of zero should be -Inf", (double)Double.NEGATIVE_INFINITY, (double)FastMath.log((double)0.0), (double)1.0);
        Assert.assertEquals((String)"Log of -zero should be -Inf", (double)Double.NEGATIVE_INFINITY, (double)FastMath.log((double)-0.0), (double)1.0);
        Assert.assertTrue((String)"Log of NaN should be NaN", (boolean)Double.isNaN(FastMath.log((double)Double.NaN)));
        Assert.assertTrue((String)"Log of negative number should be NaN", (boolean)Double.isNaN(FastMath.log((double)-1.0)));
        Assert.assertEquals((String)"Log of Double.MIN_VALUE should be -744.4400719213812", (double)-744.4400719213812, (double)FastMath.log((double)Double.MIN_VALUE), (double)Precision.EPSILON);
        Assert.assertEquals((String)"Log of infinity should be infinity", (double)Double.POSITIVE_INFINITY, (double)FastMath.log((double)Double.POSITIVE_INFINITY), (double)1.0);
    }

    @Test
    public void testExpSpecialCases() {
        Assert.assertEquals((double)Double.MIN_VALUE, (double)FastMath.exp((double)-745.1332191019411), (double)Precision.EPSILON);
        Assert.assertEquals((String)"exp(-745.1332191019412) should be 0.0", (double)0.0, (double)FastMath.exp((double)-745.1332191019412), (double)Precision.EPSILON);
        Assert.assertTrue((String)"exp of NaN should be NaN", (boolean)Double.isNaN(FastMath.exp((double)Double.NaN)));
        Assert.assertEquals((String)"exp of infinity should be infinity", (double)Double.POSITIVE_INFINITY, (double)FastMath.exp((double)Double.POSITIVE_INFINITY), (double)1.0);
        Assert.assertEquals((String)"exp of -infinity should be 0.0", (double)0.0, (double)FastMath.exp((double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"exp(1) should be Math.E", (double)Math.E, (double)FastMath.exp((double)1.0), (double)Precision.EPSILON);
    }

    @Test
    public void testPowSpecialCases() {
        double EXACT = -1.0;
        Assert.assertEquals((String)"pow(-1, 0) should be 1.0", (double)1.0, (double)FastMath.pow((double)-1.0, (double)0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(-1, -0) should be 1.0", (double)1.0, (double)FastMath.pow((double)-1.0, (double)-0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(PI, 1.0) should be PI", (double)Math.PI, (double)FastMath.pow((double)Math.PI, (double)1.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(-PI, 1.0) should be -PI", (double)(-Math.PI), (double)FastMath.pow((double)(-Math.PI), (double)1.0), (double)Precision.EPSILON);
        Assert.assertTrue((String)"pow(PI, NaN) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)Math.PI, (double)Double.NaN)));
        Assert.assertTrue((String)"pow(NaN, PI) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)Double.NaN, (double)Math.PI)));
        Assert.assertEquals((String)"pow(2.0, Infinity) should be Infinity", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)2.0, (double)Double.POSITIVE_INFINITY), (double)1.0);
        Assert.assertEquals((String)"pow(0.5, -Infinity) should be Infinity", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)0.5, (double)Double.NEGATIVE_INFINITY), (double)1.0);
        Assert.assertEquals((String)"pow(0.5, Infinity) should be 0.0", (double)0.0, (double)FastMath.pow((double)0.5, (double)Double.POSITIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(2.0, -Infinity) should be 0.0", (double)0.0, (double)FastMath.pow((double)2.0, (double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(0.0, 0.5) should be 0.0", (double)0.0, (double)FastMath.pow((double)0.0, (double)0.5), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(Infinity, -0.5) should be 0.0", (double)0.0, (double)FastMath.pow((double)Double.POSITIVE_INFINITY, (double)-0.5), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(0.0, -0.5) should be Inf", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)0.0, (double)-0.5), (double)1.0);
        Assert.assertEquals((String)"pow(Inf, 0.5) should be Inf", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)Double.POSITIVE_INFINITY, (double)0.5), (double)1.0);
        Assert.assertEquals((String)"pow(-0.0, -3.0) should be -Inf", (double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)-3.0), (double)1.0);
        Assert.assertEquals((String)"pow(-0.0, Infinity) should be 0.0", (double)0.0, (double)FastMath.pow((double)-0.0, (double)Double.POSITIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertTrue((String)"pow(-0.0, NaN) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)-0.0, (double)Double.NaN)));
        Assert.assertEquals((String)"pow(-0.0, -tiny) should be Infinity", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)-4.9E-324), (double)1.0);
        Assert.assertEquals((String)"pow(-0.0, -huge) should be Infinity", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)-1.7976931348623157E308), (double)1.0);
        Assert.assertEquals((String)"pow(-Inf, 3.0) should be -Inf", (double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)3.0), (double)1.0);
        Assert.assertEquals((String)"pow(-Inf, -3.0) should be -0.0", (double)-0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)-3.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-0.0, -3.5) should be Inf", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)-3.5), (double)1.0);
        Assert.assertEquals((String)"pow(Inf, 3.5) should be Inf", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)Double.POSITIVE_INFINITY, (double)3.5), (double)1.0);
        Assert.assertEquals((String)"pow(-2.0, 3.0) should be -8.0", (double)-8.0, (double)FastMath.pow((double)-2.0, (double)3.0), (double)Precision.EPSILON);
        Assert.assertTrue((String)"pow(-2.0, 3.5) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)-2.0, (double)3.5)));
        Assert.assertTrue((String)"pow(NaN, -Infinity) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)Double.NaN, (double)Double.NEGATIVE_INFINITY)));
        Assert.assertEquals((String)"pow(NaN, 0.0) should be 1.0", (double)1.0, (double)FastMath.pow((double)Double.NaN, (double)0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(-Infinity, -Infinity) should be 0.0", (double)0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(-huge, -huge) should be 0.0", (double)0.0, (double)FastMath.pow((double)-1.7976931348623157E308, (double)-1.7976931348623157E308), (double)Precision.EPSILON);
        Assert.assertTrue((String)"pow(-huge,  huge) should be +Inf", (boolean)Double.isInfinite(FastMath.pow((double)-1.7976931348623157E308, (double)Double.MAX_VALUE)));
        Assert.assertTrue((String)"pow(NaN, -Infinity) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)Double.NaN, (double)Double.NEGATIVE_INFINITY)));
        Assert.assertEquals((String)"pow(NaN, -0.0) should be 1.0", (double)1.0, (double)FastMath.pow((double)Double.NaN, (double)-0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(-Infinity, -Infinity) should be 0.0", (double)0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(-huge, -huge) should be 0.0", (double)0.0, (double)FastMath.pow((double)-1.7976931348623157E308, (double)-1.7976931348623157E308), (double)Precision.EPSILON);
        Assert.assertEquals((String)"pow(-huge,  huge) should be +Inf", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)-1.7976931348623157E308, (double)Double.MAX_VALUE), (double)1.0);
        Assert.assertTrue((String)"pow(+Inf, NaN) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)Double.POSITIVE_INFINITY, (double)Double.NaN)));
        Assert.assertTrue((String)"pow(1.0, +Inf) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)1.0, (double)Double.POSITIVE_INFINITY)));
        Assert.assertTrue((String)"pow(-Inf, NaN) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)Double.NaN)));
        Assert.assertEquals((String)"pow(-Inf, -1.0) should be -0.0", (double)-0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)-1.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-Inf, -2.0) should be 0.0", (double)0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)-2.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-Inf, 1.0) should be -Inf", (double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)1.0), (double)1.0);
        Assert.assertEquals((String)"pow(-Inf, 2.0) should be +Inf", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)2.0), (double)1.0);
        Assert.assertTrue((String)"pow(1.0, -Inf) should be NaN", (boolean)Double.isNaN(FastMath.pow((double)1.0, (double)Double.NEGATIVE_INFINITY)));
        Assert.assertEquals((String)"pow(-0.0, 1.0) should be -0.0", (double)-0.0, (double)FastMath.pow((double)-0.0, (double)1.0), (double)-1.0);
        Assert.assertEquals((String)"pow(0.0, 1.0) should be 0.0", (double)0.0, (double)FastMath.pow((double)0.0, (double)1.0), (double)-1.0);
        Assert.assertEquals((String)"pow(0.0, +Inf) should be 0.0", (double)0.0, (double)FastMath.pow((double)0.0, (double)Double.POSITIVE_INFINITY), (double)-1.0);
        Assert.assertEquals((String)"pow(-0.0, even) should be 0.0", (double)0.0, (double)FastMath.pow((double)-0.0, (double)6.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-0.0, odd) should be -0.0", (double)-0.0, (double)FastMath.pow((double)-0.0, (double)13.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-0.0, -even) should be +Inf", (double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)-6.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-0.0, -odd) should be -Inf", (double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)-13.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-2.0, 4.0) should be 16.0", (double)16.0, (double)FastMath.pow((double)-2.0, (double)4.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-2.0, 4.5) should be NaN", (double)Double.NaN, (double)FastMath.pow((double)-2.0, (double)4.5), (double)-1.0);
        Assert.assertEquals((String)"pow(-0.0, -0.0) should be 1.0", (double)1.0, (double)FastMath.pow((double)-0.0, (double)-0.0), (double)-1.0);
        Assert.assertEquals((String)"pow(-0.0, 0.0) should be 1.0", (double)1.0, (double)FastMath.pow((double)-0.0, (double)0.0), (double)-1.0);
        Assert.assertEquals((String)"pow(0.0, -0.0) should be 1.0", (double)1.0, (double)FastMath.pow((double)0.0, (double)-0.0), (double)-1.0);
        Assert.assertEquals((String)"pow(0.0, 0.0) should be 1.0", (double)1.0, (double)FastMath.pow((double)0.0, (double)0.0), (double)-1.0);
    }

    @Test(timeout=20000L)
    public void testPowAllSpecialCases() {
        double[] DOUBLES;
        double EXACT = -1.0;
        for (double d : DOUBLES = new double[]{Double.NEGATIVE_INFINITY, -0.0, Double.NaN, 0.0, Double.POSITIVE_INFINITY, -9.223372036854776E18, -2.147483648E9, -32768.0, -128.0, 9.223372036854776E18, 2.147483648E9, 32768.0, 128.0, 127.0, 32767.0, 2.147483647E9, 9.223372036854776E18, -127.0, -32767.0, -2.147483647E9, -9.223372036854776E18, 3.4028234663852886E38, Double.MAX_VALUE, Double.MIN_VALUE, 1.4E-45f, -3.4028234663852886E38, -1.7976931348623157E308, -4.9E-324, -1.4E-45f, 0.5, 0.1, 0.2, 0.8, 1.1, 1.2, 1.5, 1.8, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 1.3, 2.2, 2.5, 2.8, 33.0, 33.1, 33.5, 33.8, 10.0, 300.0, 400.0, 500.0, -0.5, -0.1, -0.2, -0.8, -1.1, -1.2, -1.5, -1.8, -1.0, -2.0, -3.0, -4.0, -5.0, -6.0, -7.0, -8.0, -9.0, -1.3, -2.2, -2.5, -2.8, -33.0, -33.1, -33.5, -33.8, -10.0, -300.0, -400.0, -500.0}) {
            Assert.assertEquals((double)1.0, (double)FastMath.pow((double)d, (double)0.0), (double)-1.0);
        }
        for (double d : DOUBLES) {
            Assert.assertEquals((double)1.0, (double)FastMath.pow((double)d, (double)-0.0), (double)-1.0);
        }
        for (double d : DOUBLES) {
            Assert.assertEquals((double)d, (double)FastMath.pow((double)d, (double)1.0), (double)-1.0);
        }
        for (double d : DOUBLES) {
            Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)d, (double)Double.NaN), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (i == 0.0) continue;
            Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)Double.NaN, (double)i), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) > 1.0)) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)d, (double)Double.POSITIVE_INFINITY), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) < 1.0)) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)d, (double)Double.NEGATIVE_INFINITY), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) > 1.0)) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)d, (double)Double.NEGATIVE_INFINITY), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) < 1.0)) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)d, (double)Double.POSITIVE_INFINITY), (double)-1.0);
        }
        Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)1.0, (double)Double.POSITIVE_INFINITY), (double)-1.0);
        Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)1.0, (double)Double.NEGATIVE_INFINITY), (double)-1.0);
        Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)-1.0, (double)Double.POSITIVE_INFINITY), (double)-1.0);
        Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)-1.0, (double)Double.NEGATIVE_INFINITY), (double)-1.0);
        for (double i : DOUBLES) {
            if (!(i > 0.0)) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)0.0, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i < 0.0)) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)Double.POSITIVE_INFINITY, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i < 0.0)) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)0.0, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i > 0.0)) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)Double.POSITIVE_INFINITY, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i > 0.0) || !Double.isInfinite(i) && i % 2.0 != 0.0) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)-0.0, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i < 0.0) || !Double.isInfinite(i) && i % 2.0 != 0.0) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i > 0.0) || i % 2.0 != 1.0) continue;
            Assert.assertEquals((double)-0.0, (double)FastMath.pow((double)-0.0, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i < 0.0) || i % 2.0 != -1.0) continue;
            Assert.assertEquals((double)-0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i > 0.0) || !Double.isInfinite(i) && i % 2.0 != 0.0) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i < 0.0) || !Double.isInfinite(i) && i % 2.0 != 0.0) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i > 0.0) || i % 2.0 != 1.0) continue;
            Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (double)i), (double)-1.0);
        }
        for (double i : DOUBLES) {
            if (!(i < 0.0) || i % 2.0 != -1.0) continue;
            Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)-0.0, (double)i), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(d < 0.0) || !(Math.abs(d) <= Double.MAX_VALUE)) continue;
            for (double i : DOUBLES) {
                if (!(Math.abs(i) <= Double.MAX_VALUE)) continue;
                if (i % 2.0 == 0.0) {
                    Assert.assertEquals((double)FastMath.pow((double)(-d), (double)i), (double)FastMath.pow((double)d, (double)i), (double)-1.0);
                    continue;
                }
                if (Math.abs(i) % 2.0 == 1.0) {
                    Assert.assertEquals((double)(-FastMath.pow((double)(-d), (double)i)), (double)FastMath.pow((double)d, (double)i), (double)-1.0);
                    continue;
                }
                Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)d, (double)i), (double)-1.0);
            }
        }
        int TOO_BIG_TO_CALCULATE = 18;
        for (double d : DOUBLES) {
            if (d % 1.0 != 0.0) continue;
            boolean dNegative = Double.doubleToRawLongBits(d) < 0L;
            for (double i : DOUBLES) {
                double expected;
                if (i % 1.0 != 0.0) continue;
                BigInteger bd = BigDecimal.valueOf(d).toBigInteger().abs();
                BigInteger bi = BigDecimal.valueOf(i).toBigInteger().abs();
                if (bd.bitLength() > 1 && bi.bitLength() > 1 && 32 - Integer.numberOfLeadingZeros(bd.bitLength()) + bi.bitLength() > 18) {
                    expected = i < 0.0 ? 0.0 : Double.POSITIVE_INFINITY;
                } else {
                    BigInteger res = ArithmeticUtils.pow((BigInteger)bd, (BigInteger)bi);
                    expected = i >= 0.0 ? res.doubleValue() : (res.signum() == 0 ? Double.POSITIVE_INFINITY : BigDecimal.ONE.divide(new BigDecimal(res), 1024, RoundingMode.HALF_UP).doubleValue());
                }
                if (dNegative && bi.testBit(0)) {
                    expected = -expected;
                }
                Assert.assertEquals((String)(d + "^" + i + "=" + expected + ", Math.pow=" + Math.pow(d, i)), (double)expected, (double)FastMath.pow((double)d, (double)i), (double)(expected == 0.0 || Double.isInfinite(expected) || Double.isNaN(expected) ? -1.0 : 2.0 * Math.ulp(expected)));
            }
        }
    }

    @Test
    public void testPowLargeIntegralDouble() {
        double y = FastMath.scalb((double)1.0, (int)65);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)FastMath.nextUp((double)1.0), (double)y), (double)1.0);
        Assert.assertEquals((double)1.0, (double)FastMath.pow((double)1.0, (double)y), (double)1.0);
        Assert.assertEquals((double)0.0, (double)FastMath.pow((double)FastMath.nextDown((double)1.0), (double)y), (double)1.0);
        Assert.assertEquals((double)0.0, (double)FastMath.pow((double)FastMath.nextUp((double)-1.0), (double)y), (double)1.0);
        Assert.assertEquals((double)1.0, (double)FastMath.pow((double)-1.0, (double)y), (double)1.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)FastMath.nextDown((double)-1.0), (double)y), (double)1.0);
    }

    @Test
    public void testAtan2SpecialCases() {
        Assert.assertTrue((String)"atan2(NaN, 0.0) should be NaN", (boolean)Double.isNaN(FastMath.atan2((double)Double.NaN, (double)0.0)));
        Assert.assertTrue((String)"atan2(0.0, NaN) should be NaN", (boolean)Double.isNaN(FastMath.atan2((double)0.0, (double)Double.NaN)));
        Assert.assertEquals((String)"atan2(0.0, 0.0) should be 0.0", (double)0.0, (double)FastMath.atan2((double)0.0, (double)0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(0.0, 0.001) should be 0.0", (double)0.0, (double)FastMath.atan2((double)0.0, (double)0.001), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(0.1, +Inf) should be 0.0", (double)0.0, (double)FastMath.atan2((double)0.1, (double)Double.POSITIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-0.0, 0.0) should be -0.0", (double)-0.0, (double)FastMath.atan2((double)-0.0, (double)0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-0.0, 0.001) should be -0.0", (double)-0.0, (double)FastMath.atan2((double)-0.0, (double)0.001), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-0.0, +Inf) should be -0.0", (double)-0.0, (double)FastMath.atan2((double)-0.1, (double)Double.POSITIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(0.0, -0.0) should be PI", (double)Math.PI, (double)FastMath.atan2((double)0.0, (double)-0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(0.1, -Inf) should be PI", (double)Math.PI, (double)FastMath.atan2((double)0.1, (double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-0.0, -0.0) should be -PI", (double)(-Math.PI), (double)FastMath.atan2((double)-0.0, (double)-0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(0.1, -Inf) should be -PI", (double)(-Math.PI), (double)FastMath.atan2((double)-0.1, (double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(0.1, 0.0) should be PI/2", (double)1.5707963267948966, (double)FastMath.atan2((double)0.1, (double)0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(0.1, -0.0) should be PI/2", (double)1.5707963267948966, (double)FastMath.atan2((double)0.1, (double)-0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(Inf, 0.1) should be PI/2", (double)1.5707963267948966, (double)FastMath.atan2((double)Double.POSITIVE_INFINITY, (double)0.1), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(Inf, -0.1) should be PI/2", (double)1.5707963267948966, (double)FastMath.atan2((double)Double.POSITIVE_INFINITY, (double)-0.1), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-0.1, 0.0) should be -PI/2", (double)-1.5707963267948966, (double)FastMath.atan2((double)-0.1, (double)0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-0.1, -0.0) should be -PI/2", (double)-1.5707963267948966, (double)FastMath.atan2((double)-0.1, (double)-0.0), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-Inf, 0.1) should be -PI/2", (double)-1.5707963267948966, (double)FastMath.atan2((double)Double.NEGATIVE_INFINITY, (double)0.1), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-Inf, -0.1) should be -PI/2", (double)-1.5707963267948966, (double)FastMath.atan2((double)Double.NEGATIVE_INFINITY, (double)-0.1), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(Inf, Inf) should be PI/4", (double)0.7853981633974483, (double)FastMath.atan2((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(Inf, -Inf) should be PI * 3/4", (double)2.356194490192345, (double)FastMath.atan2((double)Double.POSITIVE_INFINITY, (double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-Inf, Inf) should be -PI/4", (double)-0.7853981633974483, (double)FastMath.atan2((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (double)Precision.EPSILON);
        Assert.assertEquals((String)"atan2(-Inf, -Inf) should be -PI * 3/4", (double)-2.356194490192345, (double)FastMath.atan2((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY), (double)Precision.EPSILON);
    }

    @Test
    public void testPowAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double y;
            double x = this.generator.nextDouble() * 2.0 + 0.25;
            double tst = FastMath.pow((double)x, (double)(y = (this.generator.nextDouble() * 1200.0 - 600.0) * this.generator.nextDouble()));
            double err = (tst - (ref = DfpMath.pow((Dfp)this.field.newDfp(x), (Dfp)this.field.newDfp(y)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.pow((Dfp)this.field.newDfp(x), (Dfp)this.field.newDfp(y))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"pow() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testExpAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 1416.0 - 708.0) * this.generator.nextDouble();
            double tst = FastMath.exp((double)x);
            double err = (tst - (ref = DfpMath.exp((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.exp((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"exp() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testSinAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * Math.PI - 1.5707963267948966) * Math.pow(2.0, 21.0) * this.generator.nextDouble();
            double tst = FastMath.sin((double)x);
            double err = (tst - (ref = DfpMath.sin((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.sin((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"sin() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testCosAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * Math.PI - 1.5707963267948966) * Math.pow(2.0, 21.0) * this.generator.nextDouble();
            double tst = FastMath.cos((double)x);
            double err = (tst - (ref = DfpMath.cos((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.cos((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"cos() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testTanAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * Math.PI - 1.5707963267948966) * Math.pow(2.0, 12.0) * this.generator.nextDouble();
            double tst = FastMath.tan((double)x);
            double err = (tst - (ref = DfpMath.tan((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.tan((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"tan() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testAtanAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 16.0 - 8.0) * this.generator.nextDouble();
            double tst = FastMath.atan((double)x);
            double err = (tst - (ref = DfpMath.atan((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.atan((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"atan() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testAtan2Accuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double err;
            double x = this.generator.nextDouble() - 0.5;
            double y = this.generator.nextDouble() - 0.5;
            double tst = FastMath.atan2((double)y, (double)x);
            Dfp refdfp = DfpMath.atan((Dfp)this.field.newDfp(y).divide(this.field.newDfp(x)));
            if (x < 0.0) {
                refdfp = y > 0.0 ? this.field.getPi().add(refdfp) : refdfp.subtract(this.field.getPi());
            }
            if ((err = (tst - (ref = refdfp.toDouble())) / ref) == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(refdfp).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"atan2() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testExpm1Accuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 16.0 - 8.0) * this.generator.nextDouble();
            double tst = FastMath.expm1((double)x);
            double err = (tst - (ref = DfpMath.exp((Dfp)this.field.newDfp(x)).subtract(this.field.getOne()).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.exp((Dfp)this.field.newDfp(x)).subtract(this.field.getOne())).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"expm1() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testAsinAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 10000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 2.0 - 1.0) * this.generator.nextDouble();
            double tst = FastMath.asin((double)x);
            double err = (tst - (ref = DfpMath.asin((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.asin((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"asin() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testAcosAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 10000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 2.0 - 1.0) * this.generator.nextDouble();
            double tst = FastMath.acos((double)x);
            double err = (tst - (ref = DfpMath.acos((Dfp)this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.acos((Dfp)this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"acos() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testAcosSpecialCases() {
        Assert.assertTrue((String)"acos(NaN) should be NaN", (boolean)Double.isNaN(FastMath.acos((double)Double.NaN)));
        Assert.assertTrue((String)"acos(-1.1) should be NaN", (boolean)Double.isNaN(FastMath.acos((double)-1.1)));
        Assert.assertTrue((String)"acos(-1.1) should be NaN", (boolean)Double.isNaN(FastMath.acos((double)1.1)));
        Assert.assertEquals((String)"acos(-1.0) should be PI", (double)FastMath.acos((double)-1.0), (double)Math.PI, (double)Precision.EPSILON);
        Assert.assertEquals((String)"acos(1.0) should be 0.0", (double)FastMath.acos((double)1.0), (double)0.0, (double)Precision.EPSILON);
        Assert.assertEquals((String)"acos(0.0) should be PI/2", (double)FastMath.acos((double)0.0), (double)1.5707963267948966, (double)Precision.EPSILON);
    }

    @Test
    public void testAsinSpecialCases() {
        Assert.assertTrue((String)"asin(NaN) should be NaN", (boolean)Double.isNaN(FastMath.asin((double)Double.NaN)));
        Assert.assertTrue((String)"asin(1.1) should be NaN", (boolean)Double.isNaN(FastMath.asin((double)1.1)));
        Assert.assertTrue((String)"asin(-1.1) should be NaN", (boolean)Double.isNaN(FastMath.asin((double)-1.1)));
        Assert.assertEquals((String)"asin(1.0) should be PI/2", (double)FastMath.asin((double)1.0), (double)1.5707963267948966, (double)Precision.EPSILON);
        Assert.assertEquals((String)"asin(-1.0) should be -PI/2", (double)FastMath.asin((double)-1.0), (double)-1.5707963267948966, (double)Precision.EPSILON);
        Assert.assertEquals((String)"asin(0.0) should be 0.0", (double)FastMath.asin((double)0.0), (double)0.0, (double)Precision.EPSILON);
    }

    private Dfp cosh(Dfp x) {
        return DfpMath.exp((Dfp)x).add(DfpMath.exp((Dfp)x.negate())).divide(2);
    }

    private Dfp sinh(Dfp x) {
        return DfpMath.exp((Dfp)x).subtract(DfpMath.exp((Dfp)x.negate())).divide(2);
    }

    private Dfp tanh(Dfp x) {
        return this.sinh(x).divide(this.cosh(x));
    }

    @Test
    public void testSinhAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 10000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 16.0 - 8.0) * this.generator.nextDouble();
            double tst = FastMath.sinh((double)x);
            double err = (tst - (ref = this.sinh(this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(this.sinh(this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"sinh() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testCoshAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 10000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 16.0 - 8.0) * this.generator.nextDouble();
            double tst = FastMath.cosh((double)x);
            double err = (tst - (ref = this.cosh(this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(this.cosh(this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"cosh() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testTanhAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 10000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 16.0 - 8.0) * this.generator.nextDouble();
            double tst = FastMath.tanh((double)x);
            double err = (tst - (ref = this.tanh(this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(this.tanh(this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"tanh() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testCbrtAccuracy() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 10000; ++i) {
            double ref;
            double x = (this.generator.nextDouble() * 200.0 - 100.0) * this.generator.nextDouble();
            double tst = FastMath.cbrt((double)x);
            double err = (tst - (ref = this.cbrt(this.field.newDfp(x)).toDouble())) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(this.cbrt(this.field.newDfp(x))).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"cbrt() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    private Dfp cbrt(Dfp x) {
        boolean negative = false;
        if (x.lessThan(this.field.getZero())) {
            negative = true;
            x = x.negate();
        }
        Dfp y = DfpMath.pow((Dfp)x, (Dfp)this.field.getOne().divide(3));
        if (negative) {
            y = y.negate();
        }
        return y;
    }

    @Test
    public void testToDegrees() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = this.generator.nextDouble();
            double tst = this.field.newDfp(x).multiply(180).divide(this.field.getPi()).toDouble();
            double err = (tst - (ref = FastMath.toDegrees((double)x))) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.exp((Dfp)this.field.newDfp(x)).subtract(this.field.getOne())).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"toDegrees() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testToRadians() {
        double maxerrulp = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double ref;
            double x = this.generator.nextDouble();
            double tst = this.field.newDfp(x).multiply(this.field.getPi()).divide(180).toDouble();
            double err = (tst - (ref = FastMath.toRadians((double)x))) / ref;
            if (err == 0.0) continue;
            double ulp = Math.abs(ref - Double.longBitsToDouble(Double.doubleToLongBits(ref) ^ 1L));
            double errulp = this.field.newDfp(tst).subtract(DfpMath.exp((Dfp)this.field.newDfp(x)).subtract(this.field.getOne())).divide(this.field.newDfp(ulp)).toDouble();
            maxerrulp = Math.max(maxerrulp, Math.abs(errulp));
        }
        Assert.assertTrue((String)"toRadians() had errors in excess of 0.51 ULP", (maxerrulp < 0.51 ? 1 : 0) != 0);
    }

    @Test
    public void testNextAfter() {
        Assert.assertEquals((double)16.0, (double)FastMath.nextUp((double)15.999999999999998), (double)0.0);
        Assert.assertEquals((double)-15.999999999999996, (double)FastMath.nextAfter((double)-15.999999999999998, (double)34.27555555555555), (double)0.0);
        Assert.assertEquals((double)15.999999999999996, (double)FastMath.nextDown((double)15.999999999999998), (double)0.0);
        Assert.assertEquals((double)-15.999999999999996, (double)FastMath.nextAfter((double)-15.999999999999998, (double)2.142222222222222), (double)0.0);
        Assert.assertEquals((double)8.000000000000002, (double)FastMath.nextAfter((double)8.0, (double)34.27555555555555), (double)0.0);
        Assert.assertEquals((double)-7.999999999999999, (double)FastMath.nextAfter((double)-8.0, (double)34.27555555555555), (double)0.0);
        Assert.assertEquals((double)7.999999999999999, (double)FastMath.nextAfter((double)8.0, (double)2.142222222222222), (double)0.0);
        Assert.assertEquals((double)-7.999999999999999, (double)FastMath.nextAfter((double)-8.0, (double)2.142222222222222), (double)0.0);
        Assert.assertEquals((double)2.308922399667661E-4, (double)FastMath.nextAfter((double)2.3089223996676606E-4, (double)2.308922399667661E-4), (double)0.0);
        Assert.assertEquals((double)2.3089223996676606E-4, (double)FastMath.nextAfter((double)2.3089223996676606E-4, (double)2.3089223996676606E-4), (double)0.0);
        Assert.assertEquals((double)2.3089223996676603E-4, (double)FastMath.nextAfter((double)2.3089223996676606E-4, (double)2.3089223996676603E-4), (double)0.0);
        Assert.assertEquals((double)2.3089223996676603E-4, (double)FastMath.nextAfter((double)2.3089223996676606E-4, (double)-2.308922399667661E-4), (double)0.0);
        Assert.assertEquals((double)2.3089223996676603E-4, (double)FastMath.nextAfter((double)2.3089223996676606E-4, (double)-2.3089223996676606E-4), (double)0.0);
        Assert.assertEquals((double)2.3089223996676603E-4, (double)FastMath.nextAfter((double)2.3089223996676606E-4, (double)-2.3089223996676603E-4), (double)0.0);
        Assert.assertEquals((double)-2.3089223996676603E-4, (double)FastMath.nextAfter((double)-2.3089223996676606E-4, (double)2.308922399667661E-4), (double)0.0);
        Assert.assertEquals((double)-2.3089223996676603E-4, (double)FastMath.nextAfter((double)-2.3089223996676606E-4, (double)2.3089223996676606E-4), (double)0.0);
        Assert.assertEquals((double)-2.3089223996676603E-4, (double)FastMath.nextAfter((double)-2.3089223996676606E-4, (double)2.3089223996676603E-4), (double)0.0);
        Assert.assertEquals((double)-2.308922399667661E-4, (double)FastMath.nextAfter((double)-2.3089223996676606E-4, (double)-2.308922399667661E-4), (double)0.0);
        Assert.assertEquals((double)-2.3089223996676606E-4, (double)FastMath.nextAfter((double)-2.3089223996676606E-4, (double)-2.3089223996676606E-4), (double)0.0);
        Assert.assertEquals((double)-2.3089223996676603E-4, (double)FastMath.nextAfter((double)-2.3089223996676606E-4, (double)-2.3089223996676603E-4), (double)0.0);
    }

    @Test
    public void testDoubleNextAfterSpecialCases() {
        Assert.assertEquals((double)-1.7976931348623157E308, (double)FastMath.nextAfter((double)Double.NEGATIVE_INFINITY, (double)0.0), (double)0.0);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)FastMath.nextAfter((double)Double.POSITIVE_INFINITY, (double)0.0), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)FastMath.nextAfter((double)Double.NaN, (double)0.0), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.nextAfter((double)Double.MAX_VALUE, (double)Double.POSITIVE_INFINITY), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.nextAfter((double)-1.7976931348623157E308, (double)Double.NEGATIVE_INFINITY), (double)0.0);
        Assert.assertEquals((double)Double.MIN_VALUE, (double)FastMath.nextAfter((double)0.0, (double)1.0), (double)0.0);
        Assert.assertEquals((double)-4.9E-324, (double)FastMath.nextAfter((double)0.0, (double)-1.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)FastMath.nextAfter((double)Double.MIN_VALUE, (double)-1.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)FastMath.nextAfter((double)-4.9E-324, (double)1.0), (double)0.0);
    }

    @Test
    public void testFloatNextAfterSpecialCases() {
        Assert.assertEquals((float)-3.4028235E38f, (float)FastMath.nextAfter((float)Float.NEGATIVE_INFINITY, (double)0.0), (float)0.0f);
        Assert.assertEquals((float)Float.MAX_VALUE, (float)FastMath.nextAfter((float)Float.POSITIVE_INFINITY, (double)0.0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)FastMath.nextAfter((float)Float.NaN, (double)0.0), (float)0.0f);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)FastMath.nextUp((float)Float.MAX_VALUE), (float)0.0f);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)FastMath.nextDown((float)-3.4028235E38f), (float)0.0f);
        Assert.assertEquals((float)Float.MIN_VALUE, (float)FastMath.nextAfter((float)0.0f, (double)1.0), (float)0.0f);
        Assert.assertEquals((float)-1.4E-45f, (float)FastMath.nextAfter((float)0.0f, (double)-1.0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)FastMath.nextAfter((float)Float.MIN_VALUE, (double)-1.0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)FastMath.nextAfter((float)-1.4E-45f, (double)1.0), (float)0.0f);
    }

    @Test
    public void testDoubleScalbSpecialCases() {
        Assert.assertEquals((double)2.526984132470122E-175, (double)FastMath.scalb((double)Double.MIN_NORMAL, (int)442), (double)0.0);
        Assert.assertEquals((double)1.307993905256674E297, (double)FastMath.scalb((double)1.110223E-16f, (int)1040), (double)0.0);
        Assert.assertEquals((double)7.252088799648895E-217, (double)FastMath.scalb((double)Double.MIN_VALUE, (int)356), (double)0.0);
        Assert.assertEquals((double)8.98846567431158E307, (double)FastMath.scalb((double)Double.MIN_VALUE, (int)2097), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.scalb((double)Double.MIN_VALUE, (int)2098), (double)0.0);
        Assert.assertEquals((double)1.1125369292536007E-308, (double)FastMath.scalb((double)2.225073858507201E-308, (int)-1), (double)0.0);
        Assert.assertEquals((double)9.9E-324, (double)FastMath.scalb((double)Double.MAX_VALUE, (int)-2097), (double)0.0);
        Assert.assertEquals((double)Double.MIN_VALUE, (double)FastMath.scalb((double)Double.MAX_VALUE, (int)-2098), (double)0.0);
        Assert.assertEquals((double)0.0, (double)FastMath.scalb((double)Double.MAX_VALUE, (int)-2099), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.scalb((double)Double.POSITIVE_INFINITY, (int)-1000000), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.scalb((double)-1.110223E-16f, (int)1078), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.scalb((double)-1.110223E-16f, (int)1079), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.scalb((double)-2.2250738585072014E-308, (int)2047), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.scalb((double)-2.2250738585072014E-308, (int)2048), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.scalb((double)-1.7976931348623157E308, (int)Integer.MAX_VALUE), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.scalb((double)Double.MAX_VALUE, (int)Integer.MAX_VALUE), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.scalb((double)-1.110223E-16f, (int)Integer.MAX_VALUE), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.scalb((double)1.110223E-16f, (int)Integer.MAX_VALUE), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.scalb((double)-2.2250738585072014E-308, (int)Integer.MAX_VALUE), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.scalb((double)Double.MIN_NORMAL, (int)Integer.MAX_VALUE), (double)0.0);
    }

    @Test
    public void testFloatScalbSpecialCases() {
        Assert.assertEquals((float)0.0f, (float)FastMath.scalb((float)Float.MIN_VALUE, (int)-30), (float)0.0f);
        Assert.assertEquals((float)2.8E-45f, (float)FastMath.scalb((float)Float.MIN_VALUE, (int)1), (float)0.0f);
        Assert.assertEquals((float)7.555786E22f, (float)FastMath.scalb((float)Float.MAX_VALUE, (int)-52), (float)0.0f);
        Assert.assertEquals((float)1.7014118E38f, (float)FastMath.scalb((float)Float.MIN_VALUE, (int)276), (float)0.0f);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)FastMath.scalb((float)Float.MIN_VALUE, (int)277), (float)0.0f);
        Assert.assertEquals((float)5.877472E-39f, (float)FastMath.scalb((float)Float.MIN_NORMAL, (int)-1), (float)0.0f);
        Assert.assertEquals((float)2.8E-45f, (float)FastMath.scalb((float)Float.MAX_VALUE, (int)-276), (float)0.0f);
        Assert.assertEquals((float)Float.MIN_VALUE, (float)FastMath.scalb((float)Float.MAX_VALUE, (int)-277), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)FastMath.scalb((float)Float.MAX_VALUE, (int)-278), (float)0.0f);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)FastMath.scalb((float)Float.POSITIVE_INFINITY, (int)-1000000), (float)0.0f);
        Assert.assertEquals((float)-3.139945E38f, (float)FastMath.scalb((float)-1.1E-7f, (int)151), (float)0.0f);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)FastMath.scalb((float)-1.1E-7f, (int)152), (float)0.0f);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)FastMath.scalb((float)Float.MAX_VALUE, (int)Integer.MAX_VALUE), (float)0.0f);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)FastMath.scalb((float)-3.4028235E38f, (int)Integer.MAX_VALUE), (float)0.0f);
    }

    private boolean compareClassMethods(Class<?> class1, Class<?> class2) {
        boolean allfound = true;
        for (Method method1 : class1.getDeclaredMethods()) {
            if (!Modifier.isPublic(method1.getModifiers())) continue;
            Type[] params = method1.getGenericParameterTypes();
            try {
                class2.getDeclaredMethod(method1.getName(), (Class[])params);
            }
            catch (NoSuchMethodException e) {
                allfound = false;
                System.out.println(class2.getSimpleName() + " does not implement: " + method1);
            }
        }
        return allfound;
    }

    @Test
    public void checkMissingFastMathClasses() {
        boolean ok = this.compareClassMethods(StrictMath.class, FastMath.class);
        Assert.assertTrue((String)"FastMath should implement all StrictMath methods", (boolean)ok);
    }

    @Ignore
    @Test
    public void checkExtraFastMathClasses() {
        this.compareClassMethods(FastMath.class, StrictMath.class);
    }

    @Test
    public void testSignumDouble() {
        double delta = 0.0;
        Assert.assertEquals((double)1.0, (double)FastMath.signum((double)2.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)FastMath.signum((double)0.0), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)FastMath.signum((double)-2.0), (double)0.0);
        TestUtils.assertSame(Double.NaN, FastMath.signum((double)Double.NaN));
    }

    @Test
    public void testSignumFloat() {
        float delta = 0.0f;
        Assert.assertEquals((float)1.0f, (float)FastMath.signum((float)2.0f), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)FastMath.signum((float)0.0f), (float)0.0f);
        Assert.assertEquals((float)-1.0f, (float)FastMath.signum((float)-2.0f), (float)0.0f);
        TestUtils.assertSame(Double.NaN, FastMath.signum((float)Float.NaN));
    }

    @Test
    public void testLogWithBase() {
        Assert.assertEquals((double)2.0, (double)FastMath.log((double)2.0, (double)4.0), (double)0.0);
        Assert.assertEquals((double)3.0, (double)FastMath.log((double)2.0, (double)8.0), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(FastMath.log((double)-1.0, (double)1.0)));
        Assert.assertTrue((boolean)Double.isNaN(FastMath.log((double)1.0, (double)-1.0)));
        Assert.assertTrue((boolean)Double.isNaN(FastMath.log((double)0.0, (double)0.0)));
        Assert.assertEquals((double)0.0, (double)FastMath.log((double)0.0, (double)10.0), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.log((double)10.0, (double)0.0), (double)0.0);
    }

    @Test
    public void testIndicatorDouble() {
        double delta = 0.0;
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)2.0), (double)delta);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)0.0), (double)delta);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)-0.0), (double)delta);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)Double.POSITIVE_INFINITY), (double)delta);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)Double.NEGATIVE_INFINITY), (double)delta);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)Double.NaN), (double)delta);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)-2.0), (double)delta);
    }

    @Test
    public void testIndicatorFloat() {
        float delta = 0.0f;
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)2.0), (double)delta);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)0.0), (double)delta);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)-0.0), (double)delta);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)Double.POSITIVE_INFINITY), (double)delta);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)Double.NEGATIVE_INFINITY), (double)delta);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)Double.NaN), (double)delta);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)-2.0), (double)delta);
    }

    @Test
    public void testIntPow() {
        int maxExp = 300;
        DfpField field = new DfpField(40);
        double base = 1.23456789;
        Dfp baseDfp = field.newDfp(1.23456789);
        Dfp dfpPower = field.getOne();
        for (int i = 0; i < 300; ++i) {
            Assert.assertEquals((String)("exp=" + i), (double)dfpPower.toDouble(), (double)FastMath.pow((double)1.23456789, (int)i), (double)(0.6 * FastMath.ulp((double)dfpPower.toDouble())));
            dfpPower = dfpPower.multiply(baseDfp);
        }
    }

    @Test
    public void testIntPowHuge() {
        Assert.assertTrue((boolean)Double.isInfinite(FastMath.pow((double)FastMath.scalb((double)1.0, (int)500), (int)4)));
    }

    @Test(timeout=5000L)
    public void testIntPowLongMinValue() {
        Assert.assertEquals((double)1.0, (double)FastMath.pow((double)1.0, (long)Long.MIN_VALUE), (double)-1.0);
    }

    @Test(timeout=5000L)
    public void testIntPowSpecialCases() {
        double EXACT = -1.0;
        double[] DOUBLES = new double[]{Double.NEGATIVE_INFINITY, -0.0, Double.NaN, 0.0, Double.POSITIVE_INFINITY, -9.223372036854776E18, -2.147483648E9, -32768.0, -128.0, 9.223372036854776E18, 2.147483648E9, 32768.0, 128.0, 127.0, 32767.0, 2.147483647E9, 9.223372036854776E18, -127.0, -32767.0, -2.147483647E9, -9.223372036854776E18, 3.4028234663852886E38, Double.MAX_VALUE, Double.MIN_VALUE, 1.4E-45f, -3.4028234663852886E38, -1.7976931348623157E308, -4.9E-324, -1.4E-45f, 0.5, 0.1, 0.2, 0.8, 1.1, 1.2, 1.5, 1.8, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 1.3, 2.2, 2.5, 2.8, 33.0, 33.1, 33.5, 33.8, 10.0, 300.0, 400.0, 500.0, -0.5, -0.1, -0.2, -0.8, -1.1, -1.2, -1.5, -1.8, -1.0, -2.0, -3.0, -4.0, -5.0, -6.0, -7.0, -8.0, -9.0, -1.3, -2.2, -2.5, -2.8, -33.0, -33.1, -33.5, -33.8, -10.0, -300.0, -400.0, -500.0};
        long[] INTS = new long[]{Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, Long.MIN_VALUE, -9223372036854775807L, -9223372036854775806L, Integer.MAX_VALUE, 0x7FFFFFFEL, Integer.MIN_VALUE, -2147483647L, -2147483646L, 0L, 1L, 2L, 3L, 5L, 8L, 10L, 20L, 100L, 300L, 500L, -1L, -2L, -3L, -5L, -8L, -10L, -20L, -100L, -300L, -500L};
        for (double d : DOUBLES) {
            Assert.assertEquals((double)1.0, (double)FastMath.pow((double)d, (long)0L), (double)-1.0);
        }
        for (double d : DOUBLES) {
            Assert.assertEquals((double)d, (double)FastMath.pow((double)d, (long)1L), (double)-1.0);
        }
        for (long i : INTS) {
            if (i == 0L) continue;
            Assert.assertEquals((double)Double.NaN, (double)FastMath.pow((double)Double.NaN, (long)i), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) > 1.0)) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)d, (long)0x7FFFFFFFFFFFFFFEL), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) < 1.0)) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)d, (long)Long.MIN_VALUE), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) > 1.0)) continue;
            Assert.assertTrue((boolean)Double.isInfinite(FastMath.pow((double)d, (long)Long.MAX_VALUE)));
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) < 1.0)) continue;
            Assert.assertTrue((boolean)Double.isInfinite(FastMath.pow((double)d, (long)-9223372036854775807L)));
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) > 1.0)) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)d, (long)Long.MIN_VALUE), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) < 1.0)) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)d, (long)0x7FFFFFFFFFFFFFFEL), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) > 1.0)) continue;
            Assert.assertTrue((FastMath.pow((double)d, (long)-9223372036854775807L) == 0.0 ? 1 : 0) != 0);
        }
        for (double d : DOUBLES) {
            if (!(Math.abs(d) < 1.0)) continue;
            Assert.assertTrue((FastMath.pow((double)d, (long)Long.MAX_VALUE) == 0.0 ? 1 : 0) != 0);
        }
        for (long i : INTS) {
            if (i <= 0L) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)0.0, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i >= 0L) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)Double.POSITIVE_INFINITY, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i >= 0L) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)0.0, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i <= 0L) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)Double.POSITIVE_INFINITY, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i <= 0L || (i & 1L) != 0L) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)-0.0, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i >= 0L || (i & 1L) != 0L) continue;
            Assert.assertEquals((double)0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i <= 0L || (i & 1L) != 1L) continue;
            Assert.assertEquals((double)-0.0, (double)FastMath.pow((double)-0.0, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i >= 0L || (i & 1L) != 1L) continue;
            Assert.assertEquals((double)-0.0, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i <= 0L || (i & 1L) != 0L) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i >= 0L || (i & 1L) != 0L) continue;
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)FastMath.pow((double)-0.0, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i <= 0L || (i & 1L) != 1L) continue;
            Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)Double.NEGATIVE_INFINITY, (long)i), (double)-1.0);
        }
        for (long i : INTS) {
            if (i >= 0L || (i & 1L) != 1L) continue;
            Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)FastMath.pow((double)-0.0, (long)i), (double)-1.0);
        }
        for (double d : DOUBLES) {
            if (!(d < 0.0) || !(Math.abs(d) <= Double.MAX_VALUE)) continue;
            for (long i : INTS) {
                if ((i & 1L) == 0L) {
                    Assert.assertEquals((double)FastMath.pow((double)(-d), (long)i), (double)FastMath.pow((double)d, (long)i), (double)-1.0);
                    continue;
                }
                Assert.assertEquals((double)(-FastMath.pow((double)(-d), (long)i)), (double)FastMath.pow((double)d, (long)i), (double)-1.0);
            }
        }
    }

    @Test
    public void testIncrementExactInt() {
        int[] specialValues;
        for (int a : specialValues = new int[]{Integer.MIN_VALUE, -2147483647, -2147483646, Integer.MAX_VALUE, 0x7FFFFFFE, 0x7FFFFFFD, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0x3FFFFFFF, 0x40000000, 0x40000001, 0x3FFFFFFE, 0x3FFFFFFF, 0x40000000}) {
            BigInteger bdA = BigInteger.valueOf(a);
            BigInteger bdSum = bdA.add(BigInteger.ONE);
            if (bdSum.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bdSum.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                try {
                    FastMath.incrementExact((int)a);
                    Assert.fail((String)"an exception should have been thrown");
                }
                catch (MathArithmeticException mathArithmeticException) {}
                continue;
            }
            Assert.assertEquals((Object)bdSum, (Object)BigInteger.valueOf(FastMath.incrementExact((int)a)));
        }
    }

    @Test
    public void testDecrementExactInt() {
        int[] specialValues;
        for (int a : specialValues = new int[]{Integer.MIN_VALUE, -2147483647, -2147483646, Integer.MAX_VALUE, 0x7FFFFFFE, 0x7FFFFFFD, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0x3FFFFFFF, 0x40000000, 0x40000001, 0x3FFFFFFE, 0x3FFFFFFF, 0x40000000}) {
            BigInteger bdA = BigInteger.valueOf(a);
            BigInteger bdSub = bdA.subtract(BigInteger.ONE);
            if (bdSub.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bdSub.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                try {
                    FastMath.decrementExact((int)a);
                    Assert.fail((String)"an exception should have been thrown");
                }
                catch (MathArithmeticException mathArithmeticException) {}
                continue;
            }
            Assert.assertEquals((Object)bdSub, (Object)BigInteger.valueOf(FastMath.decrementExact((int)a)));
        }
    }

    @Test
    public void testAddExactInt() {
        int[] specialValues;
        for (int a : specialValues = new int[]{Integer.MIN_VALUE, -2147483647, -2147483646, Integer.MAX_VALUE, 0x7FFFFFFE, 0x7FFFFFFD, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0x3FFFFFFF, 0x40000000, 0x40000001, 0x3FFFFFFE, 0x3FFFFFFF, 0x40000000}) {
            for (int b : specialValues) {
                BigInteger bdB;
                BigInteger bdA = BigInteger.valueOf(a);
                BigInteger bdSum = bdA.add(bdB = BigInteger.valueOf(b));
                if (bdSum.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bdSum.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                    try {
                        FastMath.addExact((int)a, (int)b);
                        Assert.fail((String)"an exception should have been thrown");
                    }
                    catch (MathArithmeticException mathArithmeticException) {}
                    continue;
                }
                Assert.assertEquals((Object)bdSum, (Object)BigInteger.valueOf(FastMath.addExact((int)a, (int)b)));
            }
        }
    }

    @Test
    public void testAddExactLong() {
        long[] specialValues;
        for (long a : specialValues = new long[]{Long.MIN_VALUE, -9223372036854775807L, -9223372036854775806L, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL, -10L, -9L, -8L, -7L, -6L, -5L, -4L, -3L, -2L, -1L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 0x3FFFFFFFFFFFFFFFL, 0x4000000000000000L, 0x4000000000000001L, 0x3FFFFFFFFFFFFFFEL, 0x3FFFFFFFFFFFFFFFL, 0x4000000000000000L}) {
            for (long b : specialValues) {
                BigInteger bdB;
                BigInteger bdA = BigInteger.valueOf(a);
                BigInteger bdSum = bdA.add(bdB = BigInteger.valueOf(b));
                if (bdSum.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bdSum.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                    try {
                        FastMath.addExact((long)a, (long)b);
                        Assert.fail((String)"an exception should have been thrown");
                    }
                    catch (MathArithmeticException mathArithmeticException) {}
                    continue;
                }
                Assert.assertEquals((Object)bdSum, (Object)BigInteger.valueOf(FastMath.addExact((long)a, (long)b)));
            }
        }
    }

    @Test
    public void testSubtractExactInt() {
        int[] specialValues;
        for (int a : specialValues = new int[]{Integer.MIN_VALUE, -2147483647, -2147483646, Integer.MAX_VALUE, 0x7FFFFFFE, 0x7FFFFFFD, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0x3FFFFFFF, 0x40000000, 0x40000001, 0x3FFFFFFE, 0x3FFFFFFF, 0x40000000}) {
            for (int b : specialValues) {
                BigInteger bdB;
                BigInteger bdA = BigInteger.valueOf(a);
                BigInteger bdSub = bdA.subtract(bdB = BigInteger.valueOf(b));
                if (bdSub.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bdSub.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                    try {
                        FastMath.subtractExact((int)a, (int)b);
                        Assert.fail((String)"an exception should have been thrown");
                    }
                    catch (MathArithmeticException mathArithmeticException) {}
                    continue;
                }
                Assert.assertEquals((Object)bdSub, (Object)BigInteger.valueOf(FastMath.subtractExact((int)a, (int)b)));
            }
        }
    }

    @Test
    public void testSubtractExactLong() {
        long[] specialValues;
        for (long a : specialValues = new long[]{Long.MIN_VALUE, -9223372036854775807L, -9223372036854775806L, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL, -10L, -9L, -8L, -7L, -6L, -5L, -4L, -3L, -2L, -1L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 0x3FFFFFFFFFFFFFFFL, 0x4000000000000000L, 0x4000000000000001L, 0x3FFFFFFFFFFFFFFEL, 0x3FFFFFFFFFFFFFFFL, 0x4000000000000000L}) {
            for (long b : specialValues) {
                BigInteger bdB;
                BigInteger bdA = BigInteger.valueOf(a);
                BigInteger bdSub = bdA.subtract(bdB = BigInteger.valueOf(b));
                if (bdSub.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bdSub.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                    try {
                        FastMath.subtractExact((long)a, (long)b);
                        Assert.fail((String)"an exception should have been thrown");
                    }
                    catch (MathArithmeticException mathArithmeticException) {}
                    continue;
                }
                Assert.assertEquals((Object)bdSub, (Object)BigInteger.valueOf(FastMath.subtractExact((long)a, (long)b)));
            }
        }
    }

    @Test
    public void testMultiplyExactInt() {
        int[] specialValues;
        for (int a : specialValues = new int[]{Integer.MIN_VALUE, -2147483647, -2147483646, Integer.MAX_VALUE, 0x7FFFFFFE, 0x7FFFFFFD, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0x3FFFFFFF, 0x40000000, 0x40000001, 0x3FFFFFFE, 0x3FFFFFFF, 0x40000000}) {
            for (int b : specialValues) {
                BigInteger bdB;
                BigInteger bdA = BigInteger.valueOf(a);
                BigInteger bdMul = bdA.multiply(bdB = BigInteger.valueOf(b));
                if (bdMul.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bdMul.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                    try {
                        FastMath.multiplyExact((int)a, (int)b);
                        Assert.fail((String)("an exception should have been thrown " + a + b));
                    }
                    catch (MathArithmeticException mathArithmeticException) {}
                    continue;
                }
                Assert.assertEquals((Object)bdMul, (Object)BigInteger.valueOf(FastMath.multiplyExact((int)a, (int)b)));
            }
        }
    }

    @Test
    public void testMultiplyExactLong() {
        long[] specialValues;
        for (long a : specialValues = new long[]{Long.MIN_VALUE, -9223372036854775807L, -9223372036854775806L, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL, -10L, -9L, -8L, -7L, -6L, -5L, -4L, -3L, -2L, -1L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 0x3FFFFFFFFFFFFFFFL, 0x4000000000000000L, 0x4000000000000001L, 0x3FFFFFFFFFFFFFFEL, 0x3FFFFFFFFFFFFFFFL, 0x4000000000000000L}) {
            for (long b : specialValues) {
                BigInteger bdB;
                BigInteger bdA = BigInteger.valueOf(a);
                BigInteger bdMul = bdA.multiply(bdB = BigInteger.valueOf(b));
                if (bdMul.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bdMul.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                    try {
                        FastMath.multiplyExact((long)a, (long)b);
                        Assert.fail((String)("an exception should have been thrown " + a + b));
                    }
                    catch (MathArithmeticException mathArithmeticException) {}
                    continue;
                }
                Assert.assertEquals((Object)bdMul, (Object)BigInteger.valueOf(FastMath.multiplyExact((long)a, (long)b)));
            }
        }
    }

    @Test(expected=MathArithmeticException.class)
    public void testToIntExactTooLow() {
        FastMath.toIntExact((long)-2147483649L);
    }

    @Test(expected=MathArithmeticException.class)
    public void testToIntExactTooHigh() {
        FastMath.toIntExact((long)0x80000000L);
    }

    @Test
    public void testToIntExact() {
        for (int n = -1000; n < 1000; ++n) {
            Assert.assertEquals((long)n, (long)FastMath.toIntExact((long)(0L + (long)n)));
        }
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)FastMath.toIntExact((long)Integer.MIN_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)FastMath.toIntExact((long)Integer.MAX_VALUE));
    }

    @Test
    public void testFloorDivInt() {
        Assert.assertEquals((long)1L, (long)FastMath.floorDiv((int)4, (int)3));
        Assert.assertEquals((long)-2L, (long)FastMath.floorDiv((int)-4, (int)3));
        Assert.assertEquals((long)-2L, (long)FastMath.floorDiv((int)4, (int)-3));
        Assert.assertEquals((long)1L, (long)FastMath.floorDiv((int)-4, (int)-3));
        try {
            FastMath.floorDiv((int)1, (int)0);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        for (int a = -100; a <= 100; ++a) {
            for (int b = -100; b <= 100; ++b) {
                if (b == 0) continue;
                Assert.assertEquals((long)this.poorManFloorDiv(a, b), (long)FastMath.floorDiv((int)a, (int)b));
            }
        }
    }

    @Test
    public void testFloorModInt() {
        Assert.assertEquals((long)1L, (long)FastMath.floorMod((int)4, (int)3));
        Assert.assertEquals((long)2L, (long)FastMath.floorMod((int)-4, (int)3));
        Assert.assertEquals((long)-2L, (long)FastMath.floorMod((int)4, (int)-3));
        Assert.assertEquals((long)-1L, (long)FastMath.floorMod((int)-4, (int)-3));
        try {
            FastMath.floorMod((int)1, (int)0);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        for (int a = -100; a <= 100; ++a) {
            for (int b = -100; b <= 100; ++b) {
                if (b == 0) continue;
                Assert.assertEquals((long)this.poorManFloorMod(a, b), (long)FastMath.floorMod((int)a, (int)b));
            }
        }
    }

    @Test
    public void testFloorDivModInt() {
        Well1024a generator = new Well1024a(8992197925554272522L);
        for (int i = 0; i < 10000; ++i) {
            int a = generator.nextInt();
            int b = generator.nextInt();
            if (b == 0) {
                try {
                    FastMath.floorDiv((int)a, (int)b);
                    Assert.fail((String)"an exception should have been thrown");
                }
                catch (MathArithmeticException mathArithmeticException) {}
                continue;
            }
            int d = FastMath.floorDiv((int)a, (int)b);
            int m = FastMath.floorMod((int)a, (int)b);
            Assert.assertEquals((long)FastMath.toIntExact((long)this.poorManFloorDiv(a, b)), (long)d);
            Assert.assertEquals((long)FastMath.toIntExact((long)this.poorManFloorMod(a, b)), (long)m);
            Assert.assertEquals((long)a, (long)(d * b + m));
            if (b < 0) {
                Assert.assertTrue((m <= 0 ? 1 : 0) != 0);
                Assert.assertTrue((-m < -b ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((m >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((m < b ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFloorDivLong() {
        Assert.assertEquals((long)1L, (long)FastMath.floorDiv((long)4L, (long)3L));
        Assert.assertEquals((long)-2L, (long)FastMath.floorDiv((long)-4L, (long)3L));
        Assert.assertEquals((long)-2L, (long)FastMath.floorDiv((long)4L, (long)-3L));
        Assert.assertEquals((long)1L, (long)FastMath.floorDiv((long)-4L, (long)-3L));
        try {
            FastMath.floorDiv((long)1L, (long)0L);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        for (long a = -100L; a <= 100L; ++a) {
            for (long b = -100L; b <= 100L; ++b) {
                if (b == 0L) continue;
                Assert.assertEquals((long)this.poorManFloorDiv(a, b), (long)FastMath.floorDiv((long)a, (long)b));
            }
        }
    }

    @Test
    public void testFloorModLong() {
        Assert.assertEquals((long)1L, (long)FastMath.floorMod((long)4L, (long)3L));
        Assert.assertEquals((long)2L, (long)FastMath.floorMod((long)-4L, (long)3L));
        Assert.assertEquals((long)-2L, (long)FastMath.floorMod((long)4L, (long)-3L));
        Assert.assertEquals((long)-1L, (long)FastMath.floorMod((long)-4L, (long)-3L));
        try {
            FastMath.floorMod((long)1L, (long)0L);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        for (long a = -100L; a <= 100L; ++a) {
            for (long b = -100L; b <= 100L; ++b) {
                if (b == 0L) continue;
                Assert.assertEquals((long)this.poorManFloorMod(a, b), (long)FastMath.floorMod((long)a, (long)b));
            }
        }
    }

    @Test
    public void testFloorDivModLong() {
        Well1024a generator = new Well1024a(-5153354094079456043L);
        for (int i = 0; i < 10000; ++i) {
            long a = generator.nextLong();
            long b = generator.nextLong();
            if (b == 0L) {
                try {
                    FastMath.floorDiv((long)a, (long)b);
                    Assert.fail((String)"an exception should have been thrown");
                }
                catch (MathArithmeticException mathArithmeticException) {}
                continue;
            }
            long d = FastMath.floorDiv((long)a, (long)b);
            long m = FastMath.floorMod((long)a, (long)b);
            Assert.assertEquals((long)this.poorManFloorDiv(a, b), (long)d);
            Assert.assertEquals((long)this.poorManFloorMod(a, b), (long)m);
            Assert.assertEquals((long)a, (long)(d * b + m));
            if (b < 0L) {
                Assert.assertTrue((m <= 0L ? 1 : 0) != 0);
                Assert.assertTrue((-m < -b ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((m >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((m < b ? 1 : 0) != 0);
        }
    }

    private long poorManFloorDiv(long a, long b) {
        BigInteger q0 = BigInteger.valueOf(a / b);
        BigInteger r0 = BigInteger.valueOf(a % b);
        BigInteger fd = BigInteger.valueOf(Integer.MIN_VALUE);
        BigInteger bigB = BigInteger.valueOf(b);
        for (int k = -2; k < 2; ++k) {
            BigInteger bigK = BigInteger.valueOf(k);
            BigInteger q = q0.subtract(bigK);
            BigInteger r = r0.add(bigK.multiply(bigB));
            if (r.abs().compareTo(bigB.abs()) >= 0 || r.longValue() != 0L && ((r.longValue() ^ b) & Long.MIN_VALUE) != 0L || fd.compareTo(q) >= 0) continue;
            fd = q;
        }
        return fd.longValue();
    }

    private long poorManFloorMod(long a, long b) {
        return a - b * this.poorManFloorDiv(a, b);
    }
}

