/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.UnitSphereRandomVectorGenerator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class UnitSphereRandomVectorGeneratorTest {
    @Test
    public void test2DDistribution() {
        JDKRandomGenerator rg = new JDKRandomGenerator();
        rg.setSeed(17399225432L);
        UnitSphereRandomVectorGenerator generator = new UnitSphereRandomVectorGenerator(2, (RandomGenerator)rg);
        int[] angleBuckets = new int[100];
        int steps = 1000000;
        for (int i = 0; i < steps; ++i) {
            int bucket;
            double[] v = generator.nextVector();
            Assert.assertEquals((long)2L, (long)v.length);
            Assert.assertEquals((double)1.0, (double)UnitSphereRandomVectorGeneratorTest.length(v), (double)1.0E-10);
            double angle = FastMath.acos((double)v[0]);
            int n = bucket = (int)((double)angleBuckets.length * (angle / Math.PI));
            angleBuckets[n] = angleBuckets[n] + 1;
        }
        int expectedBucketSize = steps / angleBuckets.length;
        for (int bucket : angleBuckets) {
            Assert.assertTrue((String)("Bucket count " + bucket + " vs expected " + expectedBucketSize), (FastMath.abs((int)(expectedBucketSize - bucket)) < 350 ? 1 : 0) != 0);
        }
    }

    private static double length(double[] vector) {
        double total = 0.0;
        for (double d : vector) {
            total += d * d;
        }
        return FastMath.sqrt((double)total);
    }
}

