/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.IntegerDistributionAbstractTest;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class HypergeometricDistributionTest
extends IntegerDistributionAbstractTest {
    public HypergeometricDistributionTest() {
        this.setTolerance(1.0E-12);
    }

    public IntegerDistribution makeDistribution() {
        return new HypergeometricDistribution(10, 5, 5);
    }

    public int[] makeDensityTestPoints() {
        return new int[]{-1, 0, 1, 2, 3, 4, 5, 10};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.00396825396825, 0.0992063492063, 0.396825396825, 0.396825396825, 0.0992063492063, 0.00396825396825, 0.0};
    }

    public double[] makeLogDensityTestValues() {
        return new double[]{Double.NEGATIVE_INFINITY, -5.52942908751142, -2.31055326264322, -0.924258901523332, -0.924258901523332, -2.31055326264322, -5.52942908751142, Double.NEGATIVE_INFINITY};
    }

    public int[] makeCumulativeTestPoints() {
        return this.makeDensityTestPoints();
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.00396825396825, 0.103174603175, 0.5, 0.896825396825, 0.996031746032, 1.0, 1.0};
    }

    public double[] makeInverseCumulativeTestPoints() {
        return new double[]{0.0, 0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9, 1.0};
    }

    public int[] makeInverseCumulativeTestValues() {
        return new int[]{0, 0, 1, 1, 1, 1, 5, 4, 4, 4, 4, 5};
    }

    @Test
    public void testDegenerateNoFailures() {
        HypergeometricDistribution dist = new HypergeometricDistribution(5, 5, 3);
        this.setDistribution((IntegerDistribution)dist);
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 3, 10});
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 1.0, 1.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 3, 10});
        this.setDensityTestValues(new double[]{0.0, 0.0, 0.0, 1.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{3, 3});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
        Assert.assertEquals((long)dist.getSupportLowerBound(), (long)3L);
        Assert.assertEquals((long)dist.getSupportUpperBound(), (long)3L);
    }

    @Test
    public void testDegenerateNoSuccesses() {
        HypergeometricDistribution dist = new HypergeometricDistribution(5, 0, 3);
        this.setDistribution((IntegerDistribution)dist);
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 3, 10});
        this.setCumulativeTestValues(new double[]{0.0, 1.0, 1.0, 1.0, 1.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 3, 10});
        this.setDensityTestValues(new double[]{0.0, 1.0, 0.0, 0.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{0, 0});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
        Assert.assertEquals((long)dist.getSupportLowerBound(), (long)0L);
        Assert.assertEquals((long)dist.getSupportUpperBound(), (long)0L);
    }

    @Test
    public void testDegenerateFullSample() {
        HypergeometricDistribution dist = new HypergeometricDistribution(5, 3, 5);
        this.setDistribution((IntegerDistribution)dist);
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 3, 10});
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 1.0, 1.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 3, 10});
        this.setDensityTestValues(new double[]{0.0, 0.0, 0.0, 1.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{3, 3});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
        Assert.assertEquals((long)dist.getSupportLowerBound(), (long)3L);
        Assert.assertEquals((long)dist.getSupportUpperBound(), (long)3L);
    }

    @Test
    public void testPreconditions() {
        try {
            new HypergeometricDistribution(0, 3, 5);
            Assert.fail((String)"negative population size. NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        try {
            new HypergeometricDistribution(5, -1, 5);
            Assert.fail((String)"negative number of successes. NotPositiveException expected");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        try {
            new HypergeometricDistribution(5, 3, -1);
            Assert.fail((String)"negative sample size. NotPositiveException expected");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        try {
            new HypergeometricDistribution(5, 6, 5);
            Assert.fail((String)"numberOfSuccesses > populationSize. NumberIsTooLargeException expected");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        try {
            new HypergeometricDistribution(5, 3, 6);
            Assert.fail((String)"sampleSize > populationSize. NumberIsTooLargeException expected");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
    }

    @Test
    public void testAccessors() {
        HypergeometricDistribution dist = new HypergeometricDistribution(5, 3, 4);
        Assert.assertEquals((long)5L, (long)dist.getPopulationSize());
        Assert.assertEquals((long)3L, (long)dist.getNumberOfSuccesses());
        Assert.assertEquals((long)4L, (long)dist.getSampleSize());
    }

    @Test
    public void testLargeValues() {
        int populationSize = 3456;
        int sampleSize = 789;
        int numberOfSucceses = 101;
        double[][] data = new double[][]{{0.0, 2.75646034603961E-12, 2.75646034603961E-12, 1.0}, {1.0, 8.55705370142386E-11, 8.83269973602783E-11, 0.999999999997244}, {2.0, 1.31288129219665E-9, 1.40120828955693E-9, 0.999999999911673}, {3.0, 1.32724172984193E-8, 1.46736255879763E-8, 0.999999998598792}, {4.0, 9.94501711734089E-8, 1.14123796761385E-7, 0.999999985326375}, {5.0, 5.89080768883643E-7, 7.03204565645028E-7, 0.999999885876203}, {20.0, 0.0760051397707708, 0.27349758476299, 0.802507555007781}, {21.0, 0.087144222047629, 0.360641806810619, 0.72650241523701}, {22.0, 0.0940378846881819, 0.454679691498801, 0.639358193189381}, {23.0, 0.0956897500614809, 0.550369441560282, 0.545320308501199}, {24.0, 0.0919766921922999, 0.642346133752582, 0.449630558439718}, {25.0, 0.083641637261095, 0.725987771013677, 0.357653866247418}, {96.0, 5.93849188852098E-57, 1.0, 6.01900244560712E-57}, {97.0, 7.96593036832547E-59, 1.0, 8.05105570861321E-59}, {98.0, 8.44582921934367E-61, 1.0, 8.5125340287733E-61}, {99.0, 6.63604297068222E-63, 1.0, 6.670480942963E-63}, {100.0, 3.43501099007557E-65, 1.0, 3.4437972280786E-65}, {101.0, 8.78623800302957E-68, 1.0, 8.78623800302957E-68}};
        this.testHypergeometricDistributionProbabilities(populationSize, sampleSize, numberOfSucceses, data);
    }

    private void testHypergeometricDistributionProbabilities(int populationSize, int sampleSize, int numberOfSucceses, double[][] data) {
        HypergeometricDistribution dist = new HypergeometricDistribution(populationSize, numberOfSucceses, sampleSize);
        for (int i = 0; i < data.length; ++i) {
            int x = (int)data[i][0];
            double pmf = data[i][1];
            double actualPmf = dist.probability(x);
            TestUtils.assertRelativelyEquals("Expected equals for <" + x + "> pmf", pmf, actualPmf, 1.0E-9);
            double cdf = data[i][2];
            double actualCdf = dist.cumulativeProbability(x);
            TestUtils.assertRelativelyEquals("Expected equals for <" + x + "> cdf", cdf, actualCdf, 1.0E-9);
            double cdf1 = data[i][3];
            double actualCdf1 = dist.upperCumulativeProbability(x);
            TestUtils.assertRelativelyEquals("Expected equals for <" + x + "> cdf1", cdf1, actualCdf1, 1.0E-9);
        }
    }

    @Test
    public void testMoreLargeValues() {
        int populationSize = 26896;
        int sampleSize = 895;
        int numberOfSucceses = 55;
        double[][] data = new double[][]{{0.0, 0.155168304750504, 0.155168304750504, 1.0}, {1.0, 0.29437545000746, 0.449543754757964, 0.844831695249496}, {2.0, 0.273841321577003, 0.723385076334967, 0.550456245242036}, {3.0, 0.166488572570786, 0.889873648905753, 0.276614923665033}, {4.0, 0.0743969744713231, 0.964270623377076, 0.110126351094247}, {5.0, 0.0260542785784855, 0.990324901955562, 0.0357293766229237}, {20.0, 3.57101101678792E-16, 1.0, 3.78252101622096E-16}, {21.0, 2.00551638598312E-17, 1.0, 2.11509999433041E-17}, {22.0, 1.04317070180562E-18, 1.0, 1.09583608347287E-18}, {23.0, 5.03153504903308E-20, 1.0, 5.266538166725E-20}, {24.0, 2.2525984149695E-21, 1.0, 2.35003117691919E-21}, {25.0, 9.3677424515947E-23, 1.0, 9.74327619496943E-23}, {50.0, 9.83633962945521E-69, 1.0, 9.8677629437617E-69}, {51.0, 3.13448949497553E-71, 1.0, 3.14233143064882E-71}, {52.0, 7.82755221928122E-74, 1.0, 7.84193567329055E-74}, {53.0, 1.43662126065532E-76, 1.0, 1.43834540093295E-76}, {54.0, 1.72312692517348E-79, 1.0, 1.7241402776278E-79}, {55.0, 1.01335245432581E-82, 1.0, 1.01335245432581E-82}};
        this.testHypergeometricDistributionProbabilities(populationSize, sampleSize, numberOfSucceses, data);
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        HypergeometricDistribution dist = new HypergeometricDistribution(1500, 40, 100);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)2.6666666666666665, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)2.424134608257357, (double)1.0E-9);
        dist = new HypergeometricDistribution(3000, 55, 200);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)3.6666666666666665, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)3.3606016820421623, (double)1.0E-9);
    }

    @Test
    public void testMath644() {
        int N = 14761461;
        int m = 1035;
        int n = 1841;
        HypergeometricDistribution dist = new HypergeometricDistribution(N, m, n);
        int k = 0;
        Assert.assertTrue((Precision.compareTo((double)1.0, (double)dist.upperCumulativeProbability(k), (int)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Precision.compareTo((double)dist.cumulativeProbability(k), (double)0.0, (int)1) > 0 ? 1 : 0) != 0);
        double upper = 1.0 - dist.cumulativeProbability(k) + dist.probability(k);
        Assert.assertTrue((Precision.compareTo((double)1.0, (double)upper, (int)1) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMath1021() {
        int N = 43130568;
        int m = 42976365;
        int n = 50;
        HypergeometricDistribution dist = new HypergeometricDistribution(43130568, 42976365, 50);
        for (int i = 0; i < 100; ++i) {
            int sample = dist.sample();
            Assert.assertTrue((String)("sample=" + sample), (0 <= sample ? 1 : 0) != 0);
            Assert.assertTrue((String)("sample=" + sample), (sample <= 50 ? 1 : 0) != 0);
        }
    }
}

