/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.swing.ui;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.axis2.tool.service.bean.Page2Bean;
import org.apache.axis2.tool.service.bean.WizardBean;
import org.apache.axis2.tool.service.control.Controller;
import org.apache.axis2.tool.service.control.ProcessException;
import org.apache.axis2.tool.service.swing.ui.WizardPane;

public class WizardPane2
extends WizardPane {
    private WizardBean parentBean;
    private Page2Bean myBean;
    private JRadioButton selectManualFileRadioButton;
    private JRadioButton createAutomaticFileRadioButton;
    private JPanel selectionPanel;

    public WizardPane2(WizardBean wizardBean, JFrame ownerFrame) {
        super(ownerFrame);
        this.init();
        this.parentBean = wizardBean;
        if (wizardBean.getPage2bean() != null) {
            this.myBean = wizardBean.getPage2bean();
            this.setBeanValues();
        } else {
            this.myBean = new Page2Bean();
            wizardBean.setPage2bean(this.myBean);
            this.setDefaultValues();
        }
    }

    public void setBeanValues() {
        if (this.myBean.isManual()) {
            this.selectManualFileRadioButton.setSelected(true);
            this.loadScreen(new ManualSelectionPanel(true));
        } else {
            this.createAutomaticFileRadioButton.setSelected(true);
            this.loadScreen(new AutomaticSelectionPanel(true));
        }
    }

    @Override
    public boolean validateValues() {
        String text = "";
        String text2 = "";
        boolean returnValue = false;
        if (this.myBean.isManual()) {
            text = this.myBean.getManualFileName();
            returnValue = text != null && text.trim().length() > 0;
        } else {
            text = this.myBean.getAutomaticClassName();
            text2 = this.myBean.getProviderClassName();
            returnValue = text != null && text.trim().length() > 0 && text2 != null && text2.trim().length() > 0;
        }
        return returnValue;
    }

    private void init() {
        this.setLayout(null);
        this.setSize(this.width, this.height);
        this.initDescription("\n Select either the service xml file or the class that you want to \n  expose as the service to auto generate a service.xml. \n  Only the class files that are in the previously selected location can\n be laded from here");
        ButtonGroup group = new ButtonGroup();
        this.selectManualFileRadioButton = new JRadioButton("Select a file manually");
        this.selectManualFileRadioButton.setBounds(this.hgap, this.descHeight, 200, 20);
        this.add(this.selectManualFileRadioButton);
        group.add(this.selectManualFileRadioButton);
        this.selectManualFileRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane2.this.changeSelectionScreen();
            }
        });
        this.createAutomaticFileRadioButton = new JRadioButton("Create a file automatically");
        this.createAutomaticFileRadioButton.setBounds(this.hgap, this.descHeight + this.vgap + 20, 200, 20);
        this.add(this.createAutomaticFileRadioButton);
        group.add(this.createAutomaticFileRadioButton);
        this.createAutomaticFileRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane2.this.changeSelectionScreen();
            }
        });
        this.selectionPanel = new JPanel();
        this.selectionPanel.setLayout(null);
        this.selectionPanel.setBounds(0, this.descHeight + 40 + 2 * this.vgap, this.width, 100);
        this.add(this.selectionPanel);
    }

    private void setDefaultValues() {
        this.selectManualFileRadioButton.setSelected(true);
        this.loadScreen(new ManualSelectionPanel());
        this.updateBeanFlags(true);
    }

    private void changeSelectionScreen() {
        if (this.selectManualFileRadioButton.isSelected()) {
            this.loadScreen(new ManualSelectionPanel(true));
            this.updateBeanFlags(true);
        } else {
            this.loadScreen(new AutomaticSelectionPanel(true));
            this.updateBeanFlags(false);
        }
    }

    private void updateBeanFlags(boolean flag) {
        this.myBean.setManual(flag);
        this.myBean.setAutomatic(!flag);
    }

    private void loadScreen(JPanel panel) {
        this.selectionPanel.removeAll();
        this.selectionPanel.add(panel);
        this.repaint();
    }

    private class AdvancedSelectionDialog
    extends JDialog {
        private JPanel lablePanel;
        private JButton okButton;
        private JButton cancelButton;
        private boolean[] selectedValues;
        private ArrayList completeMethodList;

        public AdvancedSelectionDialog() throws HeadlessException, ProcessException {
            super.setModal(true);
            super.setTitle("Select Methods");
            this.getContentPane().setLayout(null);
            this.init();
        }

        private void init() throws ProcessException {
            this.completeMethodList = new Controller().getMethodList(WizardPane2.this.parentBean);
            int methodCount = this.completeMethodList.size();
            int panelHeight = methodCount * (20 + WizardPane2.this.vgap);
            this.lablePanel = new JPanel();
            this.lablePanel.setLayout(null);
            this.lablePanel.setBounds(0, 0, WizardPane2.this.width, panelHeight);
            this.getContentPane().add(this.lablePanel);
            ArrayList currentSelectedList = WizardPane2.this.myBean.getSelectedMethodNames();
            this.selectedValues = new boolean[methodCount];
            for (int i = 0; i < methodCount; ++i) {
                JCheckBox tempCheckBox = new JCheckBox(this.completeMethodList.get(i).toString());
                boolean currentSelection = currentSelectedList.contains(this.completeMethodList.get(i));
                tempCheckBox.setSelected(currentSelection);
                this.selectedValues[i] = currentSelection;
                tempCheckBox.setBounds(WizardPane2.this.hgap, WizardPane2.this.vgap + (20 + WizardPane2.this.vgap) * i, 300, 20);
                tempCheckBox.addActionListener(new CheckBoxActionListner(tempCheckBox, i));
                this.lablePanel.add(tempCheckBox);
            }
            this.okButton = new JButton("OK");
            this.getContentPane().add(this.okButton);
            this.okButton.setBounds(WizardPane2.this.hgap, panelHeight + WizardPane2.this.vgap, 80, 20);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdvancedSelectionDialog.this.loadValuesToBean();
                    AdvancedSelectionDialog.this.closeMe();
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.getContentPane().add(this.cancelButton);
            this.cancelButton.setBounds(WizardPane2.this.hgap * 2 + 80, panelHeight + WizardPane2.this.vgap, 80, 20);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdvancedSelectionDialog.this.closeMe();
                }
            });
            this.setSize(WizardPane2.this.width, panelHeight + 40 + 30);
            this.setResizable(false);
        }

        private void updateSelection(JCheckBox checkBox, int index) {
            this.selectedValues[index] = checkBox.isSelected();
        }

        private void loadValuesToBean() {
            ArrayList modifiedMethodList = new ArrayList();
            for (int i = 0; i < this.selectedValues.length; ++i) {
                if (!this.selectedValues[i]) continue;
                modifiedMethodList.add(this.completeMethodList.get(i));
            }
            WizardPane2.this.myBean.setSelectedMethodNames(modifiedMethodList);
        }

        private void closeMe() {
            this.dispose();
        }

        private class CheckBoxActionListner
        implements ActionListener {
            private JCheckBox checkBox;
            private int index;

            public CheckBoxActionListner(JCheckBox checkBox, int index) {
                this.index = index;
                this.checkBox = checkBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSelectionDialog.this.updateSelection(this.checkBox, this.index);
            }
        }
    }

    private class AutomaticSelectionPanel
    extends JPanel {
        private JLabel classFileListLable;
        private JLabel providerClassLable;
        private JTextField classFileNameTextBox;
        private JTextField providerClassNameTextBox;
        private JButton loadButton;
        private JButton advancedButton;

        public AutomaticSelectionPanel() {
            this.init();
        }

        public AutomaticSelectionPanel(boolean loadVals) {
            this.init();
            if (loadVals) {
                this.classFileNameTextBox.setText(WizardPane2.this.myBean.getAutomaticClassName());
                this.providerClassNameTextBox.setText(WizardPane2.this.myBean.getProviderClassName());
            }
        }

        private void init() {
            this.setLayout(null);
            this.setSize(WizardPane2.this.width, 100);
            this.classFileListLable = new JLabel("Class Name");
            this.add(this.classFileListLable);
            this.classFileListLable.setBounds(WizardPane2.this.hgap, WizardPane2.this.vgap, 100, 20);
            this.classFileNameTextBox = new JTextField();
            this.add(this.classFileNameTextBox);
            this.classFileNameTextBox.setBounds(100 + 2 * WizardPane2.this.hgap, WizardPane2.this.vgap, 250, 20);
            this.classFileNameTextBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutomaticSelectionPanel.this.setClassName();
                }
            });
            this.classFileNameTextBox.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    AutomaticSelectionPanel.this.setClassName();
                }
            });
            this.providerClassLable = new JLabel("Provider Class Name");
            this.add(this.providerClassLable);
            this.providerClassLable.setBounds(WizardPane2.this.hgap, 20 + WizardPane2.this.vgap, 100, 20);
            this.providerClassNameTextBox = new JTextField();
            this.add(this.providerClassNameTextBox);
            this.providerClassNameTextBox.setBounds(100 + 2 * WizardPane2.this.hgap, 20 + WizardPane2.this.vgap * 2, 250, 20);
            this.providerClassNameTextBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutomaticSelectionPanel.this.setProviderClassName();
                }
            });
            this.providerClassNameTextBox.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    AutomaticSelectionPanel.this.setProviderClassName();
                }
            });
            this.loadButton = new JButton("Load");
            this.add(this.loadButton);
            this.loadButton.setBounds(WizardPane2.this.hgap, (20 + WizardPane2.this.vgap) * 2 + WizardPane2.this.vgap, 80, 20);
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutomaticSelectionPanel.this.loadAllMethods();
                }
            });
            this.loadButton.setEnabled(false);
            this.advancedButton = new JButton("Advanced");
            this.add(this.advancedButton);
            this.advancedButton.setBounds(2 * WizardPane2.this.hgap + 80, (20 + WizardPane2.this.vgap) * 2 + WizardPane2.this.vgap, 80, 20);
            this.advancedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutomaticSelectionPanel.this.openDialog();
                }
            });
            this.advancedButton.setEnabled(false);
        }

        private void loadAllMethods() {
            try {
                ArrayList methodList = new Controller().getMethodList(WizardPane2.this.parentBean);
                WizardPane2.this.myBean.setSelectedMethodNames(methodList);
                this.loadButton.setEnabled(false);
                this.advancedButton.setEnabled(true);
            }
            catch (ProcessException e) {
                WizardPane2.this.showErrorMessage(e.getMessage());
            }
        }

        private void openDialog() {
            try {
                new AdvancedSelectionDialog().show();
            }
            catch (ProcessException e) {
                WizardPane2.this.showErrorMessage(e.getMessage());
            }
        }

        private void setClassName() {
            this.loadButton.setEnabled(true);
            this.advancedButton.setEnabled(false);
            WizardPane2.this.myBean.setAutomaticClassName(this.classFileNameTextBox.getText());
        }

        private void setProviderClassName() {
            WizardPane2.this.myBean.setProviderClassName(this.providerClassNameTextBox.getText());
        }
    }

    private class ManualSelectionPanel
    extends JPanel {
        private JLabel serverXMLFileLocationLabel;
        private JTextField serverXMLFileLocationTextBox;
        private JButton browseButton;

        public ManualSelectionPanel() {
            this.init();
        }

        public ManualSelectionPanel(boolean loadVals) {
            this.init();
            if (loadVals) {
                this.serverXMLFileLocationTextBox.setText(WizardPane2.this.myBean.getManualFileName());
            }
        }

        private void init() {
            this.setLayout(null);
            this.setSize(WizardPane2.this.width, 100);
            this.serverXMLFileLocationLabel = new JLabel("Service File");
            this.add(this.serverXMLFileLocationLabel);
            this.serverXMLFileLocationLabel.setBounds(WizardPane2.this.hgap, WizardPane2.this.vgap, 100, 20);
            this.serverXMLFileLocationTextBox = new JTextField();
            this.add(this.serverXMLFileLocationTextBox);
            this.serverXMLFileLocationTextBox.setBounds(100 + 2 * WizardPane2.this.hgap, WizardPane2.this.vgap, 250, 20);
            this.serverXMLFileLocationTextBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManualSelectionPanel.this.setOutFileName();
                }
            });
            this.serverXMLFileLocationTextBox.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    ManualSelectionPanel.this.setOutFileName();
                }
            });
            this.browseButton = new JButton(".");
            this.add(this.browseButton);
            this.browseButton.setBounds(100 + 2 * WizardPane2.this.hgap + 250, WizardPane2.this.vgap, 20, 20);
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManualSelectionPanel.this.serverXMLFileLocationTextBox.setText(WizardPane2.this.browseForAFile("xml"));
                    ManualSelectionPanel.this.setOutFileName();
                }
            });
        }

        private void setOutFileName() {
            WizardPane2.this.myBean.setManualFileName(this.serverXMLFileLocationTextBox.getText());
        }
    }
}

