/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.intf;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.intf.AxiomSOAPBody;
import org.apache.axiom.soap.impl.intf.AxiomSOAPEnvelope;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFault;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultCode;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultDetail;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultReason;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultRole;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeader;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;

public abstract class SOAPHelper {
    private final SOAPVersion version;
    private final OMNamespace namespace;
    private final String specName;
    private final Class<? extends AxiomSOAPEnvelope> envelopeClass;
    private final Class<? extends AxiomSOAPHeader> headerClass;
    private final QName headerQName;
    private final Class<? extends AxiomSOAPHeaderBlock> headerBlockClass;
    private final Class<? extends AxiomSOAPBody> bodyClass;
    private final QName bodyQName;
    private final Class<? extends AxiomSOAPFault> faultClass;
    private final QName faultQName;
    private final Class<? extends AxiomSOAPFaultCode> faultCodeClass;
    private final Class<? extends AxiomSOAPFaultReason> faultReasonClass;
    private final Class<? extends AxiomSOAPFaultRole> faultRoleClass;
    private final Class<? extends AxiomSOAPFaultDetail> faultDetailClass;
    private final QName mustUnderstandAttributeQName;
    private final QName roleAttributeQName;
    private final QName relayAttributeQName;

    protected SOAPHelper(SOAPVersion version, String specName, Class<? extends AxiomSOAPEnvelope> envelopeClass, Class<? extends AxiomSOAPHeader> headerClass, Class<? extends AxiomSOAPHeaderBlock> headerBlockClass, Class<? extends AxiomSOAPBody> bodyClass, Class<? extends AxiomSOAPFault> faultClass, Class<? extends AxiomSOAPFaultCode> faultCodeClass, Class<? extends AxiomSOAPFaultReason> faultReasonClass, Class<? extends AxiomSOAPFaultRole> faultRoleClass, Class<? extends AxiomSOAPFaultDetail> faultDetailClass, String roleAttributeLocalName, String relayAttributeLocalName) {
        this.version = version;
        this.namespace = new OMNamespaceImpl(version.getEnvelopeURI(), "soapenv");
        this.specName = specName;
        this.envelopeClass = envelopeClass;
        this.headerClass = headerClass;
        this.headerQName = new QName(version.getEnvelopeURI(), "Header", "soapenv");
        this.headerBlockClass = headerBlockClass;
        this.bodyClass = bodyClass;
        this.bodyQName = new QName(version.getEnvelopeURI(), "Body", "soapenv");
        this.faultClass = faultClass;
        this.faultQName = new QName(version.getEnvelopeURI(), "Fault", "soapenv");
        this.faultCodeClass = faultCodeClass;
        this.faultReasonClass = faultReasonClass;
        this.faultRoleClass = faultRoleClass;
        this.faultDetailClass = faultDetailClass;
        this.mustUnderstandAttributeQName = new QName(version.getEnvelopeURI(), "mustUnderstand", "soapenv");
        this.roleAttributeQName = new QName(version.getEnvelopeURI(), roleAttributeLocalName, "soapenv");
        this.relayAttributeQName = relayAttributeLocalName == null ? null : new QName(version.getEnvelopeURI(), relayAttributeLocalName, "soapenv");
    }

    public final SOAPVersion getVersion() {
        return this.version;
    }

    public abstract SOAPFactory getSOAPFactory(OMMetaFactory var1);

    public final String getEnvelopeURI() {
        return this.version.getEnvelopeURI();
    }

    public final OMNamespace getNamespace() {
        return this.namespace;
    }

    public final String getSpecName() {
        return this.specName;
    }

    public final Class<? extends AxiomSOAPEnvelope> getEnvelopeClass() {
        return this.envelopeClass;
    }

    public final Class<? extends AxiomSOAPHeader> getHeaderClass() {
        return this.headerClass;
    }

    public final QName getHeaderQName() {
        return this.headerQName;
    }

    public final Class<? extends AxiomSOAPHeaderBlock> getHeaderBlockClass() {
        return this.headerBlockClass;
    }

    public final Class<? extends AxiomSOAPBody> getBodyClass() {
        return this.bodyClass;
    }

    public final QName getBodyQName() {
        return this.bodyQName;
    }

    public final Class<? extends AxiomSOAPFault> getFaultClass() {
        return this.faultClass;
    }

    public final QName getFaultQName() {
        return this.faultQName;
    }

    public final Class<? extends AxiomSOAPFaultCode> getFaultCodeClass() {
        return this.faultCodeClass;
    }

    public final QName getFaultCodeQName() {
        return this.version.getFaultCodeQName();
    }

    public final Class<? extends AxiomSOAPFaultReason> getFaultReasonClass() {
        return this.faultReasonClass;
    }

    public final QName getFaultReasonQName() {
        return this.version.getFaultReasonQName();
    }

    public final Class<? extends AxiomSOAPFaultRole> getFaultRoleClass() {
        return this.faultRoleClass;
    }

    public final QName getFaultRoleQName() {
        return this.version.getFaultRoleQName();
    }

    public final Class<? extends AxiomSOAPFaultDetail> getFaultDetailClass() {
        return this.faultDetailClass;
    }

    public final QName getFaultDetailQName() {
        return this.version.getFaultDetailQName();
    }

    public final QName getMustUnderstandAttributeQName() {
        return this.mustUnderstandAttributeQName;
    }

    public final QName getRoleAttributeQName() {
        return this.roleAttributeQName;
    }

    public final QName getRelayAttributeQName() {
        return this.relayAttributeQName;
    }

    public abstract Boolean parseBoolean(String var1);

    public abstract String formatBoolean(boolean var1);
}

