/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverterTransformer
extends Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(TypeConverterTransformer.class);
    private DataType dataType;
    private Class<?> type;

    public TypeConverterTransformer(DataType type) {
        super(type.getFullName());
        this.dataType = type;
    }

    public TypeConverterTransformer(Class<?> type) {
        super("java:" + type.getName());
        this.type = type;
    }

    public void transform(Message message, DataType from, DataType to) {
        if (message == null || message.getBody() == null) {
            return;
        }
        try {
            if (this.dataType != null && DataType.isJavaType((DataType)this.dataType) && this.dataType.getName() != null) {
                CamelContext context = message.getExchange().getContext();
                this.type = context.getClassResolver().resolveMandatoryClass(this.dataType.getName());
            }
            if (this.type != null && !this.type.isAssignableFrom(message.getBody().getClass())) {
                LOG.debug("Converting to '{}'", (Object)this.type.getName());
                message.setBody(message.getMandatoryBody(this.type));
            }
        }
        catch (ClassNotFoundException | InvalidPayloadException e) {
            throw new CamelExecutionException(String.format("Failed to convert body to '%s' content using type conversion for %s", this.getName(), ObjectHelper.name(this.type)), message.getExchange(), e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }
}

