/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz;

import java.util.Collection;
import java.util.List;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.authz.permission.PermissionResolverAware;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.authz.permission.RolePermissionResolverAware;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;

public class ModularRealmAuthorizer
implements Authorizer,
PermissionResolverAware,
RolePermissionResolverAware {
    protected Collection<Realm> realms;
    protected PermissionResolver permissionResolver;
    protected RolePermissionResolver rolePermissionResolver;

    public ModularRealmAuthorizer() {
    }

    public ModularRealmAuthorizer(Collection<Realm> realms) {
        this.setRealms(realms);
    }

    public Collection<Realm> getRealms() {
        return this.realms;
    }

    public void setRealms(Collection<Realm> realms) {
        this.realms = realms;
        this.applyPermissionResolverToRealms();
        this.applyRolePermissionResolverToRealms();
    }

    public PermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    @Override
    public void setPermissionResolver(PermissionResolver permissionResolver) {
        this.permissionResolver = permissionResolver;
        this.applyPermissionResolverToRealms();
    }

    protected void applyPermissionResolverToRealms() {
        PermissionResolver resolver = this.getPermissionResolver();
        Collection<Realm> realms = this.getRealms();
        if (resolver != null && realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof PermissionResolverAware)) continue;
                ((PermissionResolverAware)((Object)realm)).setPermissionResolver(resolver);
            }
        }
    }

    public RolePermissionResolver getRolePermissionResolver() {
        return this.rolePermissionResolver;
    }

    @Override
    public void setRolePermissionResolver(RolePermissionResolver rolePermissionResolver) {
        this.rolePermissionResolver = rolePermissionResolver;
        this.applyRolePermissionResolverToRealms();
    }

    protected void applyRolePermissionResolverToRealms() {
        RolePermissionResolver resolver = this.getRolePermissionResolver();
        Collection<Realm> realms = this.getRealms();
        if (resolver != null && realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof RolePermissionResolverAware)) continue;
                ((RolePermissionResolverAware)((Object)realm)).setRolePermissionResolver(resolver);
            }
        }
    }

    protected void assertRealmsConfigured() throws IllegalStateException {
        Collection<Realm> realms = this.getRealms();
        if (realms == null || realms.isEmpty()) {
            String msg = "Configuration error:  No realms have been configured!  One or more realms must be present to execute an authorization operation.";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, String permission) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || !((Authorizer)((Object)realm)).isPermitted(principals, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || !((Authorizer)((Object)realm)).isPermitted(principals, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principals, String ... permissions) {
        this.assertRealmsConfigured();
        if (permissions != null && permissions.length > 0) {
            boolean[] isPermitted = new boolean[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                isPermitted[i] = this.isPermitted(principals, permissions[i]);
            }
            return isPermitted;
        }
        return new boolean[0];
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principals, List<Permission> permissions) {
        this.assertRealmsConfigured();
        if (permissions != null && !permissions.isEmpty()) {
            boolean[] isPermitted = new boolean[permissions.size()];
            int i = 0;
            for (Permission p : permissions) {
                isPermitted[i++] = this.isPermitted(principals, p);
            }
            return isPermitted;
        }
        return new boolean[0];
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection principals, String ... permissions) {
        this.assertRealmsConfigured();
        if (permissions != null && permissions.length > 0) {
            for (String perm : permissions) {
                if (this.isPermitted(principals, perm)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection principals, Collection<Permission> permissions) {
        this.assertRealmsConfigured();
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                if (this.isPermitted(principals, permission)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void checkPermission(PrincipalCollection principals, String permission) throws AuthorizationException {
        this.assertRealmsConfigured();
        if (!this.isPermitted(principals, permission)) {
            throw new UnauthorizedException("Subject does not have permission [" + permission + "]");
        }
    }

    @Override
    public void checkPermission(PrincipalCollection principals, Permission permission) throws AuthorizationException {
        this.assertRealmsConfigured();
        if (!this.isPermitted(principals, permission)) {
            throw new UnauthorizedException("Subject does not have permission [" + permission + "]");
        }
    }

    @Override
    public void checkPermissions(PrincipalCollection principals, String ... permissions) throws AuthorizationException {
        this.assertRealmsConfigured();
        if (permissions != null && permissions.length > 0) {
            for (String perm : permissions) {
                this.checkPermission(principals, perm);
            }
        }
    }

    @Override
    public void checkPermissions(PrincipalCollection principals, Collection<Permission> permissions) throws AuthorizationException {
        this.assertRealmsConfigured();
        if (permissions != null) {
            for (Permission permission : permissions) {
                this.checkPermission(principals, permission);
            }
        }
    }

    @Override
    public boolean hasRole(PrincipalCollection principals, String roleIdentifier) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!(realm instanceof Authorizer) || !((Authorizer)((Object)realm)).hasRole(principals, roleIdentifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] hasRoles(PrincipalCollection principals, List<String> roleIdentifiers) {
        this.assertRealmsConfigured();
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            boolean[] hasRoles = new boolean[roleIdentifiers.size()];
            int i = 0;
            for (String roleId : roleIdentifiers) {
                hasRoles[i++] = this.hasRole(principals, roleId);
            }
            return hasRoles;
        }
        return new boolean[0];
    }

    @Override
    public boolean hasAllRoles(PrincipalCollection principals, Collection<String> roleIdentifiers) {
        this.assertRealmsConfigured();
        for (String roleIdentifier : roleIdentifiers) {
            if (this.hasRole(principals, roleIdentifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkRole(PrincipalCollection principals, String role) throws AuthorizationException {
        this.assertRealmsConfigured();
        if (!this.hasRole(principals, role)) {
            throw new UnauthorizedException("Subject does not have role [" + role + "]");
        }
    }

    @Override
    public void checkRoles(PrincipalCollection principals, Collection<String> roles) throws AuthorizationException {
        if (roles != null && !roles.isEmpty()) {
            this.checkRoles(principals, roles.toArray(new String[roles.size()]));
        }
    }

    @Override
    public void checkRoles(PrincipalCollection principals, String ... roles) throws AuthorizationException {
        this.assertRealmsConfigured();
        if (roles != null) {
            for (String role : roles) {
                this.checkRole(principals, role);
            }
        }
    }
}

