/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: JettyTransport.java,v $
  Version:       $Name:  $ $Revision: 1.20 $
  Last Modified: $Date: 2003/12/17 16:00:38 $
 *****************************************************************************/
package org.ten60.transport.jetty;

import com.ten60.netkernel.transport.*;
import com.ten60.netkernel.container.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;

import org.ten60.netkernel.layer1.representation.*;

import org.mortbay.http.*;
import org.mortbay.http.handler.*;
import org.mortbay.xml.XmlConfiguration;

import org.w3c.dom.*;
import java.net.*;
import java.io.*;
import java.util.*;

/**
 * HTTP Transport implemented with the help of Jetty
 * @author  pjr
 */
public class JettyTransport	implements ITransport
{
	public static final String TRANSPORT_ATTR = "transport";
	private ArrayList mHttpServers;
	private String mExceptionHandler;
	private IRequestorContext mContext;
	private TransportManager mManager;
	private String mDescription;
	
	/*
	 * Still need to add SSL servers
	 */
	private void addServers(Container aContainer, IRequestorContext aContext) throws NetKernelException
	{	mContext = aContext;
		StringBuffer sb = new StringBuffer(128);
		try
		{
			URL config =((ModuleDefinition)aContext).getResource("/etc/TransportJettyConfig.xml");
			if (config==null)
			{	throw new NetKernelException("configuration file not found");
			}
			Reader r = new InputStreamReader(config.openStream());
			Document d = XMLUtils.getInstance().parse(r);
			XMLReadable readable = new XMLReadable(d);
			List configs = readable.getNodes("/httpConfig/Configure");
			for (Iterator i = configs.iterator(); i.hasNext(); )
			{	Node n = (Node)i.next();
				String configString = XMLUtils.getInstance().toXML(n, false, true);
				org.mortbay.xml.XmlConfiguration xmlconfig=new org.mortbay.xml.XmlConfiguration(configString);
				HttpServer server=(HttpServer)xmlconfig.newInstance();
				HttpContext[] contexts = server.getContexts();
				for (int j=0; j<contexts.length; j++)
				{	contexts[j].setAttribute(TRANSPORT_ATTR,this);
				}
				mHttpServers.add(server);
				try
				{	server.start();
					HttpListener listener1 = (server.getListeners()[0]);
					HttpContext ctx = (server.getContexts()[0]);
					org.mortbay.http.HttpHandler handler = ctx.getHandlers()[0];
					sb.append(handler.getName());
					sb.append(" HTTP server on port ");
					sb.append(listener1.getPort());
					if (i.hasNext())
					{	sb.append(", ");
					}
				}
				catch (org.mortbay.util.MultiException e)
				{	HttpListener listener1 = (server.getListeners()[0]);
					NetKernelException e2 = new NetKernelException("Jetty Server failed to start","on port "+listener1.getPort(),null);
					for (Iterator j = e.getExceptions().iterator(); j.hasNext(); )
					{	Exception e3 = (Exception)j.next();
						e2.addCause(e3);
						throw e2;
					}
				}
			}
		}
		catch (Exception e)
		{	NetKernelException e2 = new NetKernelException("Failed to start Jetty Transport");
			e2.addCause(e);
			throw e2;
		}
		finally
		{	mDescription = new String(sb);
		}
	}
	
	/** Starts the object for the first time.      */
	public void start(Container aContainer, IRequestorContext aContext) throws NetKernelException
	{	mManager = (TransportManager)aContainer.getComponent(TransportManager.URI);
		mHttpServers=new ArrayList(1);
		addServers(aContainer,aContext);
	}
	
	/** Finally stops the object. Doesn't wait for it to stop.  */
	public void stop() throws NetKernelException
	{
		try
		{
			Iterator it=mHttpServers.iterator();
			while(it.hasNext()){
				HttpServer server=(HttpServer)it.next();
				server.stop();
			}
		}
		catch(Exception e){
			NetKernelException e2 = new NetKernelException("Failed to stop Jetty Transport");
			e2.addCause(e);
			throw e2;
		}
		finally
		{	mContext=null;
			mManager=null;
		}
	}
	
	public TransportManager getTransportManager()
	{	return mManager;
	}
	
	public IRequestorContext getContext()
	{	return mContext;
	}
	public void setContext(IRequestorContext aContext)
	{	mContext = aContext;
	}
	
	IURRepresentation handleRequest(String aRequestURI, IURRepresentation aParam, String aClientId, String aTransportId, boolean param)
	{
		IRequestorSession session = new TransportInitiatedSession(aTransportId,aClientId);
		URIdentifier paramURI=null;
		if (aParam!=null)
		{	paramURI = URIdentifier.getUnique("literal:param");
			String suffix = param?"+param@":"+param@";
			aRequestURI+=suffix+paramURI.toString();
		}
		URRequest request = new URRequest(new URIdentifier(aRequestURI),mManager,session, mContext, URRequest.RQT_SOURCE, null, null, IAspectBinaryStream.class);
		if (aParam!=null)
		{	request.addArg(paramURI,aParam);
		}
		return mManager.handleRequest(request,this);
	}
	
	public String getDescription()
	{	return mDescription;
	}
	
}
