/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: HeaderToXMLTransreptor.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2003/11/05 14:08:58 $
 *****************************************************************************/
package org.ten60.transport.http.request.transrepresentation;

import org.ten60.transport.http.request.representation.*;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urii.representation.*;
import com.ten60.netkernel.urii.aspect.*;

import java.util.*;

/**
 * transrepresents a HTTPHeader into XML
 * @author  pjr
 */
public class HeaderToXMLTransreptor extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectRequestHeader.class) && ( aTo.isAssignableFrom(IXAspect.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	IAspectRequestHeader header=(IAspectRequestHeader)aFrom.getAspect(IAspectRequestHeader.class);
		DOMXDA dx=new DOMXDA(org.ten60.netkernel.xml.util.XMLUtils.newDocument(),false);
		try
		{	dx.appendPath("/", "httpHeader", null);
			dx.appendPath("/httpHeader", "remoteHost", header.getRemoteHost());
			dx.appendPath("/httpHeader", "remoteAddr", header.getRemoteAddr());
			dx.appendPath("/httpHeader", "requestURL", header.getRequestURL());
			dx.appendPath("/httpHeader", "requestQuery", header.getRequestQuery());
			Enumeration names=header.getHeaderNames();
			while(names.hasMoreElements())
			{	String name=(String)names.nextElement();
				Enumeration values=header.getValues(name);
				while(values.hasMoreElements())
				{	String value=(String)values.nextElement();
					dx.appendPath("/httpHeader", "field",null);
					dx.appendPath("/httpHeader/field[position()=last()]", "name", org.ten60.netkernel.xml.util.XMLUtils.escape(name));
					dx.appendPath("/httpHeader/field[position()=last()]", "value", org.ten60.netkernel.xml.util.XMLUtils.escape(value));
				}
			}
			
			DependencyMeta dm=new DependencyMeta(aFrom, 8);
			dm.setMimeType("text/xml");
		
			return DOMXDAAspect.create(dm,dx);
		}
		catch (Exception e)
		{	NetKernelException nke=new NetKernelException("Error in HeaderToXMLTransmutor");
			nke.addCause(e);
			throw nke;
		}
	}
	
}
