/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XMLToCookieTransrepresentor.java,v $
 * Version:       $Name:  $ $Revision: 1.7 $
 * Last Modified: $Date: 2003/11/05 14:08:58 $
 *****************************************************************************/
package org.ten60.transport.http.cookie.transrepresentation;

import org.ten60.transport.http.cookie.representation.*;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.representation.*;

import javax.servlet.http.Cookie;

/**
 *
 * @author  pjr
 */
public class XMLToCookieTransrepresentor extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectXDA.class) && ( aTo.isAssignableFrom(IAspectCookie.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	try
		{	IAspectXDA xdap=(IAspectXDA)aFrom.getAspect(IAspectXDA.class);
			IXDAReadOnly xda=xdap.getXDA();
		
			String name=xda.getText("/cookie/name", true);
			String value=xda.getText("/cookie/value",true);
			if(name==null) throw new Exception();
			Cookie c=new Cookie(name,value);
			if(xda.isTrue("/cookie/domain"))	c.setDomain(xda.getText("/cookie/domain",true));
			if(xda.isTrue("/cookie/path"))	c.setPath(xda.getText("/cookie/path",true));
			if(xda.isTrue("/cookie/maxage"))	c.setMaxAge(Integer.parseInt(xda.getText("/cookie/maxage",true)));
			if(xda.isTrue("/cookie/version"))	c.setVersion(Integer.parseInt(xda.getText("/cookie/version",true)));
			if(xda.isTrue("/cookie/comment"))	c.setComment(xda.getText("/cookie/comment",true));
			if(xda.isTrue("/cookie/secure"))
			{	String secure=xda.getText("/cookie/secure",true);
				if(secure.equals("true")) c.setSecure(true);
				else c.setSecure(false);
			}
			
			DependencyMeta dm=new DependencyMeta(aFrom, 4);
			dm.setMimeType(CookieAspect.MIME);
		
			return CookieAspect.create(dm,c);
		}
		catch (Exception e)
		{	NetKernelException nke=new NetKernelException("Error in CookieToXMLTransmutor");
			nke.addCause(e);
			throw nke;
		}
	}
	
}
