/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XMLStreamsicle.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2005/05/31 10:41:24 $
 *****************************************************************************/
package org.ten60.orchextra;

import com.ten60.netkernel.container.Container;
import com.streamsicle.*;
import com.streamsicle.fluid.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.text.DateFormat;
import java.net.URLEncoder;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;
import org.w3c.dom.*;

/**
 *
 * @author  pjr
 * @version
 */
public class XMLStreamsicle {
    
	private static XMLStreamsicle singleton;
	
    private Server server;
    private InteractiveStream stream;
    private java.util.Date starttime;
    private boolean isstarted=false;
    
    /** Creates new XMLStreamsicle */
    public XMLStreamsicle()
	{
    }
    	
	/**
     * @return the one and only instance of the XMLStreamsicle server
     */
    public final static XMLStreamsicle getInstance()
    {   return singleton;
    }
    
    public static void initialise()
	{
		if(singleton==null)
		{	try
			{	singleton=new XMLStreamsicle();
			}
			catch(Exception e)
			{	System.err.println("Failed to construct XMLStreamsicle");
				e.printStackTrace();
			}
		}
	}
	
    public synchronized void config(Properties props, URI aRoot) throws OrchextraException {
        //Properties p=new Properties();
		try {
			//URI root=URI.create("file:/"+System.getProperty("dexter.basepath")+System.getProperty("dexter.xapppath"));
			URI root=aRoot;
			server = new Server(root, props);
			if(server==null) throw new OrchextraException("Problem Getting Streamsicle Server");
        }
        catch (Exception e) {
            throw new OrchextraException("Problem Getting Streamsicle Server");
        }   
    }
    
	public synchronized void reconfigureProperties(Properties props)
	{
		if(server!=null) server.reconfigureProperties(props);
	}
    
    public synchronized void start() throws OrchextraException {
        startserver();
        starttime=new java.util.Date();
        isstarted=true;
        
    }
    
    public synchronized void stop() throws OrchextraException{
		server.shutdown();
		stream=null;
        isstarted=false;
    }
    
    public boolean isStarted(){
        return isstarted;
    }
	
	public DOMXDA getPlaying() throws Exception{
		testStream();
        MP3File mp3=stream.getCurrent();
		DOMXDA s=new DOMXDA(XMLUtils.getInstance().newDocument());
		s.appendPath("/", "songlist", null);
		XMLFromMp3(mp3, s.iterator("/songlist"));
        return s;
        
    }
	
	public DOMXDA getQueueList() throws Exception
	{   testStream();
		Vector q=stream.getQueue();
        DOMXDA s=new DOMXDA(XMLUtils.getInstance().newDocument());
		s.appendPath("/", "queue", null);
		Enumeration queueElements = q.elements();
        QueueItem file = null;
        
        //this.getXMLList(q.iterator(), sb);
        while(queueElements.hasMoreElements()) {
            file = (QueueItem) queueElements.nextElement();
			DOMXDA t=new DOMXDA(XMLUtils.getInstance().newDocument());
			t.appendPath("/", "item",  null);
			IXDAIterator it=t.iterator("/item");
			XMLFromMp3(file.getMP3File(), it);
			it.appendPath(".", "owner", file.getOwner());
			it.appendPath(".", "parent", Integer.toString(file.getMP3File().getParent().getFileID()));
			s.append(t,"/","/queue");
        }
        return s;
    }
    
	public DOMXDA getHistory() throws Exception{
        testStream();
		IPlayHistory hist=stream.getPlayHistory();
        Vector v=hist.getPlayHistory();
        Iterator i=v.iterator();
        DOMXDA s=new DOMXDA(XMLUtils.getInstance().newDocument());
		s.appendPath("/", "history", null);
		IXDAIterator it=s.iterator("/history");
        getXMLList(i, it);
        return s;
    }
    
	public DOMXDA getList(int id) throws Exception{
        testStream();
		Vector v=stream.getList();
        if(id==0){
            id=stream.getRoot().getFileID();
        }
        MP3File root=stream.getMP3File(id);
        StringBuffer sb=new StringBuffer();
        
		DOMXDA s=new DOMXDA(XMLUtils.getInstance().newDocument());
		s.appendPath("/", "songlist", null);
		
        ArrayList parents=new ArrayList();
		parents.add(root);
		MP3File parent=root.getParent();
		MP3File previous=root;
		while(parent.getFileID()!=previous.getFileID())
		{	parents.add(parent);
			previous=parent;
			parent=parent.getParent();
		}
		for(int i=parents.size();i>0;i--)
		{	parent=(MP3File)parents.get(i-1);
			DOMXDA t=new DOMXDA(XMLUtils.getInstance().newDocument());
			t.appendPath("/", "parent", null);
			t.appendPath("/parent","id", Integer.toString(parent.getFileID()));
			t.appendPath("/parent","name", parent.getName());
			s.append(t,"/","/songlist");
		}        
        if(root.getFile().isDirectory()){  //Can only deal with directories
            Vector dirs=root.getDirectoryChildren();
            Vector songs=root.getMP3FileChildren();
            
            getXMLDIRList(dirs.iterator(), s.iterator("/songlist"));
            getXMLList(songs.iterator(), s.iterator("/songlist"));
        }
        return s;
    }
    
	public void getXMLDIRList(Iterator i, IXDAIterator it) throws Exception
	{	while(i.hasNext()){
            MP3File mp3=(MP3File)i.next();
			DOMXDA t=new DOMXDA(XMLUtils.getInstance().newDocument());
			t.appendPath("/", "dir", null);
			t.appendPath("/dir", "name", mp3.getName());
			t.appendPath("/dir", "id", Integer.toString(mp3.getFileID()));
            it.append(t, "/", ".");
        }
    }
	
	public void getXMLList(Iterator i,IXDAIterator it) throws Exception
	{   while(i.hasNext()){
            MP3File mp3=(MP3File)i.next();
			DOMXDA t=new DOMXDA(XMLUtils.getInstance().newDocument());
			t.appendPath("/", "item", null);
			IXDAIterator it2=t.iterator("/item");
			XMLFromMp3(mp3,it2);
			it.append(t,"/", ".");
        }
    }
	
    public synchronized void skip() throws OrchextraException{
        testStream();
        stream.skip();
    }
    
    public synchronized void jumpQueue(int id) throws OrchextraException{
		testStream();
        stream.toTopOfQueue(id);
    }
    
      public synchronized void jumpOne(int id) throws OrchextraException{
		testStream();
		stream.moveInQueue(id, 1);
    }
    
    public synchronized void removeFromQueue(int id) throws OrchextraException{
        testStream();
		stream.removeFromQueue(id);
    }
    
    public synchronized void setRandomRoot(int id) throws OrchextraException{
        testStream();
		stream.setRandomRoot(new Integer(id));
    }
    
    public  String getHostName() throws OrchextraException{
        testStream();
		return "<host><name>"+stream.getHostName()+"</name><port>"+stream.getPortNumber()+"</port></host>";
    }
    
    public String getCompleteHost() throws OrchextraException{  //Needed for launching client!
        testStream();
		return stream.getHostName()+":"+stream.getPortNumber();
    }
    
    public synchronized void addSong(int ID, String owner) throws OrchextraException{
        testStream();
		stream.addMedia(ID, owner, true);
    }
	
	private void testStream() throws OrchextraException
	{	if(stream==null) throw new OrchextraException("No stream");
	}
	
	private void XMLFromMp3(MP3File mp3, IXDAIterator it) throws Exception
	{   boolean isdir=mp3.getFile().isDirectory();
		if(isdir){
			it.appendPath(".", "dir", null);
			it=it.iterator("dir");
        }
		it.appendPath(".", "id", Integer.toString(mp3.getFileID()));
        it.appendPath(".", "artist", mp3.getArtist());
        it.appendPath(".", "album", mp3.getAlbum());
        it.appendPath(".", "name", mp3.getName());
    }
    
    
    public synchronized String getStatus(){
        StringBuffer sb=new StringBuffer();
        sb.append("<status>");
        if(server!=null && starttime!=null) sb.append("<server>OK</server>\n");
        else sb.append("<server>Not Started</server>\n");
        
        if(stream!=null && starttime!=null) sb.append("<stream>OK</stream>\n");
        else sb.append("<stream>Not Started</stream>\n");
        //sb.append("<threads>"+server.getThreads()+"</threads>");
        sb.append("<clients>"+server.getClients()+"</clients>");
        sb.append("<starttime>"+ (starttime==null ? "-" : DateFormat.getDateInstance().format(starttime) )+"</starttime>");
        sb.append("<tracks/>");
        sb.append("</status>");
        return sb.toString();
    }
    
    private synchronized  void startserver() throws OrchextraException {
        //server.startUp();
		try {
			server.initialize();
		} catch (StreamingEngineException e) {
			throw new OrchextraException("Problem starting server");
		}
		stream = server.getStream();
		isstarted=true;
		System.err.println("XMLStreamsicle: Confirming Server Started.");
    }
    
    public synchronized void reconfigure() throws OrchextraException{
		testStream();
        isstarted=false;
		try
		{	stream.configure();
			isstarted=true;
		}
		catch(StreamingEngineException e)
		{	throw new OrchextraException("Reconfiguration problem "+e.getMessage());
		}
    }
    
	public synchronized DOMXDA search(String subject) throws Exception
	{   testStream();
        Search s=new Search(".*?"+subject+".*?");
        Vector v=stream.getList();
        Vector hits=new Vector();
        StringBuffer sb=new StringBuffer();
        Iterator i=v.iterator();
        while(i.hasNext()){
            MP3File mp3=(MP3File)i.next();
            String name=mp3.getName();
            if (s.match(name)){
                hits.add(mp3);
            }
        }
        i=hits.iterator();
        //Sort into Directories and Songs
        Vector dirs=new Vector();
        Vector songs=new Vector();
        while(i.hasNext()){
            MP3File mp3=(MP3File)i.next();
            if(mp3.getFile().isDirectory()) dirs.add(mp3);
            else songs.add(mp3);
        }
        //Actually write some XML!
		DOMXDA sd=new DOMXDA(XMLUtils.getInstance().newDocument());
		sd.appendPath("/", "searchlist/search/term", subject);
		IXDAIterator it=sd.iterator("/searchlist");
		getXMLDIRList(dirs.iterator(), it);
        getXMLList(songs.iterator(),it);
        return sd;
    }
	
    /** escape the given string into a form safe to embed into an XML stream
     */
    public static String escape(String aXML)
    {   int length = aXML.length();
        StringBuffer result = new StringBuffer(length*2);
        for (int i=0; i<length; i++)
        {   char c = aXML.charAt(i);
            switch(c)
            {   case '<':
                    result.append("&lt;");
                    break;
                case '>':
                    result.append("&gt;");
                    break;
                case '\'':
                    result.append("&apos;");
                    break;
                case '"':
                    result.append("&quot;");
                    break;
                case '&':
                    result.append("&amp;");
                    break;
                default:
                    result.append(c);
                    break;
            }
        }
        return new String(result);
    }


}
