package com.streamsicle.fluid;

import java.io.*;
import org.ten60.orchextra.*;

public class Streamer implements Runnable, IMetaDataListener {
   private MediaInputStream in;
   private Server server;

   public Streamer (MediaInputStream in,
         Server server) {
      this.in = in;
      this.server = server;

      in.setMetaDataListener( this );
   }

   public void start () {
      new Thread(this, "Media Streamer").start();
   }

   public void run () {
      while (true) {
         server.setPacket(in.getPacket());
      }
   }

   public void setMetaData( byte[] metaData ) {
      // don't bother to maintain a listener list for now...
      OrchextraAccessor.log(OrchextraAccessor.FINE, this, "server.setMetaData()" );
      server.setMetaData( metaData );
   }
}
