package com.streamsicle.fluid;

import java.io.*;
import java.util.*;

import org.ten60.orchextra.*;

/**
 * This class reads a query from an input stream and extract
 * the information within.
 *
 * @author Lars Samuelsson
 * @author forked by John Watkinson
 */
public class ClientQuery {
    private byte[] query;
    private String queryHeader;
    private Hashtable properties;
    // Timer amount in minutes
    private int timer;

    /**
     * Reads a query from the given input stream and extracts
     * information.
     *
     * @param in The input stream to read the query from
     */
    public ClientQuery(InputStream in) throws IOException {
	   properties = new Hashtable();
	   queryHeader = null;
	   query = query(in);
	   propertize(query);
      timer = -1;
      doTimer();
    }

    /**
     * Retrieves a specific property from the query.
     *
     * A query property needs to have been read from
     * the input stream on the form name: value.
     *
     * @param name The name of the property to fetch
     *             (uses case insensitive matching)
     * @return     The value of the named property
     */
    public String getProperty(String name) {
	return (String)properties.get(name.toUpperCase());
    }

    /**
     * Returns the query header, ie the first line in the
     * query.
     *
     * @return the first line of the query
     */
    public String getQueryHeader() {
	return queryHeader;
    }

    /**
     * Gets the timer shutoff, or -1 if there is no shutoff
     * @return
     */
    public int getTimer () {
      return timer;
    }

    /**
     * Retrieves the whole query as a string.
     *
     * @return the query as a string
     */
    public String toString() {
	if(query == null)
	    return "";
	return new String(query);
    }

    // reads a query from the given inputstream
    private byte[] query(InputStream in) throws IOException {
       while( in.available() == 0 ) {
          // wait until the client makes a request
       }
       byte[] query = new byte[in.available()];
       in.read(query);
       return query;
    }

    // extracts information from the query
    private void propertize(byte[] query) {
	if(query == null) {
	    return;
        }

	String q = new String(query);
	StringTokenizer lines = new StringTokenizer(q, "\n");
	String line, key, value;
	if(lines.hasMoreTokens()) {
           queryHeader = lines.nextToken();
        }

        while(lines.hasMoreTokens()) {
           line = lines.nextToken();
           if(line.indexOf(":") > 0) {
              key = line.substring(0, line.indexOf(":"));
              value = line.substring(line.indexOf(":") + 1, line.length());
              properties.put(key.trim().toUpperCase(), value.trim());
           }
        }
    }

   private void doTimer () {
      int timeStart = queryHeader.indexOf("/timer/");
      if (timeStart != -1) {
         // Advance past the string
         timeStart += 7;
         int timeEnd = queryHeader.indexOf(' ', timeStart);
         String timeString = queryHeader.substring(timeStart, timeEnd);
         try {
            timer = Integer.parseInt(timeString);
         } catch (NumberFormatException e) {
            // Bad timer info
            OrchextraAccessor.log(OrchextraAccessor.WARNING, this, "Bad timer info passed: " + queryHeader);
         }
      }
   }
}
