package com.streamsicle;

import java.util.*;

/**
 * Interface for classes that provide play history functionality.  To
 * get a play history object, call getPlayHistory method on InteractiveStream.
 *
 * @see com.streamsicle.fluid.InteractiveStream#getPlayHistory()
 * @see MemoryPlayHistory
 */
public interface IPlayHistory {
   /**
    * Add a song to the play history.  Should be called after the song
    * is done playing.
    */
   public void addSong( MP3File song );

   /**
    * Returns the play history.  The implementation may only return the most
    * recent songs (the exact number is up to the implementation).  Most
    * recent songs will be first in the list.
    */
   public Vector getPlayHistory();

   /**
    * Returns the play history.  Will return a list with num entries, unless
    * the implementation does not have that many entries internally.
    */
   public Vector getPlayHistory( int num );


   /**
    * Clear the play history, duh.
    */
    public void clearPlayHistory();

   /**
    * Returns true if the implementation persists the play history.  If an
    * implementation persists the play history then it will be consistent
    * accross server shutdowns and restarts.
    */
   public boolean isPersistent();
}
