<?xml version="1.0" encoding="UTF-8" ?>

<!--<comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in compliance with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="html"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/">

<html>
	<head >
		<title>Bugxter Installer</title>
	</head>
	<body>
		<style type="text/css">
		<xsl:comment>
		body	    { background-color: #ffffff; font-family: Arial, Helvetica, sans-serif; font-size: 11px; margin-top:0px; }
		h1	    { margin-top: 8px; margin-bottom: 1px; color: #775D8A; font-family: Arial, sans-serif; font-size: 16px; font-weight: bold}
		h2	    { margin-top: 6px; margin-bottom: 1px; color: #775D8A; font-family: Arial, sans-serif; font-size: 14px; font-weight: bold }
		h3	    { margin-top: 4px; margin-bottom: 1px; color: #775D8A; font-family: Arial, sans-serif; font-size: 12px; font-weight: bold; font-style: italic;  }
		p	    { margin-top: 1px; padding-bottom: 4px; padding-top: 0px; font-family: Arial, sans-serif; font-size: 11px; }
		b	    { font-family: Arial, sans-serif; font-size: 11px; font-weight: bold; }
		hr	    { height: 1px }
		li	    { margin: 1px; padding: 1px; font-size: 11px;}
		pre	    { background-color: #eeeeff; }
		.inline	    { font-family: monospace; background-color: #eeeeff; }
		.warning    { font-family: monospace; background-color: #ffeeee; }
		td	    { font-family: Arial, Helvetica, sans-serif; font-size: 11px; vertical-align: top; }
		code        { font-family: monospace; background-color: #eeeeff; color: #006666; font-size: 11px;}
		.code        { font-family: monospace; background-color: #eeeeff; color: #006666; font-size: 11px; }
		a	    {text-decoration: none; color: #827556; letter-spacing: 0.05em;}
		a:visited   {text-decoration: none; color: #827556; letter-spacing: 0.05em;}
		a:hover	    {text-decoration:none; background-color: #938461; color: white;}

		textarea    {font-size: 10px;}
		input	    {font-size: 10px;}

		#new	    { color: #AA3333; text-decoration: blink; }
		#tiny	    { font-size: 9px; }
		#lesstiny   { font-size: 9px; }
		#tiny-title { font-weight: bold; font-size: 9px; }
		#goldtitle  { text-decoration: none; color: #827556; font-size: 11px;}
		#big-title  { font-weight: bold; font-size: 14px; }

		a.adv:link  {text-decoration: underline; color: #0000FF; letter-spacing: 0.00em;}
		a.adv:visited {text-decoration: underline; color: #0000FF; letter-spacing: 0.00em;}
		a.adv:hover {text-decoration: underline; background-color: #FFFFFF; color: #0000FF; letter-spacing: 0.00em;}
		</xsl:comment>
		</style>
		<table width="100%">
		<tr>
			<td colspan="2" style="border-bottom: 1px solid silver; padding-bottom: 5px;">
			<img src="mi+module@urn:org:ten60:app:bugxter:services+version@3.0.0" valign="middle"/>
			<div style="font-size: 75px;">
			Bugxter<span style="font-size:20px;">v3.0.x</span>
			</div>
			<span style="float: right; font-size: 25px; color: d1d1c0;">Installer</span>
			</td>
		</tr>
		</table>
		<h2>Readme - Installation Notes</h2>
		<p>
		<b>Before you begin.</b>  You must have a MySQL database v4 or higher.  You must also provide a MySQL JDBC driver jar file
		in the <code>&lt;install&gt;/modules/mod_db/lib/</code> directory.
		JDBC drivers can be downloaded from <a href="http://www.mysql.com">MySQL</a>.
		</p>
		<p>
		After adding the driver to the mod_db module you must <a href="/ep+name@app_ext_introspect_coldrestart">restart</a> NetKernel - when you have restarted 
		come back to this <a href="/ep+name@app_bugxter_installer">installer app</a> to complete the installation.
		</p>
		<p>
		Fill out the form below - the installer will create a temporary JDBC connection to the MySQL database.  It will install the Bugxter3 database
		and configure an initial user with Admin privileges.
		</p>
		<xsl:if test="$param">
			<table>
					<tr>
						<td bgcolor="red">
						<h2>Error</h2>
						<div style="color: ffffff;">
						<xsl:value-of select="$param/descendant::ex[position()=last()]/message"/>
						</div>
						<div>
						Please check your database permissions.  The DB Admin account you use must have remote access
						and GRANT permissions.  Also make sure you have a MySQL JDBC driver installed in mod_db/lib/.
						</div>
						</td>
					</tr>
			</table>
		</xsl:if>
				
		<form action="/ep+name@app_bugxter_installer" method="post">
			<table bgcolor="#eeeeff">
				<tr>
					<td align="left" height="30" valign="bottom" colspan="3">
					<h3>Database Installation Connection Settings</h3>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Database Server Hostname 
							<input name="hostname">
								<xsl:attribute name="value"><xsl:value-of select="/nvp/hostname"/></xsl:attribute>
							</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">The server name hosting the database - if NetKernel and the db are on the same machine use
						<i>localhost</i></div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>MySQL Port 
						<input name="port">
							<xsl:choose>
								<xsl:when test="/nvp/port">
									<xsl:attribute name="value"><xsl:value-of select="/nvp/port"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="value">3306</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</input>
					</label>	
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Username 
						<input name="dba">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/dba"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">A db user with permissions to create a new database and new users - if in doubt use your
						database root user</div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Password
						<input  type="password" name="dbapwd">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/dbapwd"/></xsl:attribute>
						</input>
					</label>
					</td>
					
				</tr>
				<tr>
					<td align="left" height="30" valign="bottom">
					<h3 style="margin-top: 25px;">NetKernel Bugxter3 application to MySQL Bugxter3 Database Connection Settings</h3>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>NetKernel Hostname
						<input  name="hostname">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/hostname"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">The hostname of this machine - this will be used to set privileges to allow connection to the MySQL server.  If NetKernel
						and MySQL are on the same machine enter 'localhost'</div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Password
						<input  type="password" name="b3pwd">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/b3pwd"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">Create a new password to use for the bugxter3 database connection</div>
					</td>
				</tr>
				<tr>
					<td align="left" height="30" valign="bottom" colspan="3">
					<h3 style="margin-top: 25px;">Create an initial Bugxter3 user with admin permissions</h3>
					</td>
				</tr>
				
				<tr>
					<td align="right">
					<label>Login
						<input  name="login">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/login"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">The users login</div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Email
						<input  name="email">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/email"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">An email address at which to receive bug notifications</div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>First Name
						<input  name="firstname">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/firstname"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">First name</div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Last Name
						<input  name="lastname">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/lastname"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">Last name</div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Password
						<input  type="password" name="password">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/password"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">Password</div>
					</td>
				</tr>
				<tr>
					<td align="left" height="30" valign="bottom" colspan="3">
					<h3 style="margin-top: 25px;">Provide general system settings</h3>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>WWW Server
						<input  name="wwwhost">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/wwwhost"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">The full URL of your HTTP server hosting bugxter - eg http://www.1060.org/  (including trailing slash and, if necessary, port) </div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Email Notifications From
						<input  name="emailfrom">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/emailfrom"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">The email address from which email notifications will originate</div>
					</td>
				</tr>
				<tr>
					<td align="right">
						<input  type="submit" value="install bugxter..."/>
					</td>
				</tr>
			</table>
			
		</form>
	</body>
	
</html>

    </xsl:template>

</xsl:stylesheet> 
