#!/bin/bash
######################################################
#NetKernel Startup Script
#v1.3.0
#(C) 2002-2009, 1060 Research Limited
######################################################

#Handle spaces in filenames for OSX
SAVEIFS=$IFS
IFS=$(echo -en "\n\b")

#Main Path
INSTALLPATH="%INSTALL%"

#######################
#Move to InstallPath so relative paths are correct
#######################
cd $INSTALLPATH

#####################
#Get local path
#####################
LIB=$INSTALLPATH/lib
EXT=$INSTALLPATH/lib/ext
#####################
#system properties
#####################
PROPS=-Djava.endorsed.dirs=$LIB/endorsed
PROPS="$PROPS -Dsun.net.client.defaultConnectTimeout=20000"
PROPS="$PROPS -Dsun.net.client.defaultReadTimeout=20000"
PROPS="$PROPS -Djava.protocol.handler.pkgs=org.ten60.netkernel.protocolhandler"
PROPS="$PROPS -Djava.awt.headless=false"
PROPS="$PROPS -Dten60.pid=1"   #Process id must be set when using 'netkernel' daemon

#####################
#Start Server
#####################
RUN=1
while [  $RUN -eq 1 ]; do

	#####################
	#Read bootjar.cnf in case externally so that we can replace bootloader with updates
	#####################
	BOOTLOADER_JAR=`cat $INSTALLPATH/bin/bootjar.cnf`
	JVMSETTINGS=`cat $INSTALLPATH/bin/jvmsettings.cnf`
	#Expand the space separated values to an array.
	OLD_IFS="$IFS"
	IFS=" "
	JVMSETTINGS=( $JVMSETTINGS )
	IFS="$OLD_IFS"
	
	#####################
	#Kernel ClassPath
	#####################
	CP=$INSTALLPATH/lib/$BOOTLOADER_JAR
	
	#Main Execution
	java $JVMSETTINGS $PROPS -cp $CP BootLoader $INSTALLPATH
 	
 	if [  $? != 100 ]; then
 		#Normal exit - reboot not requested
		RUN=0
 	fi
done