.\" $Id: radiusd.8.man,v 1.6 2001/12/13 13:42:36 gray Exp $
.so config.so
.TH Radiusd 8 "\*(DA" "FSF"
.SH NAME
radiusd - Authentication and accounting server
.SH SYNOPSIS
\fBradiusd\fR
[\fB-A\fR]
[\fB-a\fR acct_dir]
[\fB-b\fR]
[\fB-d\fR config_dir]
[\fB-f\fR]
[\fB-l\fR log_dir]
[\fB-mb\fR]
[\fB-mc\fR]
[\fB-mt\fR]
[\fB-n\fR]
[\fB-p\fR port]
[\fB-Ssv\fR]
[\fB-x\fR debug_level]
[\fB-yz\fR]
.SH DESCRIPTION
\fBradiusd\fR is the server implementing \fBRADIUS\fR protocol.
.PP
\fBRADIUS\fR is a protocol spoken between the network access server
(\fBNAS\fR) and the authentication server. The network access server
is typically a device accepting connections from several modem lines
and the authentication server is the server which decides whether some
user has the right to log in or he has not. This is called authentication.
.PP
Also, when the user logs in or out, the \fBNAS\fR sends login and
logout packets. These packets are received by the \fBradius\fR server
and recorded appropriately. This is called accounting.
.PP
Upon startup, \fBradius\fR server listens the following two ports:
authentication (default 1645), accounting (1646).
When configured with \fB--enable-snmp\fR option, \fBradiusd\fR also starts
listening on the specified SNMP port.
.PP
Upon receiving a packet from any of the above ports, the server performs
the following:
.IP "1. checks the authenticity of the request"
Depending on the type of the request this check is based on the source
IP address.
.IP "2. looks up the request queue for duplicates"
If a request is found in the queue, it gets dropped and the appropriate
diagnostics is output to the Warning channel.
.IP "3. registers request in the queue"
This is needed to prevent any eventual duplicates of this packet from being
processed.
.IP "4. processes and answers the request"
A child process may be forked during this stage to handle the request.
.PP

.SH OPTIONS
.IP "-A, --log-auth-detail"
Write a file named \fBdetail.auth\fR in the same directory as
\fBdetail\fR file. This file contains all the Attribute-Value pairs
for each authentication packet. Normally this should be used for
debugging purposes.
.IP
Configuration file equivalent: \fBdetail yes\fR in \fBauth\fR block.
.IP "-a, --acct-directory PATH"
Specify alternate directory for accounting. Usually this defaults to
\fB\*(RL/radacct\fR.
.IP
Configuration file equivalent: \fBacct-dir PATH\fR in \fBoption\fR block.
.IP "-b, --dbm"
If the \fBradiusd\fR server was configured with \fB--enable-dbm\fR
option, this flag instructs it to use the DBM version of the users
database (\fB\*(RD/users.db\fR or \fB\*(RD/users.pag\fR,
\fB\*(RD/users.dir\fR pair) instead of the plain text file
(\fB\*(RD/users\fR).
.IP
Configuration file equivalent: \fBusedbm yes\fR.
.IP "-d, --config-directory, --directory PATH"
Specifies alternate name for the configuration
directory. \fBRadiusd\fR looks there for its configuration files. It
defaults to \fB\*(RD\fR.
.IP "-f, --foreground"
Instructs the server to not detach itself from the controlling
terminal. This is used for debugging.
.IP "-i, --ip-address IP"
Specifies the IP address to listen on. If this option is not specified,
the program will listen on all IP addresses, assigned to the machine it
runs on.
.IP
Configuration file equivalent: \fBsource-ip IP\fR in \fBoption\fR block.
.IP
Please note, that \fBlisten\fR statement in \fBraddb/config\fR
provides a better control over IP addresses to listen on.
.IP "-L, --license"
Display GNU General Public License and exit.

.IP "-l, --logging-directory PATH"
Specifies alternate name for logging directory. \fBRadiusd\fR writes
there its logfile(s). The default is \fB\*(RL\fR.
.IP
Configuration file equivalent: \fBlog-dir PATH\fR in \fBoption\fR block.
.IP "-m, --mode c"
Check mode. In this mode \fBradiusd\fR starts as usual, checks its
configuration files and exits. All log channels are duplicated to
stdout.
.IP "-m, --mode b"
Build DBM users database out of plaintext file. If no argument is
specified, the file \*(RD/users is taken as input.  Otherwise the
argument specifies the filename to be used as input. This option
takes effect only if the program was configured with \fB--enable-dbm\fR
option.
.IP "-m, --mode t"
Start in test mode. In this mode \fBradiusd\fR starts interactive
interpreter which allows to test various aspects of its configuration.
.IP "-p, --port PORT"
Specifies alternate port for authentication requests. The port number
for accounting requests is determined by adding 1 to this number. Port
number should be specified in decimal. Defaults are 1645 and 1646.
.IP "-S, --log-stripped-names"
Strip off the suffix and prefix from the username before writing it to
the \fBdetail\fR file.
.IP
Configuration file equivalent: \fBstrip-names yes\fR in \fBauth\fR block.
.IP "-s, --single-process"
Tells the authentication server to operate in single process
mode. When specified this flag, the authentications server will handle
each request itself instead of forking child process to do that. This
slows down the authentication processing to a crawl and should only be
used for debugging purposes. The most convenient use is with the
\fB-f\fR option.
.IP "-v, --version"
When given this option \fBradiusd\fR prints on the standard output its
version number, compilation flags and the file names it uses and exits
with zero code.
.IP "-x, --debug MOD-LIST"
Sets the debug level. \fBMOD-LIST\fR is a comma-separated list of
\fBmodule-level\fR specifications. Each module-level specification
is either \fBMOD-NAME\fR or \fBMOD-NAME\fR=\fBLEVEL\fR, where
\fBMOD-NAME\fR is the name of the source module, \fBLEVEL\fR is
the debugging level to be set for that module (0 <= \fBLEVEL\fR <= 100)
If \fBLEVEL\fR is omitted, it defaults to 100.
.IP
Configuration file equivalent: \fBdebug MOD-LIST\fR in \fBlogging\fR block.
.IP "-y, --log-auth"
Write to the log file detailed information about each authentication
request. The information is logged under \fBauth\fR loglevel.
.IP
Configuration file equivalent: \fBprint-auth yes\fR in \fBlogging\fR block.
.IP "-z, --log-auth-pass"
Log the password along with the user name for each login. This is very
insecure. This option is provided only for debugging purposes.
.IP
Configuration file equivalent: \fBprint-pass yes\fR in \fBlogging\fR block.
.SH CONFIGURATION
\fBRadiusd\fR uses rather complicated configuration file suite. The
files live in \fB\*(RD\fR directory. The place of their location
can be overridden using \fB-d\fr option.
.PP
The configuration files are:
.IP config
This file contains all the configurable parameters of the server
itself: logging options, debug levels, notification and SNMP options,
etc.
.IP users
The plaintext users database. Contains the per-user authorization and
accounting information.
.IP users.db
Or users.dir, users.pag pair. The DBM version of the users
database. This is used when the server is compiled with
\fB--enable-dbm\fR option and either \fB-b\fR flag is specified in the
command line, or \fBusedbm yes\fR option is
used in \fBconfig\fR file.
.IP access.deny
The list of users whose access is denied for some reason.
.IP dictionary
Defines the symbolic representation of the \fBRadius\fR attributes,
attribute values, etc. Usually should not be modified.
.IP naslist
The list of network access servers that are allowed to use this
\fBRadius\fR server. This file specifies for each \fBNAS\fR its long
and short names, NAS type, and possibly its IP pool.
.IP clients
The list of IP addresses and secret keys for each \fBNAS\fR that wants
to communicate to the server.
.IP hints
The \fBradius\fR server can alter its politics towards a user
depending on its login name. It can, for example, supply a different
kind of service, assign it the IP number, etc. This file specifies
the rules to be applied to an incoming request depending on the 
username it contains.
.IP huntgroups
Defines the huntgroups. A huntgroup is a class of users that have
some common attributes in the incoming packet, for example all users
coming from a given NAS. 

.SH FILES
These are default values. They can be overridden either from command
line or from configuration file.

.IP \*(RD/
Configuration files directory
.PP
.IP \*(RL/radius.log
Default logfile.
.IP \*(RL/radacct
Accounting directory.
.IP \*(RP/radius.pid
Holds the PID number of the master \fBRadius\fR process.
.PP

.SH BUGS
The information in this manpage may be obsolete or incomplete. Please
refer to texinfo documentation for full information about GNU Radius
tools.
.SH AUTHORS
\*(AU

.SH SEE ALSO
users(5rad), config(5rad), dictionary(5rad), naslist(5rad), clients(5rad),
hints(5rad), huntgroups(5rad), builddbm(8rad), radlast(1rad), raduse(1rad),
radwho(1rad), radzap(8rad), radctl(8rad), radgrep(1rad),
radping(8rad), radtest(8rad), radsnmp(8rad)
.PP
