/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.project.ProjectLibrary;
import java.io.Serializable;

public class ProjectCell
implements Serializable {
    private Cell cell;
    private String cellName;
    private View cellView;
    private int cellVersion;
    private FileType libType;
    private boolean latestVersion;
    private String checkInDate;
    private String owner;
    private String lastOwner;
    private String comment;
    private ProjectLibrary projLib;

    ProjectCell(Cell cell, ProjectLibrary pl) {
        this.cell = cell;
        if (cell != null) {
            this.cellName = cell.getName();
            this.cellView = cell.getView();
            this.cellVersion = cell.getVersion();
        } else {
            this.cellName = "";
            this.cellView = View.UNKNOWN;
        }
        this.latestVersion = true;
        this.owner = "";
        this.lastOwner = "";
        this.projLib = pl;
        this.libType = FileType.JELIB;
        pl.addProjectCell(this);
    }

    Cell getCell() {
        return this.cell;
    }

    void setCell(Cell cell) {
        this.cell = cell;
    }

    String getCellName() {
        return this.cellName;
    }

    void setCellName(String cellName) {
        this.cellName = cellName;
    }

    View getView() {
        return this.cellView;
    }

    void setView(View cellView) {
        this.cellView = cellView;
    }

    int getVersion() {
        return this.cellVersion;
    }

    void setVersion(int version) {
        this.cellVersion = version;
    }

    FileType getLibType() {
        return this.libType;
    }

    String getLibExtension() {
        return this.libType.getFirstExtension();
    }

    void setLibType(FileType libType) {
        this.libType = libType;
    }

    boolean isLatestVersion() {
        return this.latestVersion;
    }

    void setLatestVersion(boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    String getOwner() {
        return this.owner;
    }

    void setOwner(String owner) {
        this.owner = owner;
    }

    String getLastOwner() {
        return this.lastOwner;
    }

    void setLastOwner(String lastOwner) {
        this.lastOwner = lastOwner;
    }

    String getComment() {
        return this.comment;
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    String getCheckInDate() {
        return this.checkInDate;
    }

    void setCheckInDate(String checkInDate) {
        this.checkInDate = checkInDate;
    }

    ProjectLibrary getProjectLibrary() {
        return this.projLib;
    }

    String describe() {
        Object cn = this.cellName;
        if (this.cellView != View.UNKNOWN) {
            cn = (String)cn + this.cellView.getAbbreviationExtension();
        }
        return cn;
    }

    String describeWithVersion() {
        String cn = this.cellName + ";" + this.cellVersion;
        if (this.cellView != View.UNKNOWN) {
            cn = cn + this.cellView.getAbbreviationExtension();
        }
        return cn;
    }
}

