/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nms2 {
    private static final double gY = -4.0;
    private static final double dY = -11.0;
    private static final double nmosTop = -9.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int nbStacked;
        double totWid;
        sz = stdCell.roundSize(sz);
        String nm = "nms2";
        sz = stdCell.checkMinStrength(sz, 0.5, nm);
        double nmosLowest = stdCell.getCellBot() + 1.5 + 5.0 + 2.0;
        double spaceAvail = -9.0 - nmosLowest;
        FoldsAndWidth fw = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * (double)(nbStacked = 2), 1);
        Nms2.error(fw == null, "can't make Nms2 this small: " + sz);
        double g2FromGndY = stdCell.getGndY() - stdCell.getGndWidth() / 2.0 - 3.0 - 2.0;
        double g2FromMosY = -9.0 - fw.physWid - 2.0 - 2.5;
        double g2Y = Math.min(g2FromGndY, g2FromMosY);
        Cell nms2 = stdCell.findPart(nm, sz);
        if (nms2 != null) {
            return nms2;
        }
        nms2 = stdCell.newPart(nm, sz);
        double gX = 3.5;
        LayoutLib.newExport(nms2, "g", PortCharacteristic.IN, Tech.m1, 4.0, gX, -4.0);
        double mosX = gX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fw.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fw.nbFolds, nbStacked, fw.gateWid, nms2, stdCell);
        double g2X = StdCellParams.getRightDiffX(nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nms2, "g2", PortCharacteristic.IN, Tech.m1, 4.0, g2X, g2Y);
        double dX = g2X + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nms2, "d", PortCharacteristic.OUT, Tech.m1, 4.0, dX, -11.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nms2);
        TrackRouterH g = new TrackRouterH(Tech.m1, 3.0, -4.0, nms2);
        TrackRouterH g2 = new TrackRouterH(Tech.m1, 3.0, g2Y, nms2);
        g.connect(nms2.findExport("g"));
        g2.connect(nms2.findExport("g2"));
        for (int i = 0; i < nmos.nbGates(); i += 2) {
            if (i / 2 % 2 == 0) {
                ((TrackRouter)g).connect(nmos.getGate(i, 'T'), -4.0, -1.5);
                ((TrackRouter)g2).connect(nmos.getGate(i + 1, 'B'), 4.0, 1.5);
                continue;
            }
            ((TrackRouter)g).connect(nmos.getGate(i + 1, 'T'), 4.0, -1.5);
            ((TrackRouter)g2).connect(nmos.getGate(i, 'B'), -4.0, 1.5);
        }
        TrackRouterH d = new TrackRouterH(Tech.m2, 4.0, -11.0, nms2);
        d.connect(nms2.findExport("d"));
        for (int i = 1; i < nmos.nbSrcDrns(); i += 2) {
            d.connect(nmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = dX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nms2);
        stdCell.addNstackEssentialBounds(wellMinX, wellMaxX, nms2);
        stdCell.doNCC(nms2, nm + "{sch}");
        return nms2;
    }
}

