/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.npm;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wildwebdeveloper.debug.AbstractDebugAdapterLaunchShortcut;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;
import org.eclipse.wildwebdeveloper.debug.npm.NpmLaunchShortcut;
import org.eclipse.wildwebdeveloper.util.FileUtils;

public class NpmLaunchTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    protected Composite resComposite;
    protected AbstractDebugAdapterLaunchShortcut shortcut = new NpmLaunchShortcut();
    private Combo argumentsCombo;
    private File packageJSONFile;
    private File defaultSelectedFile;

    public void createControl(Composite parent) {
        this.resComposite = new Composite(parent, 0);
        this.resComposite.setLayout((Layout)new GridLayout(2, false));
        new Label(this.resComposite, 0).setText(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_argumentLabel);
        this.argumentsCombo = new Combo(this.resComposite, 2564);
        this.argumentsCombo.setLayoutData((Object)new GridData(4, -1, true, false));
        NpmLaunchTab.addComboItems(this.argumentsCombo, "install", "update", "ci", "pack", "run", "run-script", "start", "restart", "test");
        this.argumentsCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
        this.argumentsCombo.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Label pkgLabel = new Label(this.resComposite, 0);
        pkgLabel.setText(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_programPathLabel);
        GridData pkgLabelGD = new GridData(1, 128, false, false);
        pkgLabel.setLayoutData((Object)pkgLabelGD);
        Composite filePathComposite = new Composite(this.resComposite, 0);
        GridLayout filePathGL = new GridLayout(1, false);
        filePathGL.marginHeight = 0;
        filePathGL.marginWidth = 0;
        filePathComposite.setLayout((Layout)filePathGL);
        filePathComposite.setLayoutData((Object)new GridData(4, -1, true, false));
        this.programPathText = new Text(filePathComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        ControlDecoration decoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        decoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> {
            this.setDirty(true);
            try {
                File file = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.programPathText.getText()));
                if (!file.isFile()) {
                    String errorMessage = Messages.RunProgramTab_error_unknownFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else if (!this.shortcut.canLaunch(file)) {
                    String errorMessage = org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_notPackageJSONFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else if (!file.canRead()) {
                    String errorMessage = Messages.RunProgramTab_error_nonReadableFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else {
                    this.setErrorMessage(null);
                    decoration.hide();
                }
            }
            catch (CoreException ex) {
                this.setErrorMessage(ex.getMessage());
                decoration.setDescriptionText(ex.getMessage());
                decoration.show();
            }
            this.updateLaunchConfigurationDialog();
        });
        Composite buttonsBar = new Composite(filePathComposite, 0);
        GridLayout buttonsGL = new GridLayout(3, false);
        buttonsGL.marginHeight = 0;
        buttonsGL.marginWidth = 0;
        buttonsBar.setLayout((Layout)buttonsGL);
        GridData buttonsBarGD = new GridData(0x1000008, 0x1000000, true, false);
        buttonsBar.setLayoutData((Object)buttonsBarGD);
        Button workspaceButton = new Button(buttonsBar, 8);
        workspaceButton.setLayoutData((Object)new GridData(131072, -1, false, false));
        workspaceButton.setText(Messages.AbstractRunHTMLDebugTab_browse_workspace);
        workspaceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IResource resource;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.resComposite.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_selectPackageJSON);
            dialog.setMessage(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_selectPackageJSON);
            dialog.setValidator(selection -> {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wildwebdeveloper", "");
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (!(f instanceof IFile)) {
                        return new Status(4, "org.eclipse.wildwebdeveloper", "Must select a file");
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.wildwebdeveloper", "");
            });
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                String arg = resource.getFullPath().toString();
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                this.programPathText.setText(fileLoc);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        Button filePath = new Button(buttonsBar, 8);
        filePath.setLayoutData((Object)new GridData(131072, -1, false, false));
        filePath.setText(Messages.AbstractRunHTMLDebugTab_browse);
        filePath.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog filePathDialog = new FileDialog(this.resComposite.getShell());
            filePathDialog.setFilterPath(SelectionUtils.getSelectedProject() == null ? null : SelectionUtils.getSelectedProject().getAbsolutePath());
            filePathDialog.setText(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_selectPackageJSON);
            String path = filePathDialog.open();
            if (path != null) {
                this.packageJSONFile = new File(path);
                this.programPathText.setText(this.packageJSONFile.getAbsolutePath());
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        Button variablesButton = new Button(buttonsBar, 8);
        variablesButton.setLayoutData((Object)new GridData(131072, -1, false, false));
        variablesButton.setText(Messages.AbstractRunHTMLDebugTab_variables);
        variablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String expr;
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.resComposite.getShell());
            if (dialog.open() == 0 && (expr = dialog.getVariableExpression()) != null) {
                this.programPathText.insert(expr);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.setControl((Control)this.resComposite);
    }

    public static void addComboItems(Combo combo, String ... commands) {
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            combo.add(command);
            ++n2;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.defaultSelectedFile = SelectionUtils.getSelectedFile(this.shortcut::canLaunch);
            String defaultSelectedFilePath = SelectionUtils.pathOrEmpty(this.defaultSelectedFile);
            this.programPathText.setText(configuration.getAttribute("program", defaultSelectedFilePath));
            this.argumentsCombo.setText(configuration.getAttribute("runtimeArgs", "install"));
        }
        catch (CoreException e) {
            ILog.get().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String workingDirectory = SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedProject());
        if (this.packageJSONFile != null) {
            workingDirectory = SelectionUtils.pathOrEmpty(this.packageJSONFile.getParentFile());
        } else if (this.defaultSelectedFile != null) {
            workingDirectory = SelectionUtils.pathOrEmpty(this.defaultSelectedFile.getParentFile());
        }
        String programPath = this.programPathText.getText();
        configuration.setAttribute("program", programPath);
        configuration.setAttribute("runtimeArgs", this.argumentsCombo.getText());
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", workingDirectory);
        configuration.setMappedResources((IResource[])ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(FileUtils.toUri(programPath)));
    }

    public String getName() {
        return Messages.RunProgramTab_title;
    }
}

