/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swtchart.extensions.internal.support.MappingsComparator;
import org.eclipse.swtchart.extensions.internal.support.MappingsFilter;
import org.eclipse.swtchart.extensions.internal.support.MappingsLabelProvider;

public class MappingsListUI
extends TableViewer {
    private static final String[] TITLES = MappingsLabelProvider.TITLES;
    private static final int[] BOUNDS = MappingsLabelProvider.BOUNDS;
    private ILabelProvider labelProvider = new MappingsLabelProvider();
    private IContentProvider contentProvider = ArrayContentProvider.getInstance();
    private MappingsComparator comparator = new MappingsComparator();
    private MappingsFilter filter = new MappingsFilter();
    private List<TableViewerColumn> columns = new ArrayList<TableViewerColumn>();

    public MappingsListUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.filter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    private void createControl() {
        this.createColumns(TITLES, BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider(this.contentProvider);
        this.setComparator(this.comparator);
        this.setFilters(new ViewerFilter[]{this.filter});
    }

    private void createColumns(String[] titles, int[] bounds) {
        Table table = this.getTable();
        table.setRedraw(false);
        table.clearAll();
        while (table.getColumnCount() > 0) {
            table.getColumns()[0].dispose();
        }
        table.setRedraw(true);
        this.refresh();
        if (this.getLabelProvider() != null) {
            int i = 0;
            while (i < titles.length) {
                String title = titles[i];
                TableViewerColumn tableViewerColumn = this.createTableColumn(title, bounds[i]);
                TableColumn tableColumn = tableViewerColumn.getColumn();
                tableColumn.addSelectionListener((SelectionListener)this.createSelectionAdapter(tableColumn, i));
                this.columns.add(tableViewerColumn);
                ++i;
            }
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private SelectionAdapter createSelectionAdapter(TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingsListUI.this.comparator.setColumn(index);
                int direction = MappingsListUI.this.comparator.getDirection();
                MappingsListUI.this.getTable().setSortDirection(direction);
                MappingsListUI.this.refresh();
            }
        };
        return selectionAdapter;
    }

    private TableViewerColumn createTableColumn(String title, int width) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(title);
        tableColumn.setWidth(width);
        tableColumn.setResizable(true);
        tableColumn.setMoveable(false);
        return tableViewerColumn;
    }
}

