/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.trace4cps.core.impl.Trace;
import org.eclipse.trace4cps.core.io.TraceWriter;
import org.eclipse.trace4cps.core.io.conv.Configuration;
import org.eclipse.trace4cps.core.io.conv.ESIFormatConfigurationParser;
import org.eclipse.trace4cps.core.io.conv.ESIFormatTraceParser;
import org.eclipse.trace4cps.core.io.conv.ParserException;

public class TraceConverter {
    private TraceConverter() {
    }

    public static void main(String ... args) {
        TraceConverter.checkArgs(args);
        File configFile = new File(args[0]);
        TraceConverter.checkFile(configFile);
        File traceFile = new File(args[1]);
        TraceConverter.checkFile(traceFile);
        try {
            File out = new File(traceFile.getParent(), traceFile.getName() + ".etf");
            TraceConverter.convert(configFile, traceFile, out);
        }
        catch (IOException | ParserException e) {
            e.printStackTrace();
        }
    }

    public static void convert(File configFile, File traceFile, File outputFile) throws IOException, ParserException {
        Configuration config = new ESIFormatConfigurationParser().parseTraceV0config(configFile);
        Trace trace = new ESIFormatTraceParser().parseTraceV0(traceFile, config);
        TraceWriter.writeTrace(trace, outputFile);
    }

    private static void checkFile(File f) {
        if (!f.canRead()) {
            System.out.println("Cannot read " + f.getAbsolutePath());
            System.exit(1);
        }
    }

    private static void checkArgs(String ... args) {
        if (args.length != 2) {
            System.out.println("Usage: java -classpath org.eclipse.trace4cps.core-?.?.?.jar org.eclipse.trace4cps.core.io.conv.TraceConverter <config file> <trace file>");
            System.out.println("Given args: " + Arrays.toString(args));
            System.exit(1);
        }
    }
}

