/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ValueofExpression;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnnecessaryValueof
extends BaseModuleCodeSmellSpotter {
    public static final String TEXT = "Applying the `valueof' operation to '{0}' will result in the original value";

    public UnnecessaryValueof() {
        super(CodeSmellType.UNNECESSARY_VALUEOF);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (node instanceof ValueofExpression) {
            ValueofExpression exp = (ValueofExpression)node;
            CompilationTimeStamp stamp = CompilationTimeStamp.getBaseTimestamp();
            if (exp.getIsErroneous(stamp) || exp.isUnfoldable(stamp, null)) {
                return;
            }
            TemplateInstance inst = exp.getTemplateInstance();
            if (inst != null && inst.getDerivedReference() == null && inst.getTemplateBody().isValue(stamp)) {
                String msg = MessageFormat.format(TEXT, inst.getTemplateBody().getValue().createStringRepresentation());
                problems.report(exp.getLocation(), msg);
            }
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(ValueofExpression.class);
        return ret;
    }
}

