/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clauses;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsBoundExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsChoosenExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsPresentExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.NotExpression;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class IsBoundWithoutElse
extends BaseModuleCodeSmellSpotter {
    private static final String ERR_MSG = "Only the positive branch of `{0}'' check is used. In tests it is advised to log the reason of failure in the else branch.";
    private static final Map<Class<?>, String> NAMES = new HashMap();

    protected IsBoundWithoutElse() {
        super(CodeSmellType.ISBOUND_WITHOUT_ELSE);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof If_Statement)) {
            return;
        }
        If_Statement ifs = (If_Statement)node;
        StatementBlock elseClause = ifs.getStatementBlock();
        if (elseClause != null) {
            return;
        }
        If_Clauses ifcs = ifs.getIfClauses();
        if (ifcs == null) {
            return;
        }
        List ifcL = ifcs.getClauses();
        if (ifcL == null || ifcL.isEmpty()) {
            return;
        }
        for (If_Clause ifc : ifcL) {
            IfConditionVisitor visitor = new IfConditionVisitor(problems);
            ifc.accept((ASTVisitor)visitor);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(3);
        ret.add(If_Statement.class);
        return ret;
    }

    static {
        NAMES.put(IsBoundExpression.class, "isBound");
        NAMES.put(IsPresentExpression.class, "isPresent");
        NAMES.put(IsChoosenExpression.class, "isChosen");
    }

    private static class IfConditionVisitor
    extends ASTVisitor {
        private final int negationsNumber;
        private final BaseCodeSmellSpotter.Problems problems;
        private boolean insideNotExpr = false;

        public IfConditionVisitor(BaseCodeSmellSpotter.Problems problems) {
            this(0, problems);
        }

        private IfConditionVisitor(int negationsNumber, BaseCodeSmellSpotter.Problems problems) {
            this.negationsNumber = negationsNumber;
            this.problems = problems;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof If_Statement) {
                return 1;
            }
            if (this.insideNotExpr) {
                IfConditionVisitor visitor = new IfConditionVisitor(this.negationsNumber + 1, this.problems);
                node.accept((ASTVisitor)visitor);
                this.insideNotExpr = false;
                return 1;
            }
            if (node instanceof NotExpression) {
                this.insideNotExpr = true;
            } else if (node instanceof IsBoundExpression || node instanceof IsPresentExpression || node instanceof IsChoosenExpression) {
                Expression_Value ev = (Expression_Value)node;
                if (this.negationsNumber % 2 == 0) {
                    this.problems.report(ev.getLocation(), MessageFormat.format(IsBoundWithoutElse.ERR_MSG, NAMES.get(ev.getClass())));
                }
                return 1;
            }
            return 3;
        }
    }
}

