/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.common;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.SatelliteTranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class CustomSatelliteViewer
extends SatelliteVisualizationViewer<NodeDescriptor, EdgeDescriptor> {
    private static final long serialVersionUID = 4410062275063286243L;
    private double actZoom = 1.0;

    public CustomSatelliteViewer(VisualizationViewer<NodeDescriptor, EdgeDescriptor> master) {
        super(master, new Dimension(600, 600));
        PluggableGraphMouse satMouse = new PluggableGraphMouse(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                float scale = e.getWheelRotation() > 0 ? 0.9f : 1.1f;
                CrossoverScalingControl control = new CrossoverScalingControl();
                control.scale((VisualizationServer)CustomSatelliteViewer.this.getMaster(), scale, CustomSatelliteViewer.this.getCenter());
            }
        };
        satMouse.add((GraphMousePlugin)new SatelliteTranslatingGraphMousePlugin(){

            public void mouseDragged(MouseEvent arg0) {
                if (this.down == null) {
                    return;
                }
                super.mouseDragged(arg0);
            }

            public void mousePressed(MouseEvent e) {
                VisualizationViewer vv = (VisualizationViewer)e.getSource();
                boolean accepted = this.checkModifiers(e);
                if (accepted && vv instanceof SatelliteVisualizationViewer) {
                    VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                    MutableTransformer modelTransformerMaster = vvMaster.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
                    Point2D orig = vvMaster.getRenderContext().getMultiLayerTransformer().inverseTransform(vvMaster.getCenter());
                    Point2D mouse = vv.getRenderContext().getMultiLayerTransformer().inverseTransform((Point2D)e.getPoint());
                    modelTransformerMaster.translate(orig.getX() - mouse.getX(), orig.getY() - mouse.getY());
                }
                super.mousePressed(e);
            }
        });
        this.setGraphMouse((VisualizationViewer.GraphMouse)satMouse);
    }

    public void scaleToLayout(ScalingControl scaler) {
        Dimension currentSize;
        Dimension newSize = this.getPreferredSize();
        if (this.isShowing()) {
            newSize = this.getSize();
        }
        if (!newSize.equals(currentSize = this.getGraphLayout().getSize()) && newSize.getWidth() > 0.0 && newSize.getHeight() > 0.0) {
            this.actZoom = newSize.getWidth() / currentSize.getWidth();
            scaler.scale((VisualizationServer)this, (float)this.actZoom, (Point2D)new Point2D.Double());
        }
    }

    public void changeSize(Dimension size) {
        this.setPreferredSize(size);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        scaler.scale((VisualizationServer)this, (float)(1.0 / this.actZoom), (Point2D)new Point2D.Double());
        this.scaleToLayout((ScalingControl)new CrossoverScalingControl());
        this.setSize(size);
    }
}

