/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.visibility;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ExternalConst;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

class ChangeCreator {
    private final IFile selectedFile;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        DefinitionVisitor vis = new DefinitionVisitor();
        module.accept((ASTVisitor)vis);
        NavigableSet nodes = vis.getLocations();
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        try {
            WorkspaceJob job1 = this.calculateEditLocations(nodes, toVisit, locations);
            job1.join();
        }
        catch (InterruptedException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)"MinimizeVisibilityRefactoring/CreateChange.createFileChange(): CoreException while calculating edit locations. ");
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (locations.isEmpty()) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        for (Location l : locations) {
            int len = l.getEndOffset() - l.getOffset();
            if (len == 0) {
                rootEdit.addChild((TextEdit)new InsertEdit(l.getOffset(), "private "));
                continue;
            }
            rootEdit.addChild((TextEdit)new ReplaceEdit(l.getOffset(), len, "private "));
        }
        return tfc;
    }

    private WorkspaceJob calculateEditLocations(final NavigableSet<ILocateableNode> nodes, final IFile file, final List<Location> locations_out) throws CoreException {
        WorkspaceJob job = new WorkspaceJob("MinimizeVisibilityRefactoring: calculate edit locations"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int BUF_LEN = 8;
                try {
                    InputStream is = file.getContents();
                    InputStreamReader isr = new InputStreamReader(is, file.getCharset());
                    int currOffset = 0;
                    char[] content = new char[8];
                    for (ILocateableNode node : nodes) {
                        int toSkip = node.getLocation().getOffset() - currOffset;
                        if (toSkip < 0) {
                            ErrorReporter.logError((String)("MinimizeVisibilityRefactoring.ChangeCreator: Negative skip value while parsing file: " + file.getName() + ", offset: " + node.getLocation().getOffset() + "->" + currOffset));
                            continue;
                        }
                        isr.skip(toSkip);
                        isr.read(content);
                        String str = new String(content);
                        VisibilityModifier vm = ChangeCreator.parseVisibilityModifier(str);
                        int vmLen = 0;
                        if (vm != null) {
                            switch (vm) {
                                case Public: {
                                    vmLen = 7;
                                    break;
                                }
                                case Friend: {
                                    vmLen = 7;
                                    break;
                                }
                                case Private: {
                                    vmLen = 8;
                                }
                            }
                        }
                        locations_out.add(new Location(node.getLocation().getFile(), node.getLocation().getLine(), node.getLocation().getOffset(), node.getLocation().getOffset() + vmLen));
                        currOffset = node.getLocation().getOffset() + 8;
                    }
                    isr.close();
                    is.close();
                }
                catch (IOException ioe) {
                    ErrorReporter.logError((String)"MinimizeVisibilityRefactoring.CreateChange: Error while reading source project.");
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    private static VisibilityModifier parseVisibilityModifier(String str) {
        if (str.contains("public ")) {
            return VisibilityModifier.Public;
        }
        if (str.contains("friend ")) {
            return VisibilityModifier.Friend;
        }
        if (str.contains("private ")) {
            return VisibilityModifier.Private;
        }
        return null;
    }

    private static class LocationComparator
    implements Comparator<ILocateableNode> {
        private LocationComparator() {
        }

        @Override
        public int compare(ILocateableNode arg0, ILocateableNode arg1) {
            int o1;
            IResource f1;
            IResource f0 = arg0.getLocation().getFile();
            if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
                return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
            }
            int o0 = arg0.getLocation().getOffset();
            return o0 < (o1 = arg1.getLocation().getOffset()) ? -1 : (o0 == o1 ? 0 : 1);
        }
    }

    private static class DefinitionVisitor
    extends ASTVisitor {
        private final NavigableSet<ILocateableNode> locations = new TreeSet<ILocateableNode>(new LocationComparator());

        DefinitionVisitor() {
        }

        private NavigableSet<ILocateableNode> getLocations() {
            return this.locations;
        }

        public int visit(IVisitableNode node) {
            Definition d;
            if (node instanceof Definition && this.isGoodType(node) && !(d = (Definition)node).isLocal() && !VisibilityModifier.Private.equals((Object)d.getVisibilityModifier()) && this.hasValidLocation(d)) {
                String moduleName = d.getMyScope().getModuleScope().getName();
                if (!d.isUsed()) {
                    this.locations.add((ILocateableNode)d);
                } else if (d.referingHere.size() == 1 && ((String)d.referingHere.get(0)).equals(moduleName)) {
                    this.locations.add((ILocateableNode)d);
                }
            }
            return 3;
        }

        private boolean isGoodType(IVisitableNode node) {
            return node instanceof Def_Altstep || node instanceof Def_Const || node instanceof Def_ExternalConst || node instanceof Def_Extfunction || node instanceof Def_Function || node instanceof Def_ModulePar || node instanceof Def_Template || node instanceof Def_Type;
        }

        private boolean hasValidLocation(Definition def) {
            Location location = def.getLocation();
            return location != null && location.getOffset() >= 0 && location.getEndOffset() >= 0;
        }
    }
}

