/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class ModuleImportation
implements IReferenceChainElement,
IOutlineElement,
IVisitableNode {
    protected static final String KIND = "imported module";
    public static final String UNUSEDIMPORTATION = "Possibly unused importation";
    protected Identifier identifier;
    protected Module referredModule = null;
    protected IProject project;
    protected boolean usedForImportation = false;
    protected CompilationTimeStamp lastImportCheckTimeStamp;
    private boolean hasUnhandledChange = false;

    public ModuleImportation(Identifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public final Identifier getIdentifier() {
        return this.identifier;
    }

    public final Module getReferredModule() {
        return this.referredModule;
    }

    public boolean hasUnhandledChange() {
        return this.hasUnhandledChange;
    }

    public void setUnhandledChange(boolean value) {
        this.hasUnhandledChange = value;
    }

    public void clear() {
        this.referredModule = null;
        this.lastImportCheckTimeStamp = null;
    }

    public final void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public Location getChainLocation() {
        if (this.identifier != null && this.identifier.getLocation() != null) {
            return this.identifier.getLocation();
        }
        return null;
    }

    @Override
    public final Object[] getOutlineChildren() {
        return new Object[0];
    }

    @Override
    public final String getOutlineText() {
        return "";
    }

    @Override
    public final String getOutlineIcon() {
        if (this.referredModule == null) {
            return "titan.gif";
        }
        return this.referredModule.getOutlineIcon();
    }

    @Override
    public final int category() {
        return 0;
    }

    public final void setUsedForImportation() {
        this.usedForImportation = true;
    }

    public final void setUsedForImportation(boolean used) {
        this.usedForImportation = used;
    }

    public final boolean getUsedForImportation() {
        return this.usedForImportation;
    }

    public abstract void checkImports(CompilationTimeStamp var1, ModuleImportationChain var2, List<Module> var3);

    public abstract void check(CompilationTimeStamp var1);

    public abstract boolean hasImportedAssignmentWithID(CompilationTimeStamp var1, Identifier var2);

    public abstract Assignment importAssignment(CompilationTimeStamp var1, ModuleImportationChain var2, Identifier var3, Reference var4, List<ModuleImportation> var5);

    public abstract void addProposal(ProposalCollector var1, Identifier var2);

    public abstract void addDeclaration(DeclarationCollector var1, Identifier var2);

    public void generateCode(JavaGenData aData) {
        aData.addCommonLibraryImport("Module_List");
        StringBuilder preInit = aData.getPreInit();
        preInit.append(MessageFormat.format("Module_List.pre_init_module(\"{0}\");\n", this.referredModule.getIdentifier().getDisplayName()));
        StringBuilder postInit = aData.getPostInit();
        postInit.append(MessageFormat.format("Module_List.post_init_module(\"{0}\");\n", this.referredModule.getIdentifier().getDisplayName()));
    }
}

