/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.experiment;

import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperimentContext;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperimentLocation;
import org.eclipse.linuxtools.tmf.core.experiment.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;

public class TmfExperiment<T extends ITmfEvent>
extends TmfEventProvider<T>
implements ITmfTrace<T> {
    protected static TmfExperiment<?> fCurrentExperiment = null;
    protected ITmfTrace<T>[] fTraces;
    protected long fNbEvents;
    protected TmfTimeRange fTimeRange;
    protected ITmfTimestamp fEpoch;
    protected Vector<TmfCheckpoint> fCheckpoints = new Vector();
    protected TmfExperimentContext fExperimentContext;
    private boolean fInitialized = false;
    private IFile fBookmarksFile;
    private IResource fResource;
    private static final int DEFAULT_INDEX_PAGE_SIZE = 5000;
    protected int fIndexPageSize;
    protected boolean fIndexing = false;
    protected TmfTimeRange fIndexingPendingRange = TmfTimeRange.NULL_RANGE;
    private Integer fEndSynchReference;

    @Override
    public boolean validate(IProject project, String path) {
        return true;
    }

    @Override
    public void initTrace(String name, String path, Class<T> eventType) {
    }

    @Override
    public void initTrace(String name, String path, Class<T> eventType, boolean indexTrace) {
        if (indexTrace) {
            this.initializeStreamingMonitor();
        }
    }

    @Override
    public void initTrace(String name, String path, Class<T> eventType, int cacheSize) {
    }

    @Override
    public void initTrace(String name, String path, Class<T> eventType, int cacheSize, boolean indexTrace) {
        if (indexTrace) {
            this.initializeStreamingMonitor();
        }
    }

    public TmfExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, ITmfTimestamp epoch, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.ZERO, indexPageSize, false);
    }

    public TmfExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, ITmfTimestamp epoch, int indexPageSize, boolean preIndexExperiment) {
        super(id, type);
        this.fTraces = traces;
        this.fEpoch = epoch;
        this.fIndexPageSize = indexPageSize;
        this.fTimeRange = TmfTimeRange.NULL_RANGE;
        if (preIndexExperiment) {
            this.indexExperiment(true);
            this.updateTimeRange();
        }
    }

    protected TmfExperiment(String id, Class<T> type) {
        super(id, type);
    }

    public TmfExperiment(Class<T> type, String id, ITmfTrace<T>[] traces) {
        this(type, id, traces, TmfTimestamp.ZERO, 5000);
    }

    public TmfExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.ZERO, indexPageSize);
    }

    public TmfExperiment(TmfExperiment<T> other) {
        super(String.valueOf(other.getName()) + "(clone)", other.fType);
        this.fEpoch = other.fEpoch;
        this.fIndexPageSize = other.fIndexPageSize;
        this.fTraces = new ITmfTrace[other.fTraces.length];
        int trace = 0;
        while (trace < other.fTraces.length) {
            this.fTraces[trace] = other.fTraces[trace].copy();
            ++trace;
        }
        this.fNbEvents = other.fNbEvents;
        this.fTimeRange = other.fTimeRange;
    }

    @Override
    public TmfExperiment<T> copy() {
        TmfExperiment<T> experiment = new TmfExperiment<T>(this);
        TmfSignalManager.deregister(experiment);
        return experiment;
    }

    @Override
    public synchronized void dispose() {
        TmfExperimentDisposedSignal signal = new TmfExperimentDisposedSignal((Object)this, this);
        this.broadcast(signal);
        if (fCurrentExperiment == this) {
            fCurrentExperiment = null;
        }
        if (this.fTraces != null) {
            ITmfTrace<T>[] iTmfTraceArray = this.fTraces;
            int n = this.fTraces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace<T> trace = iTmfTraceArray[n2];
                trace.dispose();
                ++n2;
            }
            this.fTraces = null;
        }
        if (this.fCheckpoints != null) {
            this.fCheckpoints.clear();
        }
        super.dispose();
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public int getCacheSize() {
        return this.fIndexPageSize;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fTimeRange.getStartTime();
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fTimeRange.getEndTime();
    }

    public Vector<TmfCheckpoint> getCheckpoints() {
        return this.fCheckpoints;
    }

    public static void setCurrentExperiment(TmfExperiment<?> experiment) {
        if (fCurrentExperiment != null && fCurrentExperiment != experiment) {
            fCurrentExperiment.dispose();
        }
        fCurrentExperiment = experiment;
    }

    public static TmfExperiment<?> getCurrentExperiment() {
        return fCurrentExperiment;
    }

    public ITmfTimestamp getEpoch() {
        return this.fEpoch;
    }

    public ITmfTrace<T>[] getTraces() {
        return this.fTraces;
    }

    @Override
    public long getRank(ITmfTimestamp timestamp) {
        TmfExperimentContext context = this.seekEvent(timestamp);
        return context.getRank();
    }

    public ITmfTimestamp getTimestamp(int index) {
        TmfExperimentContext context = this.seekEvent(index);
        ITmfEvent event = this.getNextEvent(context);
        return event != null ? event.getTimestamp() : null;
    }

    protected void updateTimeRange() {
        ITmfTimestamp startTime = this.fTimeRange != TmfTimeRange.NULL_RANGE ? this.fTimeRange.getStartTime() : TmfTimestamp.BIG_CRUNCH;
        ITmfTimestamp endTime = this.fTimeRange != TmfTimeRange.NULL_RANGE ? this.fTimeRange.getEndTime() : TmfTimestamp.BIG_BANG;
        ITmfTrace<T>[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTimestamp traceEndTime;
            ITmfTrace<T> trace = iTmfTraceArray[n2];
            ITmfTimestamp traceStartTime = trace.getStartTime();
            if (traceStartTime.compareTo(startTime, true) < 0) {
                startTime = traceStartTime;
            }
            if ((traceEndTime = trace.getEndTime()).compareTo(endTime, true) > 0) {
                endTime = traceEndTime;
            }
            ++n2;
        }
        this.fTimeRange = new TmfTimeRange(startTime, endTime);
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<T> request) {
        ITmfTimestamp timestamp;
        ITmfTimestamp iTmfTimestamp = timestamp = request instanceof ITmfEventRequest ? ((ITmfEventRequest)request).getRange().getStartTime() : null;
        if (TmfTimestamp.BIG_BANG.equals(timestamp) || request.getIndex() > 0) {
            timestamp = null;
        }
        TmfExperimentContext context = null;
        if (timestamp != null) {
            context = this.seekEvent(timestamp);
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
        } else {
            context = this.fExperimentContext != null && this.fExperimentContext.getRank() == (long)request.getIndex() ? this.fExperimentContext : this.seekEvent(request.getIndex());
        }
        return context;
    }

    @Override
    public T getNext(ITmfContext context) {
        if (context instanceof TmfExperimentContext) {
            return (T)this.getNextEvent((TmfExperimentContext)context);
        }
        return null;
    }

    @Override
    public synchronized TmfExperimentContext seekLocation(ITmfLocation<?> location) {
        if (location != null && !(location instanceof TmfExperimentLocation)) {
            return null;
        }
        if (this.fTraces == null) {
            return null;
        }
        TmfExperimentLocation expLocation = location == null ? new TmfExperimentLocation(new TmfLocationArray(new ITmfLocation[this.fTraces.length]), new long[this.fTraces.length]) : (TmfExperimentLocation)location.clone();
        TmfExperimentContext context = new TmfExperimentContext(this.fTraces, new TmfContext[this.fTraces.length]);
        long rank = 0L;
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfLocation<? extends Comparable<?>> traceLocation = ((TmfLocationArray)expLocation.getLocation()).locations[i];
            long traceRank = expLocation.getRanks()[i];
            context.getContexts()[i] = this.fTraces[i].seekLocation(traceLocation);
            context.getContexts()[i].setRank(traceRank);
            rank += traceRank;
            ((TmfLocationArray)expLocation.getLocation()).locations[i] = context.getContexts()[i].getLocation().clone();
            context.getEvents()[i] = this.fTraces[i].getNextEvent(context.getContexts()[i]);
            ++i;
        }
        context.setLocation(expLocation);
        context.setLastTrace(-1);
        context.setRank(rank);
        this.fExperimentContext = context;
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TmfExperimentContext seekEvent(ITmfTimestamp timestamp) {
        ITmfLocation<?> location;
        int index;
        if (timestamp == null) {
            timestamp = TmfTimestamp.BIG_BANG;
        }
        if ((index = Collections.binarySearch(this.fCheckpoints, new TmfCheckpoint(timestamp, null))) < 0) {
            index = Math.max(0, -(index + 2));
        }
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() > 0) {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            } else {
                location = null;
            }
        }
        TmfContext context = this.seekLocation((ITmfLocation)location);
        context.setRank((long)index * (long)this.fIndexPageSize);
        ITmfEvent event = this.parseEvent(context);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            this.getNextEvent(context);
            event = this.parseEvent(context);
        }
        if (event == null) {
            context.setLocation((ITmfLocation<? extends Comparable<?>>)null);
            context.setRank(-2L);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TmfExperimentContext seekEvent(long rank) {
        ITmfLocation<?> location;
        int index = (int)rank / this.fIndexPageSize;
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() == 0) {
                location = null;
            } else {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            }
        }
        TmfContext context = this.seekLocation((ITmfLocation)location);
        context.setRank((long)index * (long)this.fIndexPageSize);
        ITmfEvent event = this.parseEvent(context);
        long pos = context.getRank();
        while (event != null && pos++ < rank) {
            this.getNextEvent(context);
            event = this.parseEvent(context);
        }
        if (event == null) {
            context.setLocation((ITmfLocation<? extends Comparable<?>>)null);
            context.setRank(-2L);
        }
        return context;
    }

    @Override
    public TmfContext seekLocation(double ratio) {
        TmfExperimentContext context = this.seekEvent((long)(ratio * (double)this.getNbEvents()));
        return context;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        if (location instanceof TmfExperimentLocation) {
            return (double)this.seekLocation((ITmfLocation)location).getRank() / (double)this.getNbEvents();
        }
        return 0.0;
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        if (this.fExperimentContext != null) {
            return this.fExperimentContext.getLocation();
        }
        return null;
    }

    @Override
    public synchronized ITmfEvent getNextEvent(ITmfContext context) {
        ITmfEvent[] eventArray;
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals(this.fExperimentContext)) {
            this.fExperimentContext = this.seekLocation((ITmfLocation)context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            TmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = expContext.getTraces()[lastTrace].getNextEvent(traceContext);
            expContext.setLastTrace(-1);
        }
        if ((eventArray = expContext.getEvents()) == null) {
            return null;
        }
        int trace = -1;
        ITmfTimestamp timestamp = TmfTimestamp.BIG_CRUNCH;
        if (eventArray.length == 1) {
            if (eventArray[0] != null) {
                timestamp = eventArray[0].getTimestamp();
                trace = 0;
            }
        } else {
            int i = 0;
            while (i < eventArray.length) {
                ITmfTimestamp otherTS;
                ITmfEvent event = eventArray[i];
                if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                    trace = i;
                    timestamp = otherTS;
                }
                ++i;
            }
        }
        ITmfEvent event = null;
        if (trace != -1) {
            this.updateIndex(expContext, timestamp);
            TmfContext traceContext = expContext.getContexts()[trace];
            TmfExperimentLocation expLocation = (TmfExperimentLocation)expContext.getLocation();
            ((TmfLocationArray)expLocation.getLocation()).locations[trace] = traceContext.getLocation().clone();
            expLocation.getRanks()[trace] = traceContext.getRank();
            expContext.setLastTrace(trace);
            expContext.updateRank(1);
            event = expContext.getEvents()[trace];
            this.fExperimentContext = expContext;
        }
        return event;
    }

    public synchronized void updateIndex(ITmfContext context, ITmfTimestamp timestamp) {
        long rank = context.getRank();
        if (context.isValidRank() && rank % (long)this.fIndexPageSize == 0L) {
            long position = rank / (long)this.fIndexPageSize;
            if ((long)this.fCheckpoints.size() == position) {
                ITmfLocation<? extends Comparable> location = context.getLocation().clone();
                this.fCheckpoints.add(new TmfCheckpoint(timestamp.clone(), location));
            }
        }
    }

    @Override
    public ITmfEvent parseEvent(ITmfContext context) {
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals(this.fExperimentContext)) {
            this.seekLocation((ITmfLocation)context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            TmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = expContext.getTraces()[lastTrace].getNextEvent(traceContext);
            expContext.setLastTrace(-1);
            this.fExperimentContext = (TmfExperimentContext)context;
        }
        int trace = -1;
        ITmfTimestamp timestamp = TmfTimestamp.BIG_CRUNCH;
        int i = 0;
        while (i < expContext.getTraces().length) {
            ITmfTimestamp otherTS;
            ITmfEvent event = expContext.getEvents()[i];
            if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                trace = i;
                timestamp = otherTS;
            }
            ++i;
        }
        ITmfEvent event = null;
        if (trace != -1) {
            event = expContext.getEvents()[trace];
        }
        return event;
    }

    public String toString() {
        return "[TmfExperiment (" + this.getName() + ")]";
    }

    private synchronized void initializeStreamingMonitor() {
        if (this.fInitialized) {
            return;
        }
        this.fInitialized = true;
        if (this.getStreamingInterval() == 0L) {
            TmfContext context = this.seekLocation((ITmfLocation)null);
            T event = this.getNext(context);
            if (event == null) {
                return;
            }
            TmfTimeRange timeRange = new TmfTimeRange(event.getTimestamp().clone(), TmfTimestamp.BIG_CRUNCH);
            final TmfExperimentRangeUpdatedSignal signal = new TmfExperimentRangeUpdatedSignal(this, this, timeRange);
            new Thread(){

                @Override
                public void run() {
                    TmfExperiment.this.broadcast(signal);
                }
            }.start();
            return;
        }
        Thread thread = new Thread("Streaming Monitor for experiment " + this.getName()){
            ITmfTimestamp safeTimestamp;
            TmfTimeRange timeRange;
            {
                this.safeTimestamp = null;
                this.timeRange = null;
            }

            @Override
            public void run() {
                while (!TmfExperiment.this.fExecutor.isShutdown()) {
                    if (!TmfExperiment.this.isIndexingBusy()) {
                        ITmfTimestamp startTimestamp = TmfTimestamp.BIG_CRUNCH;
                        ITmfTimestamp endTimestamp = TmfTimestamp.BIG_BANG;
                        ITmfTrace<T>[] iTmfTraceArray = TmfExperiment.this.fTraces;
                        int n = TmfExperiment.this.fTraces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITmfTrace trace = iTmfTraceArray[n2];
                            if (trace.getStartTime().compareTo(startTimestamp) < 0) {
                                startTimestamp = trace.getStartTime();
                            }
                            if (trace.getStreamingInterval() != 0L && trace.getEndTime().compareTo(endTimestamp) > 0) {
                                endTimestamp = trace.getEndTime();
                            }
                            ++n2;
                        }
                        this.timeRange = this.safeTimestamp != null && this.safeTimestamp.compareTo(TmfExperiment.this.getTimeRange().getEndTime(), false) > 0 ? new TmfTimeRange(startTimestamp, this.safeTimestamp) : null;
                        this.safeTimestamp = endTimestamp;
                        if (this.timeRange != null) {
                            TmfExperimentRangeUpdatedSignal signal = new TmfExperimentRangeUpdatedSignal(TmfExperiment.this, TmfExperiment.this, this.timeRange);
                            TmfExperiment.this.broadcast(signal);
                        }
                    }
                    try {
                        Thread.sleep(TmfExperiment.this.getStreamingInterval());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        thread.start();
    }

    @Override
    public long getStreamingInterval() {
        long interval = 0L;
        ITmfTrace<T>[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace<T> trace = iTmfTraceArray[n2];
            interval = Math.max(interval, trace.getStreamingInterval());
            ++n2;
        }
        return interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isIndexingBusy() {
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            return this.fIndexing;
        }
    }

    protected void indexExperiment(boolean waitForCompletion) {
        this.indexExperiment(waitForCompletion, 0, TmfTimeRange.ETERNITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexExperiment(boolean waitForCompletion, int index, TmfTimeRange timeRange) {
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fIndexing) {
                return;
            }
            this.fIndexing = true;
        }
        final Job job = new Job("Indexing " + this.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        TmfEventRequest<ITmfEvent> request = new TmfEventRequest<ITmfEvent>(ITmfEvent.class, timeRange, index, Integer.MAX_VALUE, this.fIndexPageSize, ITmfDataRequest.ExecutionType.BACKGROUND){
            ITmfTimestamp startTime;
            ITmfTimestamp lastTime;
            long initialNbEvents;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.startTime = TmfExperiment.this.fTimeRange == TmfTimeRange.NULL_RANGE ? null : TmfExperiment.this.fTimeRange.getStartTime();
                this.lastTime = TmfExperiment.this.fTimeRange == TmfTimeRange.NULL_RANGE ? null : TmfExperiment.this.fTimeRange.getEndTime();
                this.initialNbEvents = TmfExperiment.this.fNbEvents;
            }

            @Override
            public void handleStarted() {
                super.handleStarted();
            }

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (event != null) {
                    ITmfTimestamp ts = event.getTimestamp();
                    if (this.startTime == null) {
                        this.startTime = ts.clone();
                    }
                    this.lastTime = ts.clone();
                    if (this.getNbRead() % TmfExperiment.this.fIndexPageSize == 1 && this.getNbRead() != 1) {
                        this.updateExperiment();
                    }
                }
            }

            @Override
            public void handleSuccess() {
                if (this.getRange().getEndTime() != TmfTimestamp.BIG_CRUNCH) {
                    this.lastTime = this.getRange().getEndTime();
                }
                this.updateExperiment();
                super.handleSuccess();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
                Vector<TmfCheckpoint> vector = TmfExperiment.this.fCheckpoints;
                synchronized (vector) {
                    TmfExperiment.this.fIndexing = false;
                    if (TmfExperiment.this.fIndexingPendingRange != TmfTimeRange.NULL_RANGE) {
                        TmfExperiment.this.indexExperiment(false, (int)TmfExperiment.this.fNbEvents, TmfExperiment.this.fIndexingPendingRange);
                        TmfExperiment.this.fIndexingPendingRange = TmfTimeRange.NULL_RANGE;
                    }
                }
            }

            private void updateExperiment() {
                int nbRead = this.getNbRead();
                if (this.startTime != null) {
                    TmfExperiment.this.fTimeRange = new TmfTimeRange(this.startTime, this.lastTime.clone());
                }
                if (nbRead != 0) {
                    TmfExperiment.this.fNbEvents = this.initialNbEvents + (long)nbRead;
                    TmfExperiment.this.notifyListeners();
                }
            }
        };
        this.sendRequest(request);
        if (waitForCompletion) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void notifyListeners() {
        this.broadcast(new TmfExperimentUpdatedSignal((Object)this, this));
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<T> signal) {
        TmfExperiment<ITmfEvent> experiment = signal.getExperiment();
        if (experiment == this) {
            TmfExperiment.setCurrentExperiment(experiment);
            this.fEndSynchReference = signal.getReference();
        }
    }

    @TmfSignalHandler
    public void endSync(TmfEndSynchSignal signal) {
        if (this.fEndSynchReference != null && this.fEndSynchReference.intValue() == signal.getReference()) {
            this.fEndSynchReference = null;
            this.initializeStreamingMonitor();
        }
    }

    @TmfSignalHandler
    public void experimentUpdated(TmfExperimentUpdatedSignal signal) {
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        if (signal.getExperiment() == this) {
            this.indexExperiment(false, (int)this.fNbEvents, signal.getRange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        ITmfTrace<T>[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace<T> trace = iTmfTraceArray[n2];
            if (trace == signal.getTrace()) {
                Vector<TmfCheckpoint> vector = this.fCheckpoints;
                synchronized (vector) {
                    if (this.fIndexing) {
                        if (this.fIndexingPendingRange == TmfTimeRange.NULL_RANGE) {
                            this.fIndexingPendingRange = signal.getRange();
                        } else {
                            ITmfTimestamp startTime = this.fIndexingPendingRange.getStartTime();
                            ITmfTimestamp endTime = this.fIndexingPendingRange.getEndTime();
                            if (signal.getRange().getStartTime().compareTo(startTime) < 0) {
                                startTime = signal.getRange().getStartTime();
                            }
                            if (signal.getRange().getEndTime().compareTo(endTime) > 0) {
                                endTime = signal.getRange().getEndTime();
                            }
                            this.fIndexingPendingRange = new TmfTimeRange(startTime, endTime);
                        }
                        return;
                    }
                }
                this.indexExperiment(false, (int)this.fNbEvents, signal.getRange());
                return;
            }
            ++n2;
        }
    }

    @Override
    public String getPath() {
        return null;
    }

    public void setBookmarksFile(IFile file) {
        this.fBookmarksFile = file;
    }

    public IFile getBookmarksFile() {
        return this.fBookmarksFile;
    }

    @Override
    public void setResource(IResource resource) {
        this.fResource = resource;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }
}

