/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import java.util.HashMap;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;

public final class TmfEventTypeManager {
    private static TmfEventTypeManager fEventTypeManager = null;
    private HashMap<String, HashMap<String, ITmfEventType>> fEventTypes = new HashMap();

    private TmfEventTypeManager() {
    }

    public static synchronized TmfEventTypeManager getInstance() {
        if (fEventTypeManager == null) {
            fEventTypeManager = new TmfEventTypeManager();
        }
        return fEventTypeManager;
    }

    public synchronized void add(String context, ITmfEventType type) {
        HashMap<String, ITmfEventType> types = this.fEventTypes.get(context);
        if (types == null) {
            types = new HashMap();
        }
        types.put(type.getName(), type);
        this.fEventTypes.put(context, types);
    }

    public synchronized String[] getContexts() {
        return this.fEventTypes.keySet().toArray(new String[this.fEventTypes.size()]);
    }

    public synchronized ITmfEventType[] getTypes(String context) {
        HashMap<String, ITmfEventType> types = this.fEventTypes.get(context);
        if (types != null) {
            return types.values().toArray(new ITmfEventType[types.size()]);
        }
        return null;
    }

    public synchronized ITmfEventType getType(String context, String typeId) {
        HashMap<String, ITmfEventType> types = this.fEventTypes.get(context);
        if (types != null) {
            return types.get(typeId);
        }
        return null;
    }

    public synchronized void clear(String context) {
        this.fEventTypes.remove(context);
    }

    public synchronized void clear() {
        this.fEventTypes.clear();
    }

    public String toString() {
        return "TmfEventTypeManager [fEventTypes=" + this.fEventTypes + "]";
    }
}

