/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;

public final class TmfTimeRange
implements Cloneable {
    public static final TmfTimeRange ETERNITY = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
    public static final TmfTimeRange NULL_RANGE = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_BANG);
    private ITmfTimestamp fStartTime;
    private ITmfTimestamp fEndTime;

    private TmfTimeRange() {
    }

    public TmfTimeRange(ITmfTimestamp startTime, ITmfTimestamp endTime) {
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException();
        }
        this.fStartTime = startTime;
        this.fEndTime = endTime;
    }

    public TmfTimeRange(TmfTimeRange range) {
        if (range == null) {
            throw new IllegalArgumentException();
        }
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    public boolean contains(ITmfTimestamp ts) {
        if (ts.equals(TmfTimestamp.ZERO)) {
            return true;
        }
        return this.fStartTime.compareTo(ts, true) <= 0 && this.fEndTime.compareTo(ts, true) >= 0;
    }

    public boolean contains(TmfTimeRange range) {
        ITmfTimestamp startTime = range.getStartTime();
        ITmfTimestamp endTime = range.getEndTime();
        return this.fStartTime.compareTo(startTime, true) <= 0 && this.fEndTime.compareTo(endTime, true) >= 0;
    }

    public TmfTimeRange getIntersection(TmfTimeRange range) {
        if (this.fStartTime.compareTo(range.fEndTime, true) > 0 || this.fEndTime.compareTo(range.fStartTime, true) < 0) {
            return null;
        }
        return new TmfTimeRange(this.fStartTime.compareTo(range.fStartTime, true) < 0 ? range.fStartTime : this.fStartTime, this.fEndTime.compareTo(range.fEndTime, true) > 0 ? range.fEndTime : this.fEndTime);
    }

    public TmfTimeRange clone() throws CloneNotSupportedException {
        TmfTimeRange clone = null;
        try {
            clone = (TmfTimeRange)super.clone();
            clone.fStartTime = this.fStartTime.clone();
            clone.fEndTime = this.fEndTime.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fEndTime.hashCode();
        result = 31 * result + this.fStartTime.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfTimeRange)) {
            return false;
        }
        TmfTimeRange other = (TmfTimeRange)obj;
        if (!this.fEndTime.equals(other.fEndTime)) {
            return false;
        }
        return this.fStartTime.equals(other.fStartTime);
    }

    public String toString() {
        return "TmfTimeRange [fStartTime=" + this.fStartTime + ", fEndTime=" + this.fEndTime + "]";
    }
}

