/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.graphicalrun.actions;

import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.LoggedCommand2;
import org.eclipse.linuxtools.systemtap.ui.consolelog.actions.ConsoleAction;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.graphicalrun.structures.ChartStreamDaemon2;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingConstants;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingPerspective;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.ChartStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.linuxtools.systemtap.ui.ide.IDEPerspective;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IGobblerListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ModifyParsingAction
extends ConsoleAction
implements IWorkbenchWindowActionDelegate {
    public void run() {
        DataSetWizard wizard = new DataSetWizard(GraphingConstants.DataSetMetaData, this.getFilePath());
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, null);
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        IDataSetParser parser = wizard.getParser();
        IDataSet dataSet = wizard.getDataSet();
        if (parser != null && dataSet != null) {
            ScriptConsole console = super.getActive();
            LoggedCommand2 cmd = console.getCommand();
            ArrayList listeners = cmd.getInputStreamListeners();
            ChartStreamDaemon2 daemon = null;
            if (listeners != null) {
                int i = 0;
                while (i < listeners.size()) {
                    if (listeners.get(i) instanceof ChartStreamDaemon) {
                        daemon = (ChartStreamDaemon2)((Object)listeners.get(i));
                        break;
                    }
                    ++i;
                }
            }
            if (daemon == null) {
                daemon = new ChartStreamDaemon2(console, dataSet, parser);
                cmd.addInputStreamListener((IGobblerListener)daemon);
            } else {
                daemon.setParser(dataSet, parser);
            }
            IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
            GraphSelectorView graphSelector = (GraphSelectorView)ivp;
            String name = console.getName();
            graphSelector.createScriptSet(name.substring(name.lastIndexOf(47) + 1), dataSet);
        }
        wizard.dispose();
    }

    private String getFilePath() {
        try {
            IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(IDEPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            IEditorPart ed = p.getActiveEditor();
            PlatformUI.getWorkbench().showPerspective(GraphingPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            return ((PathEditorInput)ed.getEditorInput()).getPath().toString();
        }
        catch (WorkbenchException workbenchException) {
            return null;
        }
    }
}

