/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.valgrind.core.LaunchConfigurationConstants;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.osgi.framework.Version;

public class ValgrindOptionsTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    protected Button traceChildrenButton;
    protected Button childSilentButton;
    protected Button runFreeresButton;
    protected Button demangleButton;
    protected Spinner numCallersSpinner;
    protected Button errorLimitButton;
    protected Button showBelowMainButton;
    protected Spinner maxStackFrameSpinner;
    protected Button mainStackSizeButton;
    protected Spinner mainStackSizeSpinner;
    protected Button dSymUtilButton;
    protected org.eclipse.swt.widgets.List suppFileList;
    protected String tool;
    protected String[] tools;
    protected Composite top;
    protected Composite mainStackSizeTop;
    protected ScrolledComposite scrollTop;
    protected Combo toolsCombo;
    protected TabFolder optionsFolder;
    protected TabItem toolTab;
    protected ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy;
    protected ILaunchConfiguration launchConfiguration;
    protected IValgrindToolPage dynamicTab;
    protected Composite dynamicTabHolder;
    protected boolean isInitializing = false;
    protected boolean initDefaults = false;
    protected Exception ex;
    private Version valgrindVersion;
    private boolean checkVersion;
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };

    public ValgrindOptionsTab() {
        this(true);
    }

    public ValgrindOptionsTab(boolean checkVersion) {
        this.checkVersion = checkVersion;
    }

    public void setValgrindVersion(Version v) {
        this.valgrindVersion = v;
    }

    public Version getValgrindVersion() {
        return this.valgrindVersion;
    }

    public void createControl(Composite parent) {
        if (this.ex != null) {
            this.setErrorMessage(this.ex.getLocalizedMessage());
        }
        this.scrollTop = new ScrolledComposite(parent, 768);
        this.scrollTop.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrollTop.setExpandVertical(true);
        this.scrollTop.setExpandHorizontal(true);
        this.setControl((Control)this.scrollTop);
        this.top = new Composite((Composite)this.scrollTop, 0);
        this.top.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(this.top, 1);
        this.createToolCombo(this.top);
        this.createVerticalSpacer(this.top, 1);
        this.optionsFolder = new TabFolder(this.top, 2048);
        this.optionsFolder.setLayoutData((Object)new GridData(1808));
        TabItem generalTab = new TabItem(this.optionsFolder, 0);
        generalTab.setText(Messages.getString("ValgrindOptionsTab.General"));
        Composite generalTop = new Composite((Composite)this.optionsFolder, 0);
        generalTop.setLayout((Layout)new GridLayout());
        generalTop.setLayoutData((Object)new GridData(1808));
        this.createBasicOptions(generalTop);
        this.createVerticalSpacer(generalTop, 1);
        this.createErrorOptions(generalTop);
        generalTab.setControl((Control)generalTop);
        TabItem suppTab = new TabItem(this.optionsFolder, 0);
        suppTab.setText(Messages.getString("ValgrindOptionsTab.Suppressions"));
        Composite suppTop = new Composite((Composite)this.optionsFolder, 0);
        suppTop.setLayout((Layout)new GridLayout());
        suppTop.setLayoutData((Object)new GridData(1808));
        this.createSuppressionsOption(suppTop);
        suppTab.setControl((Control)suppTop);
        this.toolTab = new TabItem(this.optionsFolder, 0);
        this.toolTab.setText(Messages.getString("ValgrindOptionsTab.Tool"));
        this.dynamicTabHolder = new Composite((Composite)this.optionsFolder, 0);
        this.dynamicTabHolder.setLayout((Layout)new GridLayout());
        this.dynamicTabHolder.setLayoutData((Object)new GridData(1808));
        this.toolTab.setControl((Control)this.dynamicTabHolder);
        this.scrollTop.setContent((Control)this.top);
        this.recomputeSize();
    }

    protected void recomputeSize() {
        Point point = this.top.computeSize(-1, -1);
        this.top.setSize(point);
        this.scrollTop.setMinSize(point);
    }

    private void createToolCombo(Composite top) {
        Composite comboTop = new Composite(top, 0);
        comboTop.setLayout((Layout)new GridLayout(2, false));
        Label toolLabel = new Label(comboTop, 0);
        toolLabel.setText(Messages.getString("ValgrindOptionsTab.Tool_to_run"));
        this.toolsCombo = new Combo(comboTop, 8);
        this.tools = this.getPlugin().getRegisteredToolIDs();
        String[] names = new String[this.tools.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.capitalize(this.getPlugin().getToolName(this.tools[i]));
            ++i;
        }
        this.toolsCombo.setItems(names);
        this.toolsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ValgrindOptionsTab.this.isInitializing) {
                    ValgrindOptionsTab.this.initDefaults = true;
                    int ix = ValgrindOptionsTab.this.toolsCombo.getSelectionIndex();
                    ValgrindOptionsTab.this.tool = ValgrindOptionsTab.this.tools[ix];
                    ValgrindOptionsTab.this.handleToolChanged();
                    ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    private String capitalize(String str) {
        if (str.length() > 0) {
            char[] buf = str.toCharArray();
            buf[0] = Character.toUpperCase(buf[0]);
            str = String.valueOf(buf);
        }
        return str;
    }

    protected void createBasicOptions(Composite top) {
        Group basicGroup = new Group(top, 0);
        basicGroup.setLayout((Layout)new GridLayout());
        basicGroup.setLayoutData((Object)new GridData(768));
        basicGroup.setText(Messages.getString("ValgrindOptionsTab.Basic_Options"));
        Composite basicTop = new Composite((Composite)basicGroup, 0);
        basicTop.setLayout((Layout)new GridLayout(2, true));
        basicTop.setLayoutData((Object)new GridData(768));
        this.traceChildrenButton = new Button(basicTop, 32);
        this.traceChildrenButton.setText(Messages.getString("ValgrindOptionsTab.trace_children"));
        this.traceChildrenButton.addSelectionListener(this.selectListener);
        this.traceChildrenButton.setLayoutData((Object)new GridData(768));
        this.childSilentButton = new Button(basicTop, 32);
        this.childSilentButton.setText(Messages.getString("ValgrindOptionsTab.child_silent"));
        this.childSilentButton.setSelection(true);
        this.childSilentButton.setEnabled(false);
        this.childSilentButton.setLayoutData((Object)new GridData(768));
        this.runFreeresButton = new Button(basicTop, 32);
        this.runFreeresButton.setText(Messages.getString("ValgrindOptionsTab.run_freeres"));
        this.runFreeresButton.addSelectionListener(this.selectListener);
        this.runFreeresButton.setLayoutData((Object)new GridData(768));
    }

    protected void createErrorOptions(Composite top) {
        Group errorGroup = new Group(top, 0);
        errorGroup.setLayout((Layout)new GridLayout());
        errorGroup.setLayoutData((Object)new GridData(768));
        errorGroup.setText(Messages.getString("ValgrindOptionsTab.Error_Options"));
        Composite errorTop = new Composite((Composite)errorGroup, 0);
        errorTop.setLayout((Layout)new GridLayout(2, true));
        errorTop.setLayoutData((Object)new GridData(768));
        this.demangleButton = new Button(errorTop, 32);
        this.demangleButton.setText(Messages.getString("ValgrindOptionsTab.demangle"));
        this.demangleButton.addSelectionListener(this.selectListener);
        this.demangleButton.setLayoutData((Object)new GridData(768));
        Composite numCallersTop = new Composite(errorTop, 0);
        numCallersTop.setLayout((Layout)new GridLayout(2, false));
        Label numCallersLabel = new Label(numCallersTop, 0);
        numCallersLabel.setText(Messages.getString("ValgrindOptionsTab.num_callers"));
        this.numCallersSpinner = new Spinner(numCallersTop, 2048);
        this.numCallersSpinner.setMaximum(50);
        this.numCallersSpinner.addModifyListener(this.modifyListener);
        this.numCallersSpinner.setLayoutData((Object)new GridData(768));
        this.errorLimitButton = new Button(errorTop, 32);
        this.errorLimitButton.setText(Messages.getString("ValgrindOptionsTab.limit_errors"));
        this.errorLimitButton.addSelectionListener(this.selectListener);
        this.errorLimitButton.setLayoutData((Object)new GridData(768));
        this.showBelowMainButton = new Button(errorTop, 32);
        this.showBelowMainButton.setText(Messages.getString("ValgrindOptionsTab.show_errors_below_main"));
        this.showBelowMainButton.addSelectionListener(this.selectListener);
        this.showBelowMainButton.setLayoutData((Object)new GridData(768));
        Composite maxStackFrameTop = new Composite(errorTop, 0);
        maxStackFrameTop.setLayout((Layout)new GridLayout(2, false));
        Label maxStackFrameLabel = new Label(maxStackFrameTop, 0);
        maxStackFrameLabel.setText(Messages.getString("ValgrindOptionsTab.max_size_of_stack_frame"));
        this.maxStackFrameSpinner = new Spinner(maxStackFrameTop, 2048);
        this.maxStackFrameSpinner.setMaximum(Integer.MAX_VALUE);
        this.maxStackFrameSpinner.addModifyListener(this.modifyListener);
        this.maxStackFrameSpinner.setLayoutData((Object)new GridData(768));
        this.mainStackSizeTop = new Composite(errorTop, 0);
        GridLayout mainStackSizeLayout = new GridLayout(2, false);
        mainStackSizeLayout.marginWidth = 0;
        mainStackSizeLayout.marginHeight = 0;
        this.mainStackSizeTop.setLayout((Layout)mainStackSizeLayout);
        this.mainStackSizeButton = new Button(this.mainStackSizeTop, 32);
        this.mainStackSizeButton.setText(Messages.getString("ValgrindOptionsTab.Main_stack_size"));
        this.mainStackSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValgrindOptionsTab.this.checkMainStackEnablement();
                ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mainStackSizeSpinner = new Spinner(this.mainStackSizeTop, 2048);
        this.mainStackSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.mainStackSizeSpinner.addModifyListener(this.modifyListener);
        this.mainStackSizeSpinner.setLayoutData((Object)new GridData(768));
        this.mainStackSizeTop.setVisible(false);
        this.dSymUtilButton = new Button(errorTop, 32);
        this.dSymUtilButton.setText(Messages.getString("ValgrindOptionsTab.dsymutil"));
        this.dSymUtilButton.addSelectionListener(this.selectListener);
        this.dSymUtilButton.setLayoutData((Object)new GridData(768));
        this.dSymUtilButton.setVisible(false);
    }

    private void updateErrorOptions() {
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_4_0) >= 0) {
            this.mainStackSizeTop.setVisible(true);
        } else {
            this.mainStackSizeTop.setVisible(false);
        }
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_6_0) >= 0) {
            this.dSymUtilButton.setVisible(true);
        } else {
            this.dSymUtilButton.setVisible(false);
        }
    }

    protected void createSuppressionsOption(Composite top) {
        Composite browseTop = new Composite(top, 2048);
        browseTop.setLayout((Layout)new GridLayout(2, false));
        GridData browseData = new GridData(1808);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("ValgrindOptionsTab.suppressions_file"));
        this.createVerticalSpacer(browseTop, 1);
        this.suppFileList = new org.eclipse.swt.widgets.List(browseTop, 2048);
        this.suppFileList.setLayoutData((Object)new GridData(1808));
        Composite buttonTop = new Composite(browseTop, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonTop.setLayout((Layout)buttonLayout);
        buttonTop.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        Button workspaceBrowseButton = this.createPushButton(buttonTop, Messages.getString("ValgrindOptionsTab.Workspace"), null);
        workspaceBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(ValgrindOptionsTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.getString("ValgrindOptionsTab.Select_a_Resource"));
                dialog.setMessage(Messages.getString("ValgrindOptionsTab.Select_a_Suppressions_File"));
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                    ValgrindOptionsTab.this.suppFileList.add(fileLoc);
                    ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button fileBrowseButton = this.createPushButton(buttonTop, Messages.getString("ValgrindOptionsTab.File_System"), null);
        fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = null;
                FileDialog dialog = new FileDialog(ValgrindOptionsTab.this.getShell(), 8192);
                filePath = dialog.open();
                if (filePath != null) {
                    ValgrindOptionsTab.this.suppFileList.add(filePath);
                    ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button removeButton = this.createPushButton(buttonTop, Messages.getString("ValgrindOptionsTab.Supp_remove"), null);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selected = ValgrindOptionsTab.this.suppFileList.getSelectionIndices();
                if (selected.length > 0) {
                    ValgrindOptionsTab.this.suppFileList.remove(selected);
                    ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    protected void handleToolChanged() {
        try {
            this.loadDynamicArea();
            if (this.launchConfigurationWorkingCopy == null) {
                this.launchConfigurationWorkingCopy = this.launchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)this.launchConfiguration : this.launchConfiguration.getWorkingCopy();
            }
            if (this.initDefaults) {
                this.dynamicTab.setDefaults(this.launchConfigurationWorkingCopy);
            }
            this.initDefaults = false;
            this.dynamicTab.initializeFrom((ILaunchConfiguration)this.launchConfigurationWorkingCopy);
            this.toolTab.setText(this.dynamicTab.getName());
            this.optionsFolder.layout(true);
            this.recomputeSize();
        }
        catch (CoreException e) {
            this.ex = e;
        }
    }

    private void loadDynamicArea() throws CoreException {
        Control[] controlArray = this.dynamicTabHolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.loadDynamicTab();
        if (this.dynamicTab == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.launch", String.valueOf(Messages.getString("ValgrindOptionsTab.No_options_tab_found")) + this.tool));
        }
        this.dynamicTab.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.dynamicTab.setValgrindVersion(this.valgrindVersion);
        this.dynamicTab.createControl(this.dynamicTabHolder);
        this.dynamicTabHolder.layout(true);
    }

    private void loadDynamicTab() throws CoreException {
        this.dynamicTab = this.getPlugin().getToolPage(this.tool);
    }

    public IValgrindToolPage getDynamicTab() {
        return this.dynamicTab;
    }

    protected ValgrindLaunchPlugin getPlugin() {
        return ValgrindLaunchPlugin.getDefault();
    }

    public String getName() {
        return Messages.getString("ValgrindOptionsTab.Valgrind_Options");
    }

    public Image getImage() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.launch", (String)"icons/valgrind-icon.png").createImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isInitializing = true;
        this.getControl().setRedraw(false);
        this.launchConfiguration = configuration;
        this.launchConfigurationWorkingCopy = null;
        if (this.checkVersion) {
            try {
                IProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)configuration).getProject();
                this.valgrindVersion = this.getPlugin().getValgrindVersion(project);
            }
            catch (CoreException e) {
                this.ex = e;
            }
        }
        this.updateErrorOptions();
        try {
            this.tool = configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.memcheck");
            int select = -1;
            int i = 0;
            while (i < this.tools.length && select < 0) {
                if (this.tool.equals(this.tools[i])) {
                    select = i;
                }
                ++i;
            }
            if (select != -1) {
                this.toolsCombo.select(select);
            }
            this.handleToolChanged();
            this.traceChildrenButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", false));
            this.runFreeresButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", true));
            this.demangleButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", true));
            this.numCallersSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", 12));
            this.errorLimitButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", true));
            this.showBelowMainButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", false));
            this.maxStackFrameSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", 2000000));
            List suppFiles = configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILES", LaunchConfigurationConstants.DEFAULT_GENERAL_SUPPFILES);
            this.suppFileList.setItems(suppFiles.toArray(new String[suppFiles.size()]));
            if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_4_0) >= 0) {
                this.mainStackSizeButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK_BOOL", false));
                this.mainStackSizeSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK", 0));
                this.checkMainStackEnablement();
            }
            if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_6_0) >= 0) {
                this.dSymUtilButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DSYMUTIL", true));
            }
        }
        catch (CoreException e) {
            this.ex = e;
        }
        this.getControl().setRedraw(true);
        this.isInitializing = false;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean result = false;
        if (this.ex != null) {
            this.setErrorMessage(this.ex.getLocalizedMessage());
        } else {
            result = this.isGeneralValid() && this.dynamicTab != null;
            if (result) {
                result = this.dynamicTab.isValid(launchConfig);
                this.setErrorMessage(this.dynamicTab.getErrorMessage());
            }
        }
        return result;
    }

    private boolean isGeneralValid() {
        String[] suppFiles = this.suppFileList.getItems();
        boolean result = true;
        int i = 0;
        while (i < suppFiles.length && result) {
            try {
                IPath suppfile = this.getPlugin().parseWSPath(suppFiles[i]);
                if (!suppfile.toFile().exists()) {
                    this.setErrorMessage(NLS.bind((String)Messages.getString("ValgrindOptionsTab.suppressions_file_doesnt_exist"), (Object)suppFiles[i]));
                    result = false;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", this.tool);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", this.traceChildrenButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", this.runFreeresButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", this.demangleButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", this.numCallersSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", this.errorLimitButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", this.showBelowMainButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", this.maxStackFrameSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILES", Arrays.asList(this.suppFileList.getItems()));
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_4_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK_BOOL", this.mainStackSizeButton.getSelection());
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK", this.mainStackSizeSpinner.getSelection());
        }
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_6_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DSYMUTIL", this.dSymUtilButton.getSelection());
        }
        if (this.dynamicTab != null) {
            this.dynamicTab.performApply(configuration);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfigurationWorkingCopy = configuration;
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.memcheck");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", 12);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", 2000000);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILES", LaunchConfigurationConstants.DEFAULT_GENERAL_SUPPFILES);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_4_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK_BOOL", false);
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK", 0);
        }
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_6_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DSYMUTIL", true);
        }
        if (this.dynamicTab != null) {
            this.dynamicTab.setDefaults(configuration);
            this.initDefaults = false;
        }
    }

    public void dispose() {
        if (this.dynamicTab != null) {
            this.dynamicTab.dispose();
        }
        super.dispose();
    }

    protected void createHorizontalSpacer(Composite comp, int numlines) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numlines;
        lbl.setLayoutData((Object)gd);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    private void checkMainStackEnablement() {
        this.mainStackSizeSpinner.setEnabled(this.mainStackSizeButton.getSelection());
    }

    public Button getTraceChildrenButton() {
        return this.traceChildrenButton;
    }

    public Button getChildSilentButton() {
        return this.childSilentButton;
    }

    public Button getRunFreeresButton() {
        return this.runFreeresButton;
    }

    public Button getDemangleButton() {
        return this.demangleButton;
    }

    public Spinner getNumCallersSpinner() {
        return this.numCallersSpinner;
    }

    public Button getErrorLimitButton() {
        return this.errorLimitButton;
    }

    public Button getShowBelowMainButton() {
        return this.showBelowMainButton;
    }

    public Spinner getMaxStackFrameSpinner() {
        return this.maxStackFrameSpinner;
    }

    public Button getMainStackSizeButton() {
        return this.mainStackSizeButton;
    }

    public Spinner getMainStackSizeSpinner() {
        return this.mainStackSizeSpinner;
    }

    public org.eclipse.swt.widgets.List getSuppFileList() {
        return this.suppFileList;
    }

    public Combo getToolsCombo() {
        return this.toolsCombo;
    }

    public String[] getTools() {
        return this.tools;
    }
}

