/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree.CoreNode;
import org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree.HTInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree.HistoryTree;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

abstract class HTNode {
    protected final HistoryTree ownerTree;
    private final long nodeStart;
    private long nodeEnd;
    private final int sequenceNumber;
    private int parentSequenceNumber;
    private int stringSectionOffset;
    private boolean isDone;
    private final ArrayList<HTInterval> intervals;

    HTNode(HistoryTree tree, int seqNumber, int parentSeqNumber, long start) {
        this.ownerTree = tree;
        this.nodeStart = start;
        this.sequenceNumber = seqNumber;
        this.parentSequenceNumber = parentSeqNumber;
        this.stringSectionOffset = this.ownerTree.config.blockSize;
        this.isDone = false;
        this.intervals = new ArrayList();
    }

    static final HTNode readNode(HistoryTree tree, FileChannel fc) throws IOException {
        CoreNode newNode = null;
        ByteBuffer buffer = ByteBuffer.allocate(tree.config.blockSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.clear();
        int res = fc.read(buffer);
        assert (res == tree.config.blockSize);
        buffer.flip();
        byte type = buffer.get();
        long start = buffer.getLong();
        long end = buffer.getLong();
        int seqNb = buffer.getInt();
        int parentSeqNb = buffer.getInt();
        int intervalCount = buffer.getInt();
        int stringSectionOffset = buffer.getInt();
        boolean done = HTNode.byteToBool(buffer.get());
        switch (type) {
            case 1: {
                newNode = new CoreNode(tree, seqNb, parentSeqNb, start);
                ((HTNode)newNode).readSpecificHeader(buffer);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        int i = 0;
        while (i < intervalCount) {
            newNode.intervals.add(HTInterval.readFrom(buffer));
            ++i;
        }
        newNode.nodeEnd = end;
        newNode.stringSectionOffset = stringSectionOffset;
        newNode.isDone = done;
        return newNode;
    }

    final void writeSelf(FileChannel fc) throws IOException {
        int curStringsEntryEndPos = this.ownerTree.config.blockSize;
        ByteBuffer buffer = ByteBuffer.allocate(this.ownerTree.config.blockSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.clear();
        buffer.put(this.getNodeType());
        buffer.putLong(this.nodeStart);
        buffer.putLong(this.nodeEnd);
        buffer.putInt(this.sequenceNumber);
        buffer.putInt(this.parentSequenceNumber);
        buffer.putInt(this.intervals.size());
        buffer.putInt(this.stringSectionOffset);
        buffer.put(HTNode.boolToByte(this.isDone));
        this.writeSpecificHeader(buffer);
        for (HTInterval interval : this.intervals) {
            int size = interval.writeInterval(buffer, curStringsEntryEndPos);
            curStringsEntryEndPos -= size;
        }
        while (buffer.position() < this.stringSectionOffset) {
            buffer.put((byte)0);
        }
        assert (curStringsEntryEndPos == this.stringSectionOffset);
        buffer.position(this.ownerTree.config.blockSize);
        buffer.flip();
        int res = fc.write(buffer);
        assert (res == this.ownerTree.config.blockSize);
    }

    long getNodeStart() {
        return this.nodeStart;
    }

    long getNodeEnd() {
        if (this.isDone) {
            return this.nodeEnd;
        }
        return 0L;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    int getParentSequenceNumber() {
        return this.parentSequenceNumber;
    }

    void setParentSequenceNumber(int newParent) {
        this.parentSequenceNumber = newParent;
    }

    boolean isDone() {
        return this.isDone;
    }

    void addInterval(HTInterval newInterval) {
        assert (newInterval.getIntervalSize() <= this.getNodeFreeSpace());
        this.intervals.add(newInterval);
        this.stringSectionOffset -= newInterval.getStringsEntrySize();
    }

    void closeThisNode(long endtime) {
        assert (endtime >= this.nodeStart);
        if (this.intervals.size() > 0) {
            Collections.sort(this.intervals);
            assert (endtime >= this.intervals.get(this.intervals.size() - 1).getEndTime());
        }
        this.isDone = true;
        this.nodeEnd = endtime;
    }

    void writeInfoFromNode(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException {
        int startIndex;
        assert (this.isDone);
        if (this.intervals.size() == 0) {
            return;
        }
        int i = startIndex = this.getStartIndexFor(t);
        while (i < this.intervals.size()) {
            if (this.intervals.get(i).getStartTime() <= t) {
                stateInfo.set(this.intervals.get(i).getAttribute(), this.intervals.get(i));
            }
            ++i;
        }
    }

    HTInterval getRelevantInterval(int key, long t) throws TimeRangeException {
        int startIndex;
        assert (this.isDone);
        if (this.intervals.size() == 0) {
            return null;
        }
        int i = startIndex = this.getStartIndexFor(t);
        while (i < this.intervals.size()) {
            HTInterval curInterval = this.intervals.get(i);
            if (curInterval.getAttribute() == key && curInterval.getStartTime() <= t && curInterval.getEndTime() >= t) {
                return curInterval;
            }
            ++i;
        }
        return null;
    }

    private int getStartIndexFor(long t) throws TimeRangeException {
        HTInterval dummy = new HTInterval(0L, t, 0, TmfStateValue.nullValue());
        int index = Collections.binarySearch(this.intervals, dummy);
        if (index < 0) {
            index = -index - 1;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= this.intervals.size()) {
            index = this.intervals.size() - 1;
        }
        while (index > 0 && this.intervals.get(index - 1).compareTo(this.intervals.get(index)) == 0) {
            --index;
        }
        return index;
    }

    private int getDataSectionEndOffset() {
        return this.getTotalHeaderSize() + HTNode.getDataEntrySize() * this.intervals.size();
    }

    int getNodeFreeSpace() {
        return this.stringSectionOffset - this.getDataSectionEndOffset();
    }

    long getNodeUsagePRC() {
        float freePercent = (float)this.getNodeFreeSpace() / (float)(this.ownerTree.config.blockSize - this.getTotalHeaderSize()) * 100.0f;
        return (long)(100.0f - freePercent);
    }

    protected static final int getDataEntrySize() {
        return 25;
    }

    protected static final byte boolToByte(boolean thebool) {
        if (thebool) {
            return 1;
        }
        return 0;
    }

    static final boolean byteToBool(byte thebyte) {
        return thebyte == 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Node #" + this.sequenceNumber + ", ");
        buf.append(this.toStringSpecific());
        buf.append(String.valueOf(this.intervals.size()) + " intervals (" + this.getNodeUsagePRC() + "% used), ");
        buf.append("[" + this.nodeStart + " - ");
        buf = this.isDone ? buf.append(this.nodeEnd + "]") : buf.append("...]");
        return buf.toString();
    }

    void debugPrintIntervals(PrintWriter writer) {
        writer.println("Node #" + this.sequenceNumber + ":");
        if (this.getNodeType() == 1) {
            CoreNode thisNode = (CoreNode)this;
            writer.print("  " + thisNode.getNbChildren() + " children");
            if (thisNode.getNbChildren() >= 1) {
                writer.print(": [ " + thisNode.getChild(0));
                int i = 1;
                while (i < thisNode.getNbChildren()) {
                    writer.print(", " + thisNode.getChild(i));
                    ++i;
                }
                writer.print(']');
            }
            writer.print('\n');
        }
        writer.println("  Intervals contained:");
        int i = 0;
        while (i < this.intervals.size()) {
            writer.println(this.intervals.get(i).toString());
            ++i;
        }
        writer.println('\n');
    }

    static final int getCommonHeaderSize() {
        return 34;
    }

    protected abstract byte getNodeType();

    protected abstract int getTotalHeaderSize();

    protected abstract void readSpecificHeader(ByteBuffer var1);

    protected abstract void writeSpecificHeader(ByteBuffer var1);

    protected abstract String toStringSpecific();
}

