/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.linuxtools.ctf.core.trace.CTFTraceReader;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class CtfIterator
extends CTFTraceReader
implements ITmfContext,
Comparable<CtfIterator>,
Cloneable {
    private final CtfTmfTrace ctfTmfTrace;
    public static final CtfLocation NULL_LOCATION = new CtfLocation(CtfLocation.INVALID_LOCATION);
    private CtfLocation curLocation;
    private long curRank;

    public CtfIterator(CtfTmfTrace trace) {
        super(trace.getCTFTrace());
        this.ctfTmfTrace = trace;
        if (this.hasMoreEvents()) {
            this.curLocation = new CtfLocation(trace.getStartTime());
            this.curRank = 0L;
        } else {
            this.setUnknownLocation();
        }
    }

    private void setUnknownLocation() {
        this.curLocation = NULL_LOCATION;
        this.curRank = -1L;
    }

    public CtfIterator(CtfTmfTrace trace, long timestampValue, long rank) {
        super(trace.getCTFTrace());
        this.ctfTmfTrace = trace;
        if (this.hasMoreEvents()) {
            this.curLocation = new CtfLocation(this.getCurrentEvent().getTimestampValue());
            if (this.getCurrentEvent().getTimestampValue() != timestampValue) {
                this.seek(timestampValue);
                this.curRank = rank;
            }
        } else {
            this.setUnknownLocation();
        }
    }

    public CtfTmfTrace getCtfTmfTrace() {
        return this.ctfTmfTrace;
    }

    public CtfTmfEvent getCurrentEvent() {
        StreamInputReader top = (StreamInputReader)this.prio.peek();
        if (top != null) {
            return new CtfTmfEvent(top.getCurrentEvent(), top.getFilename(), this.ctfTmfTrace);
        }
        return null;
    }

    public boolean seek(long timestamp) {
        boolean ret = false;
        long offsetTimestamp = timestamp - this.getCtfTmfTrace().getCTFTrace().getOffset();
        ret = offsetTimestamp < 0L ? super.seek(timestamp) : super.seek(offsetTimestamp);
        if (ret) {
            this.curLocation.setLocation(this.getCurrentEvent().getTimestampValue());
        } else {
            this.curLocation = NULL_LOCATION;
        }
        return ret;
    }

    public boolean seekRank(long rank) {
        boolean ret = false;
        ret = super.seekIndex(rank);
        if (ret) {
            this.curLocation.setLocation(this.getCurrentEvent().getTimestampValue());
        } else {
            this.curLocation = NULL_LOCATION;
        }
        return ret;
    }

    @Override
    public long getRank() {
        return this.curRank;
    }

    @Override
    public void setRank(long rank) {
        this.curRank = rank;
    }

    @Override
    public CtfIterator clone() {
        CtfIterator clone = null;
        clone = new CtfIterator(this.ctfTmfTrace, this.getCurrentEvent().getTimestampValue(), this.curRank);
        return clone;
    }

    @Override
    public void dispose() {
    }

    public void setLocation(ITmfLocation<?> location) {
        this.curLocation = (CtfLocation)location;
        this.seek(((CtfLocation)location).getLocation());
    }

    public CtfLocation getLocation() {
        return this.curLocation;
    }

    @Override
    public void increaseRank() {
        ++this.curRank;
    }

    @Override
    public boolean hasValidRank() {
        return this.getRank() >= 0L;
    }

    public boolean advance() {
        boolean ret = super.advance();
        if (ret) {
            this.curLocation.setLocation(this.getCurrentEvent().getTimestampValue());
        } else {
            this.curLocation = NULL_LOCATION;
        }
        return ret;
    }

    @Override
    public int compareTo(CtfIterator o) {
        if (this.getRank() < o.getRank()) {
            return -1;
        }
        if (this.getRank() > o.getRank()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ctfTmfTrace == null ? 0 : this.ctfTmfTrace.hashCode());
        result = 31 * result + (this.curLocation == null ? 0 : this.curLocation.hashCode());
        result = 31 * result + (int)(this.curRank ^ this.curRank >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CtfIterator)) {
            return false;
        }
        CtfIterator other = (CtfIterator)obj;
        if (this.ctfTmfTrace == null ? other.ctfTmfTrace != null : !this.ctfTmfTrace.equals(other.ctfTmfTrace)) {
            return false;
        }
        if (this.curLocation == null ? other.curLocation != null : !this.curLocation.equals(other.curLocation)) {
            return false;
        }
        return this.curRank == other.curRank;
    }
}

