/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.structures;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardMetaData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModuleFileFilter;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ModuleTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.ZipArchive;

public class DashboardModuleTreeBuilder {
    private TreeNode tree;
    public static ArrayList<String> moduleNames = new ArrayList();

    public DashboardModuleTreeBuilder() {
        this.tree = new TreeNode((Object)"Root", "", true);
    }

    public DashboardModuleTreeBuilder(TreeNode t) {
        this.tree = t;
    }

    public TreeNode getTree() {
        return this.tree;
    }

    public void generateTree(File folder) {
        this.scanNextLevel(folder);
    }

    private void scanNextLevel(File f) {
        File[] fs = f.listFiles(new DashboardModuleFileFilter());
        if (fs == null) {
            return;
        }
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isDirectory()) {
                this.scanNextLevel(fs[i]);
            } else {
                try {
                    File folder = new File("/tmp/systemtapgui//bundles/");
                    if (!folder.exists()) {
                        folder.mkdirs();
                    }
                    File file = new File(folder + "/" + fs[i].getName() + ".tmp");
                    file.createNewFile();
                    ZipArchive.uncompressFile((String)file.getAbsolutePath(), (String)fs[i].getAbsolutePath());
                    ZipArchive.unzipFiles((String)file.getAbsolutePath(), (String)folder.getAbsolutePath());
                    DashboardMetaData dmd = new DashboardMetaData(String.valueOf(folder.getAbsolutePath()) + "/metaData");
                    DashboardModule dm = dmd.getModule();
                    dm.archiveFile = fs[i];
                    int index = this.searchModuleNames(dm.category);
                    if (index == -1) {
                        moduleNames.add(dm.category);
                        DashboardView.addmodulename(dm.category);
                    }
                    TreeNode location = this.findInsertLocation(dm.category);
                    location.add((TreeNode)new ModuleTreeNode(dm, dm.display, true));
                    File[] files = folder.listFiles();
                    int j = 0;
                    while (j < files.length) {
                        files[j].delete();
                        ++j;
                    }
                    folder.delete();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
    }

    private TreeNode findInsertLocation(String path) {
        String[] folders = path.split("\\p{Punct}");
        TreeNode level = this.tree;
        int i = 0;
        while (i < folders.length) {
            int j = 0;
            while (j < level.getChildCount()) {
                if (level.getChildAt(j).toString().equals(folders[i])) break;
                ++j;
            }
            if (j >= level.getChildCount()) {
                level.add(new TreeNode((Object)"", folders[i], true));
            }
            level = level.getChildAt(j);
            ++i;
        }
        return level;
    }

    private int searchModuleNames(String moduleName) {
        if (moduleNames.size() > 0) {
            int i = 0;
            while (i < moduleNames.size()) {
                if (moduleName.equals(moduleNames.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

